/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.support.TemplateProcessor;
import alfio.manager.AccessService;
import alfio.manager.ExtensionManager;
import alfio.manager.FileUploadManager;
import alfio.manager.SubscriptionManager;
import alfio.manager.UploadedResourceManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.PriceContainer;
import alfio.model.PurchaseContext;
import alfio.model.UploadedResource;
import alfio.model.modification.UploadBase64FileModification;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.transaction.PaymentProxy;
import alfio.model.user.Organization;
import alfio.repository.EventRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.util.ClockProvider;
import alfio.util.LocaleUtil;
import alfio.util.TemplateManager;
import alfio.util.TemplateResource;
import com.samskivert.mustache.MustacheException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api"})
public class ResourceController {
    private static final Logger log = LoggerFactory.getLogger(ResourceController.class);
    private static final String TIMEZONE = "Europe/Zurich";
    private final UploadedResourceManager uploadedResourceManager;
    private final EventRepository eventRepository;
    private final MessageSourceManager messageSourceManager;
    private final TemplateManager templateManager;
    private final OrganizationRepository organizationRepository;
    private final FileUploadManager fileUploadManager;
    private final ExtensionManager extensionManager;
    private final ClockProvider clockProvider;
    private final SubscriptionManager subscriptionManager;
    private final AccessService accessService;

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public String handleSyntaxError(Exception ex) {
        log.warn("Exception in resource controller", (Throwable)ex);
        Optional<String> cause = Optional.ofNullable(ex.getCause()).filter(e -> e instanceof MustacheException || e instanceof TemplateProcessor.TemplateAccessException).map(Throwable::getMessage);
        return cause.orElse("Something went wrong. Please check the syntax and retry");
    }

    @GetMapping(value={"/overridable-template"})
    public List<TemplateResource> getOverridableTemplates() {
        return Stream.of(TemplateResource.values()).filter(TemplateResource::overridable).collect(Collectors.toList());
    }

    @GetMapping(value={"/overridable-template/{name}/{locale}"})
    public void getTemplate(@PathVariable TemplateResource name, @PathVariable String locale, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (InputStream is = new ClassPathResource(name.classPath()).getInputStream();){
            is.transferTo(os);
        }
        Locale loc = LocaleUtil.forLanguageTag((String)locale);
        String template = os.toString(StandardCharsets.UTF_8);
        response.setContentType("text/plain");
        response.getWriter().print(TemplateManager.translate((String)template, (Locale)loc, (MessageSource)this.messageSourceManager.getRootMessageSource()));
    }

    @PostMapping(value={"/overridable-template/{name}/{locale}/preview"})
    public void previewTemplate(@PathVariable TemplateResource name, @PathVariable String locale, @RequestParam(required=false, value="organizationId") Integer organizationId, @RequestParam(required=false, value="eventId") Integer eventId, @RequestParam(required=false, value="subscriptionDescriptorId") UUID subscriptionDescriptorId, @RequestBody UploadBase64FileModification template, Principal principal, HttpServletResponse response) throws IOException {
        Locale loc = LocaleUtil.forLanguageTag((String)locale);
        if (organizationId != null) {
            PurchaseContext purchaseContext = this.getPurchaseContext(organizationId.intValue(), eventId, subscriptionDescriptorId, principal, name);
            if (eventId != null || subscriptionDescriptorId != null) {
                this.accessService.checkPurchaseContextOwnership(principal, organizationId.intValue(), eventId, subscriptionDescriptorId);
            } else {
                this.accessService.checkOrganizationOwnership(principal, organizationId);
            }
            Organization organization = this.organizationRepository.getById(organizationId.intValue());
            Optional image = TemplateProcessor.extractImageModel((PurchaseContext)purchaseContext, (FileUploadManager)this.fileUploadManager);
            Map model = name.prepareSampleModel(organization, purchaseContext, image);
            String renderedTemplate = this.templateManager.renderString(purchaseContext, new String(name.replaceTokens(template.getFile())), model, loc, name.getTemplateOutput());
            if ("text/plain".equals(name.getRenderedContentType()) || "multipart/alternative".equals(name.getRenderedContentType())) {
                response.addHeader("Content-Disposition", "attachment; filename=" + name.name() + ".txt");
                response.setContentType("text/plain");
                response.setCharacterEncoding("UTF-8");
                try (ServletOutputStream os = response.getOutputStream();){
                    StreamUtils.copy((String)renderedTemplate, (Charset)StandardCharsets.UTF_8, (OutputStream)os);
                }
            } else if ("application/pdf".equals(name.getRenderedContentType())) {
                try (ServletOutputStream os = response.getOutputStream();){
                    response.setContentType("application/pdf");
                    response.addHeader("Content-Disposition", "attachment; filename=" + name.name() + ".pdf");
                    TemplateProcessor.renderToPdf((String)renderedTemplate, (OutputStream)os, (ExtensionManager)this.extensionManager, (PurchaseContext)purchaseContext, (FileUploadManager)this.fileUploadManager);
                }
            } else {
                throw new IllegalStateException("cannot enter here!");
            }
        }
    }

    private PurchaseContext getPurchaseContext(int organizationId, Integer eventId, UUID subscriptionDescriptorId, Principal principal, TemplateResource templateResource) {
        if (templateResource.getPurchaseContextType() == PurchaseContext.PurchaseContextType.event) {
            return this.getEvent(Integer.valueOf(organizationId), eventId, principal);
        }
        return this.getSubscriptionDescriptor(organizationId, subscriptionDescriptorId, principal);
    }

    private SubscriptionDescriptor getSubscriptionDescriptor(int organizationId, UUID subscriptionDescriptorId, Principal principal) {
        if (subscriptionDescriptorId != null) {
            return (SubscriptionDescriptor)this.subscriptionManager.getSubscriptionById(subscriptionDescriptorId).orElseThrow();
        }
        Function<String, Map> contentProducer = prefix -> ContentLanguage.ALL_LANGUAGES.stream().map(cl -> Map.entry(cl.getLanguage(), cl.getDisplayLanguage() + " " + prefix)).reduce(new HashMap(), (map, entry) -> {
            map.put((String)entry.getKey(), (String)entry.getValue());
            return map;
        }, (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        });
        this.checkAccess(organizationId, principal);
        ZoneId zoneId = ZoneId.of(TIMEZONE);
        return new SubscriptionDescriptor(UUID.randomUUID(), contentProducer.apply("title"), contentProducer.apply("description"), -1, ZonedDateTime.now(this.clockProvider.withZone(zoneId)), ZonedDateTime.now(this.clockProvider.withZone(zoneId)), ZonedDateTime.now(this.clockProvider.withZone(zoneId)).plusDays(1L), 100, new BigDecimal("7.7"), PriceContainer.VatStatus.INCLUDED, "CHF", true, organizationId, 1, SubscriptionDescriptor.SubscriptionValidityType.NOT_SET, null, Integer.valueOf(-1), ZonedDateTime.now(this.clockProvider.withZone(zoneId)), ZonedDateTime.now(this.clockProvider.withZone(zoneId)).plusDays(1L), SubscriptionDescriptor.SubscriptionUsageType.ONCE_PER_EVENT, "https://alf.io", "https://alf.io", null, List.of(PaymentProxy.STRIPE.name()), "42", TIMEZONE, Boolean.valueOf(true));
    }

    private Event getEvent(Integer organizationId, Integer eventId, Principal principal) {
        Event event;
        if (eventId != null) {
            this.checkAccess(organizationId.intValue(), eventId.intValue(), principal);
            event = this.eventRepository.findById(eventId.intValue());
        } else {
            this.checkAccess(organizationId.intValue(), principal);
            ZoneId zoneId = ZoneId.of(TIMEZONE);
            event = new Event(-1, Event.EventFormat.IN_PERSON, "TEST", "TEST", "TEST", "0", "0", ZonedDateTime.now(this.clockProvider.withZone(zoneId)), ZonedDateTime.now(this.clockProvider.withZone(zoneId)), TIMEZONE, "http://localhost", "http://localhost", null, "http://localhost", null, null, "CHF", BigDecimal.TEN, null, "42", organizationId.intValue(), ContentLanguage.ALL_LANGUAGES_IDENTIFIER, 0, PriceContainer.VatStatus.NONE, "1", Event.Status.PUBLIC);
        }
        return event;
    }

    @GetMapping(value={"/resource"})
    public List<UploadedResource> findAll(Principal principal) {
        this.checkAccess(principal);
        return this.uploadedResourceManager.findAll();
    }

    @GetMapping(value={"/resource-organization/{organizationId}"})
    public List<UploadedResource> findAllForOrganization(@PathVariable int organizationId, Principal principal) {
        this.checkAccess(organizationId, principal);
        return this.uploadedResourceManager.findAll(organizationId);
    }

    @GetMapping(value={"/resource-event/{organizationId}/{eventId}"})
    public List<UploadedResource> findAllForEvent(@PathVariable int organizationId, @PathVariable int eventId, Principal principal) {
        this.checkAccess(organizationId, eventId, principal);
        return this.uploadedResourceManager.findAll(organizationId, eventId);
    }

    @GetMapping(value={"/resource/{name}/metadata"})
    public ResponseEntity<UploadedResource> getMetadata(@PathVariable String name, Principal principal) {
        this.checkAccess(principal);
        if (this.uploadedResourceManager.hasResource(name)) {
            return new ResponseEntity((Object)this.uploadedResourceManager.get(name), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/resource-organization/{organizationId}/{name}/metadata"})
    public ResponseEntity<UploadedResource> getMetadata(@PathVariable int organizationId, @PathVariable String name, Principal principal) {
        this.checkAccess(organizationId, principal);
        if (this.uploadedResourceManager.hasResource(organizationId, name)) {
            return new ResponseEntity((Object)this.uploadedResourceManager.get(organizationId, name), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/resource-event/{organizationId}/{eventId}/{name}/metadata"})
    public ResponseEntity<UploadedResource> getMetadata(@PathVariable int organizationId, @PathVariable int eventId, @PathVariable String name, Principal principal) {
        this.checkAccess(organizationId, eventId, principal);
        if (this.uploadedResourceManager.hasResource(organizationId, eventId, name)) {
            return new ResponseEntity((Object)this.uploadedResourceManager.get(organizationId, eventId, name), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/resource"})
    public void uploadFile(@RequestBody UploadBase64FileModification upload, Principal principal) {
        this.checkAccess(principal);
        this.uploadedResourceManager.saveResource(upload).orElseThrow(IllegalArgumentException::new);
    }

    @PostMapping(value={"/resource-organization/{organizationId}"})
    public void uploadFile(@PathVariable int organizationId, @RequestBody UploadBase64FileModification upload, Principal principal) {
        this.checkAccess(organizationId, principal);
        this.uploadedResourceManager.saveResource(organizationId, upload).orElseThrow(IllegalArgumentException::new);
    }

    @PostMapping(value={"/resource-event/{organizationId}/{eventId}"})
    public void uploadFile(@PathVariable int organizationId, @PathVariable int eventId, @RequestBody UploadBase64FileModification upload, Principal principal) {
        this.checkAccess(organizationId, eventId, principal);
        this.uploadedResourceManager.saveResource(organizationId, eventId, upload).orElseThrow(IllegalArgumentException::new);
    }

    @GetMapping(value={"/resource/{name:.*}"})
    public void outputContent(@PathVariable String name, Principal principal, HttpServletResponse response) throws IOException {
        this.checkAccess(principal);
        if (!this.uploadedResourceManager.hasResource(name)) {
            response.sendError(404);
            return;
        }
        UploadedResource metadata = this.uploadedResourceManager.get(name);
        try (ServletOutputStream os = response.getOutputStream();){
            response.setContentType(metadata.getContentType());
            response.setContentLength(metadata.getContentSize());
            this.uploadedResourceManager.outputResource(name, (OutputStream)os);
        }
    }

    @GetMapping(value={"/resource-organization/{organizationId}/{name:.*}"})
    public void outputContent(@PathVariable int organizationId, @PathVariable String name, Principal principal, HttpServletResponse response) throws IOException {
        this.checkAccess(organizationId, principal);
        if (!this.uploadedResourceManager.hasResource(organizationId, name)) {
            response.sendError(404);
            return;
        }
        UploadedResource metadata = this.uploadedResourceManager.get(organizationId, name);
        try (ServletOutputStream os = response.getOutputStream();){
            response.setContentType(metadata.getContentType());
            response.setContentLength(metadata.getContentSize());
            this.uploadedResourceManager.outputResource(organizationId, name, (OutputStream)os);
        }
    }

    @GetMapping(value={"/resource-event/{organizationId}/{eventId}/{name:.*}"})
    public void outputContent(@PathVariable int organizationId, @PathVariable int eventId, @PathVariable String name, Principal principal, HttpServletResponse response) throws IOException {
        this.checkAccess(organizationId, eventId, principal);
        if (!this.uploadedResourceManager.hasResource(organizationId, eventId, name)) {
            response.sendError(404);
            return;
        }
        UploadedResource metadata = this.uploadedResourceManager.get(organizationId, eventId, name);
        try (ServletOutputStream os = response.getOutputStream();){
            response.setContentType(metadata.getContentType());
            response.setContentLength(metadata.getContentSize());
            this.uploadedResourceManager.outputResource(organizationId, eventId, name, (OutputStream)os);
        }
    }

    @DeleteMapping(value={"/resource/{name:.*}"})
    public void delete(@PathVariable String name, Principal principal) {
        this.checkAccess(principal);
        this.uploadedResourceManager.deleteResource(name);
    }

    @DeleteMapping(value={"/resource-organization/{organizationId}/{name:.*}"})
    public void delete(@PathVariable int organizationId, @PathVariable String name, Principal principal) {
        this.checkAccess(organizationId, principal);
        this.uploadedResourceManager.deleteResource(organizationId, name);
    }

    @DeleteMapping(value={"/resource-event/{organizationId}/{eventId}/{name:.*}"})
    public void delete(@PathVariable int organizationId, @PathVariable int eventId, @PathVariable String name, Principal principal) {
        this.checkAccess(organizationId, eventId, principal);
        this.uploadedResourceManager.deleteResource(organizationId, eventId, name);
    }

    private void checkAccess(Principal principal) {
        this.accessService.ensureAdmin(principal);
    }

    private void checkAccess(int organizationId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
    }

    private void checkAccess(int organizationId, int eventId, Principal principal) {
        this.accessService.checkEventOwnership(principal, eventId, organizationId);
    }

    @ConstructorProperties(value={"uploadedResourceManager", "eventRepository", "messageSourceManager", "templateManager", "organizationRepository", "fileUploadManager", "extensionManager", "clockProvider", "subscriptionManager", "accessService"})
    @Generated
    public ResourceController(UploadedResourceManager uploadedResourceManager, EventRepository eventRepository, MessageSourceManager messageSourceManager, TemplateManager templateManager, OrganizationRepository organizationRepository, FileUploadManager fileUploadManager, ExtensionManager extensionManager, ClockProvider clockProvider, SubscriptionManager subscriptionManager, AccessService accessService) {
        this.uploadedResourceManager = uploadedResourceManager;
        this.eventRepository = eventRepository;
        this.messageSourceManager = messageSourceManager;
        this.templateManager = templateManager;
        this.organizationRepository = organizationRepository;
        this.fileUploadManager = fileUploadManager;
        this.extensionManager = extensionManager;
        this.clockProvider = clockProvider;
        this.subscriptionManager = subscriptionManager;
        this.accessService = accessService;
    }
}

