/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.manager.AccessService;
import alfio.manager.SpecialPriceManager;
import alfio.model.SpecialPrice;
import alfio.model.modification.SendCodeModification;
import alfio.model.modification.UploadBase64FileModification;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api"})
public class SpecialPriceApiController {
    private static final Logger log = LoggerFactory.getLogger(SpecialPriceApiController.class);
    private final SpecialPriceManager specialPriceManager;
    private final AccessService accessService;

    public SpecialPriceApiController(SpecialPriceManager specialPriceManager, AccessService accessService) {
        this.specialPriceManager = specialPriceManager;
        this.accessService = accessService;
    }

    @ExceptionHandler
    @ResponseBody
    public ResponseEntity<String> handleExceptions(Exception e) {
        log.error("Unexpected exception in SpecialPriceApiController", (Throwable)e);
        if (!(e instanceof IllegalArgumentException)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.toString());
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
    }

    @PostMapping(value={"/events/{eventName}/categories/{categoryId}/link-codes"})
    public ResponseEntity<List<SendCodeModification>> linkAssigneeToCodes(@PathVariable String eventName, @PathVariable int categoryId, @RequestBody UploadBase64FileModification file, Principal principal) throws IOException {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)eventName));
        this.accessService.checkCategoryOwnership(principal, eventName, categoryId);
        try (InputStreamReader isr = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);){
            MappingIterator iterator = new CsvMapper().readerForListOf(String.class).with((FormatSchema)CsvSchema.emptySchema().withoutHeader()).with((FormatFeature)CsvParser.Feature.WRAP_AS_ARRAY).readValues((Reader)isr);
            List all = iterator.readAll();
            List<SendCodeModification> modificationList = all.stream().filter(l -> l.size() > 3).map(list -> new SendCodeModification(StringUtils.trimToNull((String)((String)list.get(0))), (String)list.get(1), (String)list.get(2), (String)list.get(3))).toList();
            ResponseEntity responseEntity = ResponseEntity.ok((Object)this.specialPriceManager.linkAssigneeToCode(modificationList, eventName, categoryId, principal.getName()));
            return responseEntity;
        }
    }

    @PostMapping(value={"/events/{eventName}/categories/{categoryId}/send-codes"})
    public boolean sendCodes(@PathVariable String eventName, @PathVariable int categoryId, @RequestBody List<SendCodeModification> codes, Principal principal) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)eventName));
        Objects.requireNonNull(codes);
        Validate.isTrue((!codes.isEmpty() ? 1 : 0) != 0, (String)"Collection of codes cannot be empty", (Object[])new Object[0]);
        this.specialPriceManager.sendCodeToAssignee(codes, eventName, categoryId, principal.getName());
        return true;
    }

    @GetMapping(value={"/events/{eventName}/categories/{categoryId}/sent-codes"})
    public List<SpecialPrice> loadSentCodes(@PathVariable String eventName, @PathVariable int categoryId, Principal principal) {
        return this.specialPriceManager.loadSentCodes(eventName, categoryId, principal.getName());
    }

    @DeleteMapping(value={"/events/{eventName}/categories/{categoryId}/codes/{codeId}/recipient"})
    public boolean clearRecipientData(@PathVariable String eventName, @PathVariable int categoryId, @PathVariable int codeId, Principal principal) {
        return this.specialPriceManager.clearRecipientData(eventName, categoryId, codeId, principal.getName());
    }
}

