/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.manager.AccessService;
import alfio.manager.SubscriptionManager;
import alfio.model.modification.SubscriptionDescriptorModification;
import alfio.model.result.Result;
import alfio.model.subscription.EventSubscriptionLink;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.subscription.SubscriptionDescriptorWithStatistics;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/admin/api/organization/{organizationId}/subscription"})
public class SubscriptionApiController {
    private final SubscriptionManager subscriptionManager;
    private final AccessService accessService;

    public SubscriptionApiController(SubscriptionManager subscriptionManager, AccessService accessService) {
        this.subscriptionManager = subscriptionManager;
        this.accessService = accessService;
    }

    @GetMapping(value={"/list"})
    ResponseEntity<List<SubscriptionDescriptorWithStatistics>> findAll(@PathVariable int organizationId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        return ResponseEntity.ok((Object)this.subscriptionManager.loadSubscriptionsWithStatistics(organizationId));
    }

    @GetMapping(value={"/active"})
    ResponseEntity<List<SubscriptionDescriptor>> findActive(@PathVariable int organizationId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        return ResponseEntity.ok((Object)this.subscriptionManager.loadActiveSubscriptionDescriptors(organizationId));
    }

    @GetMapping(value={"/{subscriptionId}"})
    ResponseEntity<SubscriptionDescriptorModification> getSingle(@PathVariable int organizationId, @PathVariable UUID subscriptionId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        return ResponseEntity.of(this.subscriptionManager.findOne(subscriptionId, organizationId).map(SubscriptionDescriptorModification::fromModel));
    }

    @PostMapping
    ResponseEntity<UUID> create(@PathVariable int organizationId, @RequestBody SubscriptionDescriptorModification subscriptionDescriptor, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        if (organizationId != subscriptionDescriptor.getOrganizationId()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        Result result = SubscriptionDescriptorModification.validate((SubscriptionDescriptorModification)subscriptionDescriptor);
        if (result.isSuccess()) {
            return ResponseEntity.of((Optional)this.subscriptionManager.createSubscriptionDescriptor(subscriptionDescriptor));
        }
        return ResponseEntity.badRequest().build();
    }

    @PostMapping(value={"/{subscriptionId}"})
    ResponseEntity<UUID> update(@PathVariable int organizationId, @PathVariable UUID subscriptionId, @RequestBody SubscriptionDescriptorModification subscriptionDescriptor, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        if (organizationId == subscriptionDescriptor.getOrganizationId() && subscriptionId.equals(subscriptionDescriptor.getId())) {
            return ResponseEntity.of((Optional)this.subscriptionManager.updateSubscriptionDescriptor(subscriptionDescriptor));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
    }

    @PatchMapping(value={"/{subscriptionId}/is-public"})
    ResponseEntity<Boolean> setPublicState(@PathVariable int organizationId, @PathVariable UUID subscriptionId, @RequestParam(value="status") boolean status, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        return ResponseEntity.ok((Object)this.subscriptionManager.setPublicStatus(subscriptionId, organizationId, status));
    }

    @GetMapping(value={"/{subscriptionId}/events"})
    ResponseEntity<List<EventSubscriptionLink>> getLinkedEvents(@PathVariable int organizationId, @PathVariable UUID subscriptionId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        return ResponseEntity.ok((Object)this.subscriptionManager.getLinkedEvents(organizationId, subscriptionId));
    }

    @DeleteMapping(value={"/{subscriptionId}"})
    ResponseEntity<Void> deactivate(@PathVariable int organizationId, @PathVariable(value="subscriptionId") UUID descriptorId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        return SubscriptionApiController.deactivateSubscriptionDescriptor((int)organizationId, (UUID)descriptorId, (SubscriptionManager)this.subscriptionManager);
    }

    public static ResponseEntity<Void> deactivateSubscriptionDescriptor(int organizationId, UUID descriptorId, SubscriptionManager subscriptionManager) {
        Result result = subscriptionManager.deactivateDescriptor(organizationId, descriptorId);
        if (result.isSuccess()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().build();
    }

    public static List<String> loadLinkedEvents(List<EventSubscriptionLink> eventSubscriptionLinks) {
        return eventSubscriptionLinks.stream().map(EventSubscriptionLink::getEventShortName).collect(Collectors.toList());
    }
}

