/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.manager.AccessService;
import alfio.manager.system.ConfigurationManager;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api/system/api-key"})
public class SystemApiKeyApiController {
    private static final Logger log = LoggerFactory.getLogger(SystemApiKeyApiController.class);
    private final ConfigurationManager configurationManager;
    private final AccessService accessService;

    public SystemApiKeyApiController(ConfigurationManager configurationManager, AccessService accessService) {
        this.configurationManager = configurationManager;
        this.accessService = accessService;
    }

    @GetMapping
    public ResponseEntity<String> retrieveApiKey(Principal principal) {
        this.accessService.ensureAdmin(principal);
        try {
            return ResponseEntity.ok((Object)this.configurationManager.retrieveSystemApiKey(false));
        }
        catch (RuntimeException e) {
            log.error("Error while retrieving system API Key", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @PutMapping
    public ResponseEntity<String> rotateApiKey(Principal principal) {
        this.accessService.ensureAdmin(principal);
        try {
            return ResponseEntity.ok((Object)this.configurationManager.retrieveSystemApiKey(true));
        }
        catch (RuntimeException e) {
            log.error("Error while rotating system API Key", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }
}

