/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.admin.UsersApiController;
import alfio.manager.AccessService;
import alfio.manager.FileUploadManager;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.user.UserManager;
import alfio.model.modification.OrganizationModification;
import alfio.model.modification.UserModification;
import alfio.model.result.ValidationResult;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.model.user.Role;
import alfio.model.user.User;
import alfio.model.user.UserWithOrganizations;
import alfio.model.user.UserWithPassword;
import alfio.util.ImageUtil;
import alfio.util.Json;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/admin/api"})
public class UsersApiController {
    private static final Logger log = LoggerFactory.getLogger(UsersApiController.class);
    private static final String OK = "OK";
    private final UserManager userManager;
    private final ConfigurationManager configurationManager;
    private final AccessService accessService;
    private final FileUploadManager fileUploadManager;

    public UsersApiController(UserManager userManager, ConfigurationManager configurationManager, AccessService accessService, FileUploadManager fileUploadManager) {
        this.userManager = userManager;
        this.configurationManager = configurationManager;
        this.accessService = accessService;
        this.fileUploadManager = fileUploadManager;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public String unhandledException(Exception e) {
        log.error("unhandled exception", (Throwable)e);
        return e != null ? e.getMessage() : "Unexpected error";
    }

    @GetMapping(value={"/roles"})
    public Collection<RoleDescriptor> getAllRoles(Principal principal) {
        return this.userManager.getAvailableRoles(principal.getName()).stream().map(RoleDescriptor::new).collect(Collectors.toList());
    }

    @GetMapping(value={"/user-type"})
    public String getLoggedUserType() {
        Set authorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().map(ga -> StringUtils.substringAfter((String)ga.getAuthority(), (String)"ROLE_")).collect(Collectors.toSet());
        if (authorities.contains("SPONSOR")) {
            return "SPONSOR";
        }
        if (authorities.contains("SUPERVISOR")) {
            return "SUPERVISOR";
        }
        return "OPERATOR";
    }

    @GetMapping(value={"/user/details"})
    public Map<String, String> retrieveDetails(Principal principal) {
        User user = this.userManager.findUserByUsername(principal.getName());
        HashMap<String, String> result = new HashMap<String, String>();
        boolean isApiKey = user.getType() == User.Type.API_KEY;
        result.put(isApiKey ? "apiKey" : "username", user.getUsername());
        if (!isApiKey) {
            result.put("firstName", user.getFirstName());
            result.put("lastName", user.getLastName());
        }
        result.put("description", user.getDescription());
        result.put("userType", this.getLoggedUserType());
        return result;
    }

    @GetMapping(value={"/organizations"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<Organization> getAllOrganizations(Principal principal) {
        return this.userManager.findUserOrganizations(principal.getName());
    }

    @GetMapping(value={"/organizations/{id}"})
    public Organization getOrganization(@PathVariable int id, Principal principal) {
        return this.userManager.findOrganizationById(id, principal.getName());
    }

    @GetMapping(value={"/users"})
    public List<UserWithOrganizations> getAllUsers(Principal principal) {
        return this.userManager.findAllUsers(principal.getName());
    }

    @PostMapping(value={"/api-keys/bulk"})
    public ResponseEntity<String> bulkCreate(@RequestBody BulkApiKeyCreation request, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(request.organizationId));
        this.userManager.bulkInsertApiKeys(request.organizationId, request.role, request.descriptions, principal);
        return ResponseEntity.ok((Object)"OK");
    }

    @PostMapping(value={"/organizations/new"})
    public String insertOrganization(@RequestBody OrganizationModification om, Principal principal) {
        this.accessService.ensureAdmin(principal);
        this.userManager.createOrganization(om, principal);
        return "OK";
    }

    @PostMapping(value={"/organizations/update"})
    public String updateOrganization(@RequestBody OrganizationModification om, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, om.getId());
        this.userManager.updateOrganization(om, principal);
        return "OK";
    }

    @PostMapping(value={"/organizations/check"})
    public ValidationResult validateOrganization(@RequestBody OrganizationModification om, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, om.getId());
        return this.userManager.validateOrganization(om, principal);
    }

    @PostMapping(value={"/organizations/validate-slug"})
    public ValidationResult validateSlug(@RequestBody OrganizationModification om, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, om.getId());
        return this.userManager.validateOrganizationSlug(om, principal);
    }

    @PostMapping(value={"/users/check"})
    public ValidationResult validateUser(@RequestBody UserModification userModification, Principal principal) {
        if (userModification.getType() == User.Type.API_KEY) {
            return ValidationResult.success();
        }
        if (userModification.getId() != null) {
            this.accessService.checkAccessToUser(principal, userModification.getId());
        }
        return this.userManager.validateUser(userModification.getId(), userModification.getUsername(), userModification.getFirstName(), userModification.getLastName(), userModification.getEmailAddress());
    }

    @PostMapping(value={"/users/edit"})
    public String editUser(@RequestBody UserModification userModification, Principal principal) {
        this.accessService.checkAccessToUser(principal, userModification.getId());
        this.userManager.editUser(userModification.getId().intValue(), userModification.getOrganizationId(), userModification.getUsername(), userModification.getFirstName(), userModification.getLastName(), userModification.getEmailAddress(), userModification.getDescription(), Role.valueOf((String)userModification.getRole()), principal);
        return "OK";
    }

    @PostMapping(value={"/users/new"})
    public UserWithPasswordAndQRCode insertUser(@RequestBody UserModification userModification, @RequestParam(value="baseUrl") String baseUrl, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(userModification.getOrganizationId()));
        Role requested = Role.valueOf((String)userModification.getRole());
        Validate.isTrue((boolean)this.userManager.getAvailableRoles(principal.getName()).stream().anyMatch(arg_0 -> requested.equals(arg_0)), (String)String.format("Requested role %s is not available for current user", userModification.getRole()), (Object[])new Object[0]);
        User.Type type = userModification.getType();
        UserWithPassword userWithPassword = this.userManager.insertUser(userModification.getOrganizationId(), userModification.getUsername(), userModification.getFirstName(), userModification.getLastName(), userModification.getEmailAddress(), requested, type == null ? User.Type.INTERNAL : type, userModification.getValidToAsDateTime(), userModification.getDescription(), principal);
        String qrCode = type != User.Type.API_KEY ? Base64.getEncoder().encodeToString(UsersApiController.generateQRCode((UserWithPassword)userWithPassword, (String)baseUrl)) : null;
        return new UserWithPasswordAndQRCode(userWithPassword, qrCode);
    }

    @GetMapping(value={"/api-keys/organization/{organizationId}/all"})
    public void getAllApiKeys(@PathVariable int organizationId, HttpServletResponse response, Principal principal) throws IOException {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=apiKeys.zip");
        String baseUrl = this.configurationManager.getForSystem(ConfigurationKeys.BASE_URL).getRequiredValue();
        try (ServletOutputStream os = response.getOutputStream();
             ZipOutputStream zipOS = new ZipOutputStream((OutputStream)os);){
            for (User user : this.userManager.findAllApiKeysFor(organizationId)) {
                Pair result = UsersApiController.generateApiKeyQRCode((User)user, (String)baseUrl, (FileUploadManager)this.fileUploadManager);
                zipOS.putNextEntry(new ZipEntry(user.getType().name() + "-" + (String)result.getLeft() + ".png"));
                StreamUtils.copy((byte[])((byte[])result.getRight()), (OutputStream)zipOS);
            }
        }
    }

    private static Pair<String, byte[]> generateApiKeyQRCode(User user, String baseUrl, FileUploadManager fileUploadManager) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("apiKey", user.getUsername());
        info.put("baseUrl", baseUrl);
        String description = Objects.toString(StringUtils.trimToNull((String)user.getDescription()), user.getUsername());
        return Pair.of((Object)description, (Object)ImageUtil.createQRCodeWithDescription((String)Json.GSON.toJson(info), (String)description, (FileUploadManager)fileUploadManager));
    }

    private static byte[] generateQRCode(UserWithPassword userWithPassword, String baseUrl) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("username", userWithPassword.getUsername());
        info.put("password", userWithPassword.getPassword());
        info.put("baseUrl", baseUrl);
        return ImageUtil.createQRCode((String)Json.GSON.toJson(info));
    }

    @DeleteMapping(value={"/users/{id}"})
    public String deleteUser(@PathVariable(value="id") int userId, Principal principal) {
        this.userManager.deleteUser(userId, principal);
        return "OK";
    }

    @PostMapping(value={"/users/{id}/enable/{enable}"})
    public String enableUser(@PathVariable(value="id") int userId, @PathVariable boolean enable, Principal principal) {
        this.userManager.enable(userId, enable, principal);
        return "OK";
    }

    @GetMapping(value={"/users/{id}"})
    public UserModification loadUser(@PathVariable(value="id") int userId, Principal principal) {
        User user = this.userManager.findUser(userId, principal);
        List userOrganizations = this.userManager.findUserOrganizations(user.getUsername());
        return new UserModification(Integer.valueOf(user.getId()), ((Organization)userOrganizations.get(0)).getId(), this.userManager.getUserRole(user).name(), user.getUsername(), user.getFirstName(), user.getLastName(), user.getEmailAddress(), user.getType(), user.getValidToEpochSecond(), user.getDescription());
    }

    @GetMapping(value={"/users/current"})
    public UserModification loadCurrentUser(Principal principal) {
        User user = this.userManager.findUserByUsername(principal.getName());
        Optional userOrganization = this.userManager.findUserOrganizations(user.getUsername()).stream().findFirst();
        return new UserModification(Integer.valueOf(user.getId()), userOrganization.map(Organization::getId).orElse(-1).intValue(), this.userManager.getUserRole(user).name(), user.getUsername(), user.getFirstName(), user.getLastName(), user.getEmailAddress(), user.getType(), user.getValidToEpochSecond(), user.getDescription());
    }

    @PostMapping(value={"/users/current/update-password"})
    public ValidationResult updateCurrentUserPassword(@RequestBody PasswordModification passwordModification, Principal principal) {
        return this.userManager.validateNewPassword(principal.getName(), passwordModification.oldPassword, passwordModification.newPassword, passwordModification.newPasswordConfirm).ifSuccess(() -> this.userManager.updateCurrentUserPassword(passwordModification.newPassword, principal));
    }

    @PostMapping(value={"/users/current/edit"})
    public void updateCurrentUser(@RequestBody UserModification userModification, Principal principal) {
        this.userManager.updateCurrentUserContactInfo(userModification.getFirstName(), userModification.getLastName(), userModification.getEmailAddress(), principal);
    }

    @PutMapping(value={"/users/{id}/reset-password"})
    public UserWithPasswordAndQRCode resetPassword(@PathVariable(value="id") int userId, @RequestParam(value="baseUrl") String baseUrl, Principal principal) {
        UserWithPassword userWithPassword = this.userManager.resetPassword(userId, principal);
        return new UserWithPasswordAndQRCode(userWithPassword, Base64.getEncoder().encodeToString(UsersApiController.generateQRCode((UserWithPassword)userWithPassword, (String)baseUrl)));
    }
}

