/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.admin;

import alfio.controller.api.support.CurrencyDescriptor;
import alfio.controller.api.support.TicketHelper;
import alfio.manager.EventNameManager;
import alfio.util.MustacheCustomTag;
import alfio.util.Wrappers;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.money.CurrencyUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/api/utils"})
public class UtilsApiController {
    private static final Logger log = LoggerFactory.getLogger(UtilsApiController.class);
    private static final List<String> CURRENCIES_BLACKLIST = Arrays.asList("USN", "USS", "CHE", "CHW");
    private final EventNameManager eventNameManager;
    private final String version;
    private final Environment environment;

    public UtilsApiController(EventNameManager eventNameManager, @Value(value="${alfio.version}") String version, Environment environment) {
        this.eventNameManager = eventNameManager;
        this.version = version;
        this.environment = environment;
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<String> handleMissingServletRequestParameterException(Exception e) {
        log.warn("missing parameters", (Throwable)e);
        return new ResponseEntity((Object)"missing parameters", (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/short-name/generate"})
    public String generateShortName(@RequestParam(value="displayName") String displayName) {
        return this.eventNameManager.generateShortName(displayName);
    }

    @PostMapping(value={"/short-name/validate"})
    public boolean validateShortName(@RequestParam(value="shortName") String shortName, HttpServletResponse response) {
        boolean unique = this.eventNameManager.isUnique(shortName);
        if (!unique) {
            response.setStatus(409);
        }
        return unique;
    }

    @GetMapping(value={"/render-commonmark"})
    public String renderCommonmark(@RequestParam(value="text") String input) {
        return MustacheCustomTag.renderToHtmlCommonmarkEscaped((String)input);
    }

    @GetMapping(value={"/alfio/info"})
    public Map<String, Object> getApplicationInfo(Principal principal) {
        HashMap<String, Object> applicationInfo = new HashMap<String, Object>();
        applicationInfo.put("version", this.version);
        applicationInfo.put("username", principal.getName());
        applicationInfo.put("isDemoMode", this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"demo"})));
        return applicationInfo;
    }

    @GetMapping(value={"/currencies"})
    public List<CurrencyDescriptor> getCurrencies() {
        return CurrencyUnit.registeredCurrencies().stream().filter(c -> !c.isPseudoCurrency() && !CURRENCIES_BLACKLIST.contains(c.getCode()) && Wrappers.optionally(() -> Currency.getInstance(c.getCode())).isPresent()).map(c -> new CurrencyDescriptor(c.getCode(), c.toCurrency().getDisplayName(Locale.ENGLISH), c.getSymbol(Locale.ENGLISH), c.getDecimalPlaces())).collect(Collectors.toList());
    }

    @GetMapping(value={"/countriesForVat"})
    public Map<String, String> getCountriesForVat() {
        return TicketHelper.getLocalizedCountriesForVat((Locale)Locale.ENGLISH).stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }
}

