/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.pass;

import alfio.manager.PassKitManager;
import alfio.model.EventAndOrganizationId;
import alfio.model.Ticket;
import alfio.util.ExportUtils;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pass/event/{eventName}/v1"})
public class PassKitApiController {
    private static final Logger log = LoggerFactory.getLogger(PassKitApiController.class);
    private final PassKitManager passKitManager;

    @GetMapping(value={"/version/passes/{passTypeIdentifier}/{serialNumber}"})
    public void getLatestVersion(@PathVariable String eventName, @PathVariable String passTypeIdentifier, @PathVariable String serialNumber, @RequestHeader(value="Authorization") String authorization, HttpServletResponse response) throws IOException {
        Optional validationResult = this.passKitManager.validateToken(eventName, passTypeIdentifier, serialNumber, authorization);
        if (validationResult.isEmpty()) {
            response.sendError(404);
        } else {
            Pair pair = (Pair)validationResult.get();
            this.writePassResponse(response, (EventAndOrganizationId)pair.getLeft(), (Ticket)pair.getRight(), false);
        }
    }

    @GetMapping(value={"/version/passes/{ticketUuid}"})
    public void downloadPassForTicket(@PathVariable String eventName, @PathVariable String ticketUuid, HttpServletResponse response) throws IOException {
        Optional ticketAndEventData = this.passKitManager.retrieveTicketDetails(eventName, ticketUuid);
        if (ticketAndEventData.isPresent()) {
            Pair pair = (Pair)ticketAndEventData.get();
            this.writePassResponse(response, (EventAndOrganizationId)pair.getKey(), (Ticket)pair.getValue(), true);
        } else {
            response.sendError(404);
        }
    }

    private void writePassResponse(HttpServletResponse response, EventAndOrganizationId eventAndOrganizationId, Ticket ticket, boolean addFilename) throws IOException {
        try (ServletOutputStream os = response.getOutputStream();){
            response.setContentType("application/vnd.apple.pkpass");
            if (addFilename) {
                response.setHeader("Content-Disposition", "attachment; filename=Passbook-" + ticket.getPublicUuid().toString().substring(0, 8) + ".pkpass");
                ExportUtils.markAsNoIndex((HttpServletResponse)response);
            }
            this.passKitManager.writePass(ticket, eventAndOrganizationId, (OutputStream)os);
        }
        catch (Exception e) {
            log.warn("Error during pass generation", (Throwable)e);
            response.sendError(500);
        }
    }

    @GetMapping(value={"/devices/*/registrations/*"})
    public ResponseEntity<Void> getRegisteredPasses() {
        log.trace("getRegisteredPasses called. Returning 204");
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/devices/*/registrations/*/*"})
    public ResponseEntity<Void> register() {
        log.trace("register called. Returning 200");
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/devices/*/registrations/*/*"})
    public ResponseEntity<Void> deleteRegistration() {
        log.trace("deleteRegistration called. Returning 200");
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/log"})
    public ResponseEntity<Void> log() {
        log.trace("log called. Returning 200");
        return ResponseEntity.ok().build();
    }

    @ConstructorProperties(value={"passKitManager"})
    @Generated
    public PassKitApiController(PassKitManager passKitManager) {
        this.passKitManager = passKitManager;
    }
}

