/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.support;

import alfio.controller.api.support.AdditionalField;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BookingInfoTicket {
    private final String uuid;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final String fullName;
    private final String userLanguage;
    private final boolean assigned;
    private final boolean locked;
    private final boolean acquired;
    private final boolean cancellationEnabled;
    private final boolean sendMailEnabled;
    private final boolean downloadEnabled;
    private final List<AdditionalField> ticketFieldConfiguration;
    private final Map<String, String> formattedOnlineCheckInDate;
    private final boolean onlineEventStarted;

    public BookingInfoTicket(String uuid, String firstName, String lastName, String email, String fullName, String userLanguage, boolean assigned, boolean locked, boolean acquired, boolean cancellationEnabled, boolean sendMailEnabled, boolean downloadEnabled, List<AdditionalField> ticketFieldConfiguration, Map<String, String> formattedOnlineCheckInDate, boolean onlineEventStarted) {
        this.uuid = uuid;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.fullName = fullName;
        this.userLanguage = userLanguage;
        this.assigned = assigned;
        this.locked = locked;
        this.acquired = acquired;
        this.cancellationEnabled = cancellationEnabled;
        this.sendMailEnabled = sendMailEnabled;
        this.downloadEnabled = downloadEnabled;
        this.ticketFieldConfiguration = ticketFieldConfiguration;
        this.formattedOnlineCheckInDate = formattedOnlineCheckInDate;
        this.onlineEventStarted = onlineEventStarted;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isAssigned() {
        return this.assigned;
    }

    public boolean isAcquired() {
        return this.acquired;
    }

    public String getUserLanguage() {
        return this.userLanguage;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isCancellationEnabled() {
        return this.cancellationEnabled;
    }

    public List<AdditionalField> getTicketFieldConfigurationBeforeStandard() {
        return this.ticketFieldConfiguration.stream().filter(AdditionalField::isBeforeStandardFields).collect(Collectors.toList());
    }

    public List<AdditionalField> getTicketFieldConfigurationAfterStandard() {
        return this.ticketFieldConfiguration.stream().filter(tv -> !tv.isBeforeStandardFields()).collect(Collectors.toList());
    }

    public Map<String, String> getFormattedOnlineCheckInDate() {
        return this.formattedOnlineCheckInDate;
    }

    public boolean isOnlineEventStarted() {
        return this.onlineEventStarted;
    }

    public boolean isSendMailEnabled() {
        return this.sendMailEnabled;
    }

    public boolean isDownloadEnabled() {
        return this.downloadEnabled;
    }
}

