/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.support;

import alfio.controller.api.support.AdditionalField;
import alfio.controller.api.support.BookingInfoTicket;
import alfio.controller.api.support.Description;
import alfio.controller.api.support.Field;
import alfio.controller.support.Formatters;
import alfio.manager.EventManager;
import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.FieldConfigurationDescriptionAndValue;
import alfio.model.LocalizedContent;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.PurchaseContextFieldDescription;
import alfio.model.PurchaseContextFieldValue;
import alfio.model.Ticket;
import alfio.model.metadata.OnlineConfiguration;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.util.ClockProvider;
import alfio.util.EventUtil;
import alfio.util.Validator;
import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class BookingInfoTicketLoader {
    private final EventManager eventManager;
    private final ConfigurationManager configurationManager;
    private final PurchaseContextFieldManager purchaseContextFieldManager;
    private final AdditionalServiceItemRepository additionalServiceItemRepository;
    private final TicketReservationManager ticketReservationManager;
    private final MessageSourceManager messageSourceManager;
    private final ClockProvider clockProvider;

    public BookingInfoTicket toBookingInfoTicket(Ticket ticket, Event event, Set<PurchaseContextFieldConfiguration.Context> contexts) {
        Map descriptionsByTicketFieldId = this.purchaseContextFieldManager.findDescriptionsGroupedByFieldId((PurchaseContext)event);
        Map valuesByTicketIds = this.purchaseContextFieldManager.findAllValuesByTicketId(Integer.valueOf(ticket.getId()));
        boolean hasPaidSupplement = this.ticketReservationManager.hasPaidSupplements(ticket.getEventId(), ticket.getTicketsReservationId());
        Map formattedDates = Map.of();
        boolean onlineEventStarted = false;
        if (event.isOnline()) {
            OnlineConfiguration eventConfiguration = this.eventManager.getMetadataForEvent((EventAndOrganizationId)event).getOnlineConfiguration();
            OnlineConfiguration ticketCategoryConfiguration = this.eventManager.getMetadataForCategory((EventAndOrganizationId)event, ticket.getCategoryId().intValue()).getOnlineConfiguration();
            ZonedDateTime checkInDate = EventUtil.firstMatchingCallLink((ZoneId)event.getZoneId(), (OnlineConfiguration)ticketCategoryConfiguration, (OnlineConfiguration)eventConfiguration).map(link -> link.getValidFrom().atZone(event.getZoneId())).orElse(event.getBegin());
            formattedDates = Formatters.getFormattedDate((LocalizedContent)event, (ZonedDateTime)checkInDate, (String)"common.ticket-category.date-format", (MessageSource)this.messageSourceManager.getMessageSourceFor((PurchaseContext)event));
            onlineEventStarted = event.now(this.clockProvider).isAfter(checkInDate);
        }
        return this.toBookingInfoTicket(ticket, hasPaidSupplement, event, this.getTicketFieldsFilterer(ticket.getTicketsReservationId(), event), descriptionsByTicketFieldId, valuesByTicketIds, formattedDates, onlineEventStarted, contexts);
    }

    public BookingInfoTicket toBookingInfoTicket(Ticket t, boolean hasPaidSupplement, Event event, Validator.AdditionalFieldsFilterer additionalFieldsFilterer, Map<Long, List<PurchaseContextFieldDescription>> descriptionsByTicketFieldId, Map<Integer, List<PurchaseContextFieldValue>> valuesByTicketIds, Map<String, String> formattedOnlineCheckInDate, boolean onlineEventStarted, Set<PurchaseContextFieldConfiguration.Context> contexts) {
        Map configuration = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.ALLOW_FREE_TICKETS_CANCELLATION, ConfigurationKeys.SEND_TICKETS_AUTOMATICALLY, ConfigurationKeys.ALLOW_TICKET_DOWNLOAD), ConfigurationLevel.ticketCategory((EventAndOrganizationId)event, (int)t.getCategoryId()));
        boolean cancellationEnabled = t.getFinalPriceCts() == 0 && !event.expired() && !hasPaidSupplement && ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.ALLOW_FREE_TICKETS_CANCELLATION)).getValueAsBooleanOrDefault() && (Boolean)this.eventManager.checkTicketCancellationPrerequisites().apply(t) != false;
        return BookingInfoTicketLoader.toBookingInfoTicket((Ticket)t, (boolean)cancellationEnabled, (boolean)((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.SEND_TICKETS_AUTOMATICALLY)).getValueAsBooleanOrDefault(), (boolean)((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.ALLOW_TICKET_DOWNLOAD)).getValueAsBooleanOrDefault(), (List)additionalFieldsFilterer.getFieldsForTicket(t.getPublicUuid(), contexts), descriptionsByTicketFieldId, valuesByTicketIds.getOrDefault(t.getId(), Collections.emptyList()), formattedOnlineCheckInDate, (boolean)onlineEventStarted);
    }

    public Validator.AdditionalFieldsFilterer getSubscriptionFieldsFilterer(String reservationId, SubscriptionDescriptor descriptor) {
        List fields = this.purchaseContextFieldManager.findAdditionalFields((PurchaseContext)descriptor);
        return new Validator.AdditionalFieldsFilterer(fields, List.of(), false, List.of());
    }

    public Validator.AdditionalFieldsFilterer getTicketFieldsFilterer(String reservationId, Event event) {
        List fields = this.purchaseContextFieldManager.findAdditionalFields((PurchaseContext)event);
        return new Validator.AdditionalFieldsFilterer(fields, this.ticketReservationManager.findTicketsInReservation(reservationId), event.supportsLinkedAdditionalServices(), this.additionalServiceItemRepository.findByReservationUuid(event.getId(), reservationId));
    }

    private static BookingInfoTicket toBookingInfoTicket(Ticket ticket, boolean cancellationEnabled, boolean sendMailEnabled, boolean downloadEnabled, List<PurchaseContextFieldConfiguration> ticketFields, Map<Long, List<PurchaseContextFieldDescription>> descriptionsByTicketFieldId, List<PurchaseContextFieldValue> purchaseContextFieldValues, Map<String, String> formattedOnlineCheckInDate, boolean onlineEventStarted) {
        Map<Long, List<PurchaseContextFieldValue>> valuesById = purchaseContextFieldValues.stream().collect(Collectors.groupingBy(PurchaseContextFieldValue::getFieldConfigurationId));
        List ticketFieldsAdditional = ticketFields.stream().filter(ticketFieldConfiguration -> ticketFieldConfiguration.getAdditionalServiceId() != null).sorted(Comparator.comparing(PurchaseContextFieldConfiguration::getOrder)).flatMap(tfc -> BookingInfoTicketLoader.toAdditionalFieldsStream((Map)descriptionsByTicketFieldId, (PurchaseContextFieldConfiguration)tfc, (Map)valuesById)).collect(Collectors.toList());
        return new BookingInfoTicket(ticket.getPublicUuid().toString(), ticket.getFirstName(), ticket.getLastName(), ticket.getEmail(), ticket.getFullName(), ticket.getUserLanguage(), ticket.getAssigned(), ticket.getLockedAssignment(), ticket.getStatus() == Ticket.TicketStatus.ACQUIRED, cancellationEnabled, sendMailEnabled, downloadEnabled, ticketFieldsAdditional, formattedOnlineCheckInDate, onlineEventStarted);
    }

    public static Stream<AdditionalField> toAdditionalFieldsStream(Map<Long, List<PurchaseContextFieldDescription>> descriptionsByTicketFieldId, PurchaseContextFieldConfiguration tfc, Map<Long, List<PurchaseContextFieldValue>> valuesById) {
        PurchaseContextFieldDescription tfd = descriptionsByTicketFieldId.get(tfc.getId()).get(0);
        List<PurchaseContextFieldValue> fieldValues = valuesById.get(tfc.getId());
        Map descriptions = BookingInfoTicketLoader.fromFieldDescriptions(descriptionsByTicketFieldId.get(tfc.getId()));
        if (fieldValues == null) {
            FieldConfigurationDescriptionAndValue t = new FieldConfigurationDescriptionAndValue(tfc, tfd, tfc.getCount(), null);
            return Stream.of(BookingInfoTicketLoader.toAdditionalField((FieldConfigurationDescriptionAndValue)t, (Map)descriptions));
        }
        return fieldValues.stream().map(fieldValue -> {
            FieldConfigurationDescriptionAndValue t = new FieldConfigurationDescriptionAndValue(tfc, tfd, tfc.getCount(), fieldValue.getValue());
            return BookingInfoTicketLoader.toAdditionalField((FieldConfigurationDescriptionAndValue)t, (Map)descriptions);
        });
    }

    public static AdditionalField toAdditionalField(FieldConfigurationDescriptionAndValue t, Map<String, Description> description) {
        List fields = t.getFields().stream().map(f -> new Field(f.getFieldIndex(), f.getFieldValue())).collect(Collectors.toList());
        List restrictedValues = t.getRestrictedValues().stream().filter(rv -> Objects.equals(t.getValue(), rv) || !t.getDisabledValues().contains(rv)).collect(Collectors.toList());
        return new AdditionalField(t.getName(), t.getValue(), t.getType(), t.isRequired(), t.isEditable(), t.getMinLength(), t.getMaxLength(), restrictedValues, fields, t.isBeforeStandardFields(), description);
    }

    public static Map<String, Description> fromFieldDescriptions(List<PurchaseContextFieldDescription> descs) {
        return descs.stream().collect(Collectors.toMap(PurchaseContextFieldDescription::getLocale, d -> new Description(d.getLabelDescription(), d.getPlaceholderDescription(), d.getRestrictedValuesDescription())));
    }

    @ConstructorProperties(value={"eventManager", "configurationManager", "purchaseContextFieldManager", "additionalServiceItemRepository", "ticketReservationManager", "messageSourceManager", "clockProvider"})
    @Generated
    public BookingInfoTicketLoader(EventManager eventManager, ConfigurationManager configurationManager, PurchaseContextFieldManager purchaseContextFieldManager, AdditionalServiceItemRepository additionalServiceItemRepository, TicketReservationManager ticketReservationManager, MessageSourceManager messageSourceManager, ClockProvider clockProvider) {
        this.eventManager = eventManager;
        this.configurationManager = configurationManager;
        this.purchaseContextFieldManager = purchaseContextFieldManager;
        this.additionalServiceItemRepository = additionalServiceItemRepository;
        this.ticketReservationManager = ticketReservationManager;
        this.messageSourceManager = messageSourceManager;
        this.clockProvider = clockProvider;
    }
}

