/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.support;

import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.system.ConfigurationKeys;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CspReportApiController {
    private static final Logger log = LoggerFactory.getLogger(CspReportApiController.class);
    private final ConfigurationManager configurationManager;

    @PostMapping(value={"/report-csp-violation"})
    public boolean logCspViolation(HttpServletRequest request) throws IOException {
        Map conf = this.configurationManager.getFor(Set.of(ConfigurationKeys.SECURITY_CSP_REPORT_ENABLED, ConfigurationKeys.SECURITY_CSP_REPORT_URI), ConfigurationLevel.system());
        boolean enabledReport = ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.SECURITY_CSP_REPORT_ENABLED)).getValueAsBooleanOrDefault();
        String uri = ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.SECURITY_CSP_REPORT_URI)).getValueOrDefault("/report-csp-violation");
        if (enabledReport && "/report-csp-violation".equals(uri)) {
            String report = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            log.warn("found csp violation: {}", (Object)report);
        }
        return true;
    }

    @ConstructorProperties(value={"configurationManager"})
    @Generated
    public CspReportApiController(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

