/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.support;

import alfio.controller.api.support.PublicEventDescription;
import alfio.model.Event;
import alfio.model.EventDescription;
import alfio.util.EventUtil;
import java.time.Clock;
import java.util.List;
import java.util.stream.Collectors;

public class EventListItem {
    private static final int API_VERSION = 205;
    protected final Event event;
    private final String requestContextPath;
    private final List<EventDescription> eventDescriptions;

    public EventListItem(Event event, String requestContextPath, List<EventDescription> eventDescriptions) {
        this.event = event;
        this.requestContextPath = requestContextPath;
        this.eventDescriptions = eventDescriptions;
    }

    public String getImageUrl() {
        return this.event.getFileBlobIdIsPresent() ? this.requestContextPath + "/file/" + this.event.getFileBlobId() : this.event.getImageUrl();
    }

    public String getUrl() {
        return this.requestContextPath + "/event/" + this.event.getShortName();
    }

    public String getName() {
        return this.event.getDisplayName();
    }

    public String getKey() {
        return this.event.getShortName();
    }

    public List<PublicEventDescription> getDescriptions() {
        return this.eventDescriptions.stream().map(PublicEventDescription::fromEventDescription).collect(Collectors.toList());
    }

    public boolean isOneDay() {
        return this.event.getSameDay();
    }

    public String getBegin() {
        return this.event.getBegin().withZoneSameInstant(Clock.systemUTC().getZone()).format(EventUtil.JSON_DATETIME_FORMATTER);
    }

    public String getEnd() {
        return this.event.getEnd().withZoneSameInstant(Clock.systemUTC().getZone()).format(EventUtil.JSON_DATETIME_FORMATTER);
    }

    public String getLocation() {
        return this.event.getLocation();
    }

    public String getLatitude() {
        return this.event.getLatitude();
    }

    public String getLongitude() {
        return this.event.getLongitude();
    }

    public String getTimeZone() {
        return this.event.getTimeZone();
    }

    public int getApiVersion() {
        return 205;
    }
}

