/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.support;

import alfio.controller.form.AdditionalServiceLinkForm;
import alfio.controller.form.UpdateTicketOwnerForm;
import alfio.controller.support.TemplateProcessor;
import alfio.manager.EuVatChecker;
import alfio.manager.ExtensionManager;
import alfio.manager.GroupManager;
import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.SameCountryValidator;
import alfio.manager.TicketReservationManager;
import alfio.manager.support.PartialTicketTextGenerator;
import alfio.manager.system.ConfigurationManager;
import alfio.model.AdditionalServiceItem;
import alfio.model.Event;
import alfio.model.FieldConfigurationDescriptionAndValue;
import alfio.model.LocalizedCountry;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.Ticket;
import alfio.model.TicketReservation;
import alfio.model.result.ValidationResult;
import alfio.model.user.Organization;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.TicketRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.util.EventUtil;
import alfio.util.LocaleUtil;
import alfio.util.ReservationUtil;
import alfio.util.TemplateManager;
import alfio.util.Validator;
import java.beans.ConstructorProperties;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TicketHelper {
    private static final Set<TicketReservation.TicketReservationStatus> PENDING_RESERVATION_STATUSES = EnumSet.of(TicketReservation.TicketReservationStatus.PENDING, TicketReservation.TicketReservationStatus.OFFLINE_PAYMENT);
    private final TicketReservationManager ticketReservationManager;
    private final OrganizationRepository organizationRepository;
    private final TicketRepository ticketRepository;
    private final TemplateManager templateManager;
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;
    private final PurchaseContextFieldManager purchaseContextFieldManager;
    private final AdditionalServiceItemRepository additionalServiceItemRepository;
    private final EuVatChecker vatChecker;
    private final GroupManager groupManager;
    private final ConfigurationManager configurationManager;
    private final ExtensionManager extensionManager;
    public static final Map<String, String> FIX_ISO_CODE_FOR_VAT = Collections.singletonMap("GR", "EL");

    public BiFunction<Ticket, Event, List<FieldConfigurationDescriptionAndValue>> buildRetrieveFieldValuesFunction(boolean formatValues) {
        return EventUtil.retrieveFieldValues((TicketRepository)this.ticketRepository, (PurchaseContextFieldManager)this.purchaseContextFieldManager, (AdditionalServiceItemRepository)this.additionalServiceItemRepository, (boolean)formatValues);
    }

    public Optional<Triple<ValidationResult, Event, Ticket>> assignTicket(String eventName, UUID ticketIdentifier, UpdateTicketOwnerForm updateTicketOwner, Optional<BindingResult> bindingResult, Locale fallbackLocale, Optional<UserDetails> userDetails, boolean addPrefix) {
        return this.ticketReservationManager.fetchComplete(eventName, ticketIdentifier).map(result -> this.assignTicket(updateTicketOwner, bindingResult, fallbackLocale, userDetails, result, (String)(addPrefix ? "tickets[" + ticketIdentifier + "]" : "")));
    }

    private Triple<ValidationResult, Event, Ticket> assignTicket(UpdateTicketOwnerForm updateTicketOwner, Optional<BindingResult> bindingResult, Locale fallbackLocale, Optional<UserDetails> userDetails, Triple<Event, TicketReservation, Ticket> result, String formPrefix) {
        Ticket t = (Ticket)result.getRight();
        Event event = (Event)result.getLeft();
        if (t.getLockedAssignment()) {
            updateTicketOwner.setFirstName(t.getFirstName());
            updateTicketOwner.setLastName(t.getLastName());
            updateTicketOwner.setFullName(t.getFullName());
            updateTicketOwner.setEmail(t.getEmail());
        }
        TicketReservation ticketReservation = (TicketReservation)result.getMiddle();
        List fieldConf = this.purchaseContextFieldRepository.findAdditionalFieldsForEvent(event.getId());
        SameCountryValidator sameCountryValidator = new SameCountryValidator(this.configurationManager, this.extensionManager, (PurchaseContext)event, ticketReservation.getId(), this.vatChecker);
        Validator.AdvancedTicketAssignmentValidator advancedValidator = new Validator.AdvancedTicketAssignmentValidator(sameCountryValidator, new GroupManager.WhitelistValidator(event.getId(), this.groupManager));
        List additionalServiceItems = this.additionalServiceItemRepository.findByReservationUuid(event.getId(), ticketReservation.getId());
        List ticketsInReservation = this.ticketRepository.findTicketsInReservation(ticketReservation.getId());
        Validator.AdditionalFieldsFilterer ticketFieldFilterer = new Validator.AdditionalFieldsFilterer(fieldConf, ticketsInReservation, event.supportsLinkedAdditionalServices(), additionalServiceItems);
        Validator.AdvancedValidationContext context = new Validator.AdvancedValidationContext(updateTicketOwner, fieldConf, t.getCategoryId().intValue(), t.getUuid(), formPrefix);
        ValidationResult validationResult = Validator.validateTicketAssignment((UpdateTicketOwnerForm)updateTicketOwner, (List)ticketFieldFilterer.getFieldsForTicket(t.getPublicUuid(), EnumSet.of(PurchaseContextFieldConfiguration.Context.ATTENDEE)), bindingResult, (Event)event, (String)formPrefix, (SameCountryValidator)sameCountryValidator, (ExtensionManager)this.extensionManager).or(this.validateAdditionalItemsFields(event, updateTicketOwner, t.getUuid(), ticketFieldFilterer.getFieldsForTicket(t.getPublicUuid(), EnumSet.of(PurchaseContextFieldConfiguration.Context.ADDITIONAL_SERVICE)), additionalServiceItems, (BindingResult)bindingResult.orElse(null), sameCountryValidator)).or(Validator.performAdvancedValidation((Validator.AdvancedTicketAssignmentValidator)advancedValidator, (Validator.AdvancedValidationContext)context, (Errors)bindingResult.orElse(null))).ifSuccess(() -> this.updateTicketOwner(updateTicketOwner, fallbackLocale, t, event, ticketReservation, userDetails));
        return Triple.of((Object)validationResult, (Object)event, (Object)ticketsInReservation.stream().filter(t2 -> t2.getUuid().equals(t.getUuid())).findFirst().orElseThrow());
    }

    private ValidationResult validateAdditionalItemsFields(Event event, UpdateTicketOwnerForm updateTicketOwner, String ticketUuid, List<PurchaseContextFieldConfiguration> fieldsForTicket, List<AdditionalServiceItem> additionalServiceItems, BindingResult bindingResult, SameCountryValidator vatValidator) {
        if (!event.supportsLinkedAdditionalServices() || fieldsForTicket.isEmpty() || bindingResult == null) {
            return ValidationResult.success();
        }
        Map map = Objects.requireNonNullElse(updateTicketOwner.getAdditionalServices(), Map.of());
        List fieldForms = Objects.requireNonNullElse((List)map.get(ticketUuid), List.of());
        int formFieldsSize = (int)fieldForms.stream().flatMap(f -> f.getAdditional().keySet().stream()).distinct().count();
        if (formFieldsSize != fieldsForTicket.size()) {
            bindingResult.reject("error.emptyField");
            return ValidationResult.failed((ValidationResult.ErrorDescriptor[])new ValidationResult.ErrorDescriptor[]{new ValidationResult.ErrorDescriptor("", "error.emptyField")});
        }
        if (formFieldsSize == 0) {
            return ValidationResult.success();
        }
        Set bookedItems = fieldForms.stream().map(AdditionalServiceLinkForm::getAdditionalServiceItemId).collect(Collectors.toSet());
        int count = this.additionalServiceItemRepository.countMatchingItemsForTicket(ticketUuid, bookedItems);
        ValidationResult result = count != bookedItems.size() ? ValidationResult.failed((ValidationResult.ErrorDescriptor[])new ValidationResult.ErrorDescriptor[]{new ValidationResult.ErrorDescriptor("", "error.emptyField")}) : ValidationResult.success();
        for (int i = 0; i < formFieldsSize; ++i) {
            AdditionalServiceLinkForm form = (AdditionalServiceLinkForm)fieldForms.get(i);
            result = result.or(Validator.validateAdditionalItemFieldsForTicket((AdditionalServiceLinkForm)form, fieldsForTicket, (BindingResult)bindingResult, (String)("additionalServices[" + ticketUuid + "][" + i + "]"), (SameCountryValidator)vatValidator, fieldForms, additionalServiceItems));
        }
        return result;
    }

    public Optional<Triple<ValidationResult, Event, Ticket>> preAssignTicket(String eventName, String reservationId, UUID publicTicketUUID, UpdateTicketOwnerForm updateTicketOwner, Optional<BindingResult> bindingResult, Locale fallbackLocale) {
        return this.ticketReservationManager.from(eventName, reservationId, publicTicketUUID).filter(temp -> PENDING_RESERVATION_STATUSES.contains(((TicketReservation)temp.getMiddle()).getStatus()) && ((Ticket)temp.getRight()).getStatus() == Ticket.TicketStatus.PENDING).map(result -> this.assignTicket(updateTicketOwner, bindingResult, fallbackLocale, Optional.empty(), result, "tickets[" + publicTicketUUID.toString() + "]"));
    }

    public Optional<Triple<ValidationResult, Event, Ticket>> assignTicket(String eventName, UUID ticketIdentifier, UpdateTicketOwnerForm updateTicketOwner, Optional<BindingResult> bindingResult, Locale locale) {
        return this.assignTicket(eventName, ticketIdentifier, updateTicketOwner, bindingResult, locale, Optional.empty(), false);
    }

    public Optional<Triple<ValidationResult, Event, Ticket>> directTicketAssignment(String eventName, String reservationId, String email, String fullName, String firstName, String lastName, String userLanguage, Optional<BindingResult> bindingResult, Locale locale) {
        List tickets = this.ticketReservationManager.findTicketsInReservation(reservationId);
        if (tickets.size() > 1) {
            return Optional.empty();
        }
        UUID ticketUuid = ((Ticket)tickets.get(0)).getPublicUuid();
        UpdateTicketOwnerForm form = new UpdateTicketOwnerForm();
        form.setAdditional(Collections.emptyMap());
        form.setEmail(email);
        form.setFullName(fullName);
        form.setFirstName(firstName);
        form.setLastName(lastName);
        form.setUserLanguage(userLanguage);
        return this.assignTicket(eventName, ticketUuid, form, bindingResult, locale);
    }

    public static List<Pair<String, String>> getLocalizedCountries(Locale locale) {
        return TicketHelper.mapISOCountries(Stream.of(Locale.getISOCountries()), (Locale)locale);
    }

    public static List<LocalizedCountry> getSortedLocalizedCountries(Locale locale) {
        return TicketHelper.sortCountries(TicketHelper.getLocalizedCountries((Locale)locale).stream());
    }

    public static List<LocalizedCountry> getSortedLocalizedVatCountries(Locale locale) {
        return TicketHelper.sortCountries(TicketHelper.getLocalizedCountriesForVat((Locale)locale).stream());
    }

    private static List<LocalizedCountry> sortCountries(Stream<Pair<String, String>> countries) {
        Collator collator = Collator.getInstance(Locale.FRENCH);
        return countries.map(pair -> new LocalizedCountry((String)pair.getKey(), (String)pair.getValue())).sorted((lc1, lc2) -> collator.compare(lc1.name(), lc2.name())).toList();
    }

    public static List<Pair<String, String>> getLocalizedEUCountriesForVat(Locale locale, String euCountries) {
        return TicketHelper.fixVAT((List)TicketHelper.mapISOCountries(Stream.of(Locale.getISOCountries()).filter(isoCode -> StringUtils.contains((CharSequence)euCountries, (CharSequence)isoCode) || "GR".equals(isoCode)), (Locale)locale));
    }

    public static List<Pair<String, String>> getLocalizedCountriesForVat(Locale locale) {
        return TicketHelper.fixVAT((List)TicketHelper.mapISOCountries(Stream.of(Locale.getISOCountries()), (Locale)locale));
    }

    private static List<Pair<String, String>> fixVAT(List<Pair<String, String>> countries) {
        return countries.stream().map(kv -> Pair.of((Object)FIX_ISO_CODE_FOR_VAT.getOrDefault(kv.getKey(), (String)kv.getKey()), (Object)((String)kv.getValue()))).collect(Collectors.toList());
    }

    private static List<Pair<String, String>> mapISOCountries(Stream<String> isoCountries, Locale locale) {
        return isoCountries.map(isoCode -> Pair.of((Object)isoCode, (Object)new Locale("", (String)isoCode).getDisplayCountry(locale))).sorted(Comparator.comparing(Pair::getRight)).collect(Collectors.toList());
    }

    private void updateTicketOwner(UpdateTicketOwnerForm updateTicketOwner, Locale fallBackLocale, Ticket t, Event event, TicketReservation ticketReservation, Optional<UserDetails> userDetails) {
        Locale language = Optional.ofNullable(updateTicketOwner.getUserLanguage()).filter(StringUtils::isNotBlank).map(LocaleUtil::forLanguageTag).orElse(fallBackLocale);
        Locale ticketLanguage = LocaleUtil.getTicketLanguage((Ticket)t, (Locale)fallBackLocale);
        this.ticketReservationManager.updateTicketOwner(t, language, event, updateTicketOwner, this.getConfirmationTextBuilder(ticketLanguage, event, ticketReservation, t), this.getOwnerChangeTextBuilder(ticketLanguage, t, event), userDetails);
        if (t.hasBeenSold() && !this.groupManager.findLinks(event.getId(), t.getCategoryId().intValue()).isEmpty()) {
            this.ticketRepository.forbidReassignment(Collections.singletonList(t.getId()));
        }
    }

    private PartialTicketTextGenerator getOwnerChangeTextBuilder(Locale ticketLanguage, Ticket t, Event event) {
        Organization organization = this.organizationRepository.getById(event.getOrganizationId());
        String ticketUrl = ReservationUtil.ticketUpdateUrl((Event)event, (Ticket)t, (ConfigurationManager)this.configurationManager);
        return TemplateProcessor.buildEmailForOwnerChange((Event)event, (Ticket)t, (Organization)organization, (String)ticketUrl, (TemplateManager)this.templateManager, (Locale)ticketLanguage);
    }

    public PartialTicketTextGenerator getConfirmationTextBuilder(Locale ticketLanguage, Event event, TicketReservation ticketReservation, Ticket ticket) {
        return this.ticketReservationManager.getTicketEmailGenerator(event, ticketReservation, ticketLanguage, this.ticketReservationManager.retrieveAttendeeAdditionalInfoForTicket(ticket));
    }

    @ConstructorProperties(value={"ticketReservationManager", "organizationRepository", "ticketRepository", "templateManager", "purchaseContextFieldRepository", "purchaseContextFieldManager", "additionalServiceItemRepository", "vatChecker", "groupManager", "configurationManager", "extensionManager"})
    @Generated
    public TicketHelper(TicketReservationManager ticketReservationManager, OrganizationRepository organizationRepository, TicketRepository ticketRepository, TemplateManager templateManager, PurchaseContextFieldRepository purchaseContextFieldRepository, PurchaseContextFieldManager purchaseContextFieldManager, AdditionalServiceItemRepository additionalServiceItemRepository, EuVatChecker vatChecker, GroupManager groupManager, ConfigurationManager configurationManager, ExtensionManager extensionManager) {
        this.ticketReservationManager = ticketReservationManager;
        this.organizationRepository = organizationRepository;
        this.ticketRepository = ticketRepository;
        this.templateManager = templateManager;
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
        this.purchaseContextFieldManager = purchaseContextFieldManager;
        this.additionalServiceItemRepository = additionalServiceItemRepository;
        this.vatChecker = vatChecker;
        this.groupManager = groupManager;
        this.configurationManager = configurationManager;
        this.extensionManager = extensionManager;
    }
}

