/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.support;

import alfio.manager.payment.StripeCreditCardManager;
import alfio.util.RequestUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/webhook"})
public class WebhookApiController {
    private final StripeCreditCardManager stripeCreditCardManager;

    @PostMapping(value={"/mollie/event/{eventName}/reservation/{reservationId}"})
    public void handleMollie(@PathVariable String eventName, @PathVariable String reservationId) {
    }

    @PostMapping(value={"/stripe/notification"})
    public ResponseEntity<Boolean> handleStripeMessage(@RequestHeader(value="Stripe-Signature", required=false) String stripeSignature, HttpServletRequest request) {
        return RequestUtils.readRequest((HttpServletRequest)request).flatMap(b -> this.stripeCreditCardManager.processWebhookEvent(b, stripeSignature)).filter(b -> b).map(ResponseEntity::ok).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST));
    }

    @ConstructorProperties(value={"stripeCreditCardManager"})
    @Generated
    public WebhookApiController(StripeCreditCardManager stripeCreditCardManager) {
        this.stripeCreditCardManager = stripeCreditCardManager;
    }
}

