/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v1;

import alfio.controller.api.v1.AttendeeApiController;
import alfio.manager.AccessService;
import alfio.manager.AttendeeManager;
import alfio.manager.support.SponsorAttendeeData;
import alfio.manager.support.TicketAndCheckInResult;
import alfio.model.result.Result;
import alfio.model.support.TicketWithAdditionalFields;
import alfio.repository.SponsorScanRepository;
import alfio.util.EventUtil;
import alfio.util.Wrappers;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/attendees"})
public class AttendeeApiController {
    public static final String ALFIO_OPERATOR_HEADER = "Alfio-Operator";
    private static final Logger log = LoggerFactory.getLogger(AttendeeApiController.class);
    private final AttendeeManager attendeeManager;
    private final AccessService accessService;

    @Autowired
    public AttendeeApiController(AttendeeManager attendeeManager, AccessService accessService) {
        this.attendeeManager = attendeeManager;
        this.accessService = accessService;
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class, IllegalArgumentException.class})
    public ResponseEntity<String> handleDataIntegrityException(Exception e) {
        log.warn("bad input detected", (Throwable)e);
        return new ResponseEntity((Object)"bad input parameters", (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<String> handleGenericException(RuntimeException e) {
        log.error("unexpected exception", (Throwable)e);
        return new ResponseEntity((Object)"unexpected error", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @PostMapping(value={"/sponsor-scan"})
    public ResponseEntity<TicketAndCheckInResult> scanBadge(@RequestBody SponsorScanRequest request, Principal principal, @RequestHeader(name="Alfio-Operator", required=false) String operator) {
        return ResponseEntity.ok((Object)this.attendeeManager.registerSponsorScan(request.eventName, request.ticketIdentifier, request.notes, request.leadStatus, principal.getName(), operator, request.timestamp));
    }

    @PostMapping(value={"/sponsor-scan/bulk"})
    public ResponseEntity<List<TicketAndCheckInResult>> scanBadges(@RequestBody List<SponsorScanRequest> requests, Principal principal, @RequestHeader(name="Alfio-Operator", required=false) String operator) {
        String username = principal.getName();
        return ResponseEntity.ok(requests.stream().map(request -> this.attendeeManager.registerSponsorScan(request.eventName, request.ticketIdentifier, request.notes, request.leadStatus, username, operator, request.timestamp)).collect(Collectors.toList()));
    }

    @GetMapping(value={"/{eventKey}/sponsor-scan/mine"})
    public ResponseEntity<List<SponsorAttendeeData>> getScannedBadges(@PathVariable(value="eventKey") String eventShortName, @RequestParam(value="from", required=false) String from, Principal principal) {
        ZonedDateTime start = Optional.ofNullable(StringUtils.trimToNull((String)from)).map(EventUtil.JSON_DATETIME_FORMATTER::parse).flatMap(d -> Wrappers.safeSupplier(() -> ZonedDateTime.of(LocalDateTime.from(d), ZoneOffset.UTC))).orElse(SponsorScanRepository.DEFAULT_TIMESTAMP);
        this.accessService.canAccessEvent(principal, eventShortName);
        return this.attendeeManager.retrieveScannedAttendees(eventShortName, principal.getName(), start).map(ResponseEntity::ok).orElse(AttendeeApiController.notFound());
    }

    @GetMapping(value={"/{eventKey}/ticket/{UUID}"})
    public ResponseEntity<TicketWithAdditionalFields> getTicketDetails(@PathVariable(value="eventKey") String eventShortName, @PathVariable(value="UUID") String uuid, Principal principal) {
        this.accessService.canAccessTicket(principal, eventShortName, uuid);
        Result result = this.attendeeManager.retrieveTicket(eventShortName, uuid, principal.getName());
        if (result.isSuccess()) {
            return ResponseEntity.ok((Object)((TicketWithAdditionalFields)result.getData()));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
    }

    private static <T> ResponseEntity<T> notFound() {
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

