/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v1.admin;

import alfio.manager.AccessService;
import alfio.manager.PurchaseContextManager;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.user.UserManager;
import alfio.model.Event;
import alfio.model.PurchaseContext;
import alfio.model.modification.ConfigurationModification;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.system.Configuration;
import alfio.model.system.ConfigurationKeys;
import alfio.model.system.ConfigurationPathLevel;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/admin/configuration"})
public class ConfigurationApiV1Controller {
    private final ConfigurationManager configurationManager;
    private final AccessService accessService;
    private final PurchaseContextManager purchaseContextManager;
    private final UserManager userManager;

    public ConfigurationApiV1Controller(ConfigurationManager configurationManager, PurchaseContextManager purchaseContextManager, UserManager userManager, AccessService accessService) {
        this.configurationManager = configurationManager;
        this.accessService = accessService;
        this.purchaseContextManager = purchaseContextManager;
        this.userManager = userManager;
    }

    @PutMapping(value={"/organization/{organizationId}"})
    public ResponseEntity<String> saveConfigurationForOrganization(@PathVariable int organizationId, @RequestBody Map<String, String> configurationKeyValues, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        Set configurationKeys = configurationKeyValues.keySet().stream().map(ConfigurationKeys::safeValueOf).collect(Collectors.toSet());
        Optional validationErrorOptional = this.validateInput(ConfigurationPathLevel.ORGANIZATION, configurationKeyValues, configurationKeys);
        if (validationErrorOptional.isPresent()) {
            return (ResponseEntity)validationErrorOptional.get();
        }
        Map<String, Integer> existingIds = this.configurationManager.loadOrganizationConfig(organizationId, principal.getName()).values().stream().flatMap(Collection::stream).filter(c -> configurationKeys.contains(c.getConfigurationKey())).collect(Collectors.toMap(Configuration::getKey, Configuration::getId));
        List toSave = configurationKeyValues.entrySet().stream().map(ckv -> new ConfigurationModification((Integer)existingIds.get(ckv.getKey()), (String)ckv.getKey(), (String)ckv.getValue())).collect(Collectors.toList());
        this.configurationManager.saveAllOrganizationConfiguration(organizationId, toSave, principal.getName());
        return ResponseEntity.ok().body((Object)"OK");
    }

    @PutMapping(value={"/organization/{organizationId}/{purchaseContextType}/{publicIdentifier}"})
    public ResponseEntity<String> saveConfigurationForPurchaseContext(@PathVariable int organizationId, @PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @RequestBody Map<String, String> configurationKeyValues, Principal principal) {
        Set configurationKeys = configurationKeyValues.keySet().stream().map(ConfigurationKeys::safeValueOf).collect(Collectors.toSet());
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        Optional validationErrorOptional = this.validateInput(ConfigurationPathLevel.PURCHASE_CONTEXT, configurationKeyValues, configurationKeys);
        if (validationErrorOptional.isPresent()) {
            return (ResponseEntity)validationErrorOptional.get();
        }
        Optional purchaseContextOptional = this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier);
        if (purchaseContextOptional.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        PurchaseContext purchaseContext = (PurchaseContext)purchaseContextOptional.get();
        if (purchaseContext.getOrganizationId() != organizationId) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            int eventId = ((Event)purchaseContext).getId();
            Map<String, Integer> existingIds = this.configurationManager.loadEventConfig(eventId, principal.getName()).values().stream().flatMap(Collection::stream).filter(c -> configurationKeys.contains(c.getConfigurationKey())).collect(Collectors.toMap(Configuration::getKey, Configuration::getId));
            List toSave = configurationKeyValues.entrySet().stream().map(ckv -> new ConfigurationModification((Integer)existingIds.get(ckv.getKey()), (String)ckv.getKey(), (String)ckv.getValue())).collect(Collectors.toList());
            this.configurationManager.saveAllEventConfiguration(eventId, organizationId, toSave, principal.getName());
        } else {
            SubscriptionDescriptor sd = (SubscriptionDescriptor)purchaseContext;
            Map<String, Integer> existingIds = this.configurationManager.loadSubscriptionDescriptorConfig(sd, principal.getName()).values().stream().flatMap(Collection::stream).filter(c -> configurationKeys.contains(c.getConfigurationKey())).collect(Collectors.toMap(Configuration::getKey, Configuration::getId));
            List toSave = configurationKeyValues.entrySet().stream().map(ckv -> new ConfigurationModification((Integer)existingIds.get(ckv.getKey()), (String)ckv.getKey(), (String)ckv.getValue())).collect(Collectors.toList());
            this.configurationManager.saveAllSubscriptionDescriptorConfiguration(sd, toSave, principal.getName());
        }
        return ResponseEntity.ok().body((Object)"OK");
    }

    private Optional<ResponseEntity<String>> validateInput(ConfigurationPathLevel configurationPathLevel, Map<String, String> configurationKeyValues, Set<ConfigurationKeys> configurationKeys) {
        if (configurationKeys.size() != configurationKeyValues.size()) {
            return Optional.of(ResponseEntity.badRequest().body((Object)"Request contains duplicate keys"));
        }
        if (configurationKeys.contains(ConfigurationKeys.NOT_RECOGNIZED)) {
            return Optional.of(ResponseEntity.badRequest().body((Object)"Request contains unrecognized keys"));
        }
        if (configurationKeys.stream().anyMatch(c -> c.isInternal() || !c.supports(configurationPathLevel))) {
            return Optional.of(ResponseEntity.badRequest().body((Object)"Request contains internal settings"));
        }
        return Optional.empty();
    }
}

