/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v1.admin;

import alfio.controller.api.admin.EventApiController;
import alfio.extension.ExtensionService;
import alfio.manager.AccessService;
import alfio.manager.CheckInManager;
import alfio.manager.EventManager;
import alfio.manager.EventNameManager;
import alfio.manager.EventStatisticsManager;
import alfio.manager.FileDownloadManager;
import alfio.manager.FileUploadManager;
import alfio.manager.GroupManager;
import alfio.manager.system.AdminJobExecutor;
import alfio.manager.system.AdminJobManager;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.user.UserManager;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventWithAdditionalInfo;
import alfio.model.ExtensionSupport;
import alfio.model.PromoCodeDiscount;
import alfio.model.TicketCategoryWithAdditionalInfo;
import alfio.model.api.v1.admin.CheckInLogEntry;
import alfio.model.api.v1.admin.EventCreationRequest;
import alfio.model.api.v1.admin.LinkedSubscription;
import alfio.model.group.Group;
import alfio.model.modification.EventModification;
import alfio.model.modification.LinkedGroupModification;
import alfio.model.modification.TicketCategoryModification;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.result.ValidationResult;
import alfio.model.subscription.EventSubscriptionLink;
import alfio.model.subscription.LinkSubscriptionsToEventRequest;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.ExtensionRepository;
import alfio.util.Json;
import alfio.util.Validator;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/admin/event"})
public class EventApiV1Controller {
    private static final Logger log = LoggerFactory.getLogger(EventApiV1Controller.class);
    private final EventManager eventManager;
    private final EventNameManager eventNameManager;
    private final FileUploadManager fileUploadManager;
    private final FileDownloadManager fileDownloadManager;
    private final UserManager userManager;
    private final EventStatisticsManager eventStatisticsManager;
    private final GroupManager groupManager;
    private final ExtensionService extensionService;
    private final ExtensionRepository extensionRepository;
    private final ConfigurationManager configurationManager;
    private final AdminJobManager adminJobManager;
    private final CheckInManager checkInManager;
    private final AccessService accessService;

    @PostMapping(value={"/create"})
    @Transactional
    public ResponseEntity<String> create(@RequestBody EventCreationRequest request, Principal user) {
        String imageRef = Optional.ofNullable(request.getImageUrl()).map(arg_0 -> this.fetchImage(arg_0)).orElse(null);
        Organization organization = (Organization)this.userManager.findUserOrganizations(user.getName()).get(0);
        AtomicReference errorsContainer = new AtomicReference();
        Result result = new Result.Builder().checkPrecondition(() -> StringUtils.isNotBlank((CharSequence)request.getTitle()), ErrorCode.custom((String)"invalid.title", (String)"Invalid title")).checkPrecondition(() -> StringUtils.isBlank((CharSequence)request.getSlug()) || this.eventNameManager.isUnique(request.getSlug()), ErrorCode.custom((String)"invalid.slug", (String)"Invalid slug")).checkPrecondition(() -> StringUtils.isNotBlank((CharSequence)request.getWebsiteUrl()), ErrorCode.custom((String)"invalid.websiteUrl", (String)"Invalid Website URL")).checkPrecondition(() -> StringUtils.isNotBlank((CharSequence)request.getTermsAndConditionsUrl()), ErrorCode.custom((String)"invalid.tc", (String)"Invalid Terms and Conditions")).checkPrecondition(() -> StringUtils.isNotBlank((CharSequence)request.getImageUrl()), ErrorCode.custom((String)"invalid.imageUrl", (String)"Invalid Image URL")).checkPrecondition(() -> StringUtils.isNotBlank((CharSequence)request.getTimezone()), ErrorCode.custom((String)"invalid.timezone", (String)"Invalid Timezone")).checkPrecondition(() -> StringUtils.isNotBlank((CharSequence)imageRef), ErrorCode.custom((String)"invalid.image", (String)"Image is either missing or too big (max 200kb)")).checkPrecondition(() -> this.validateCategoriesSalesPeriod(request), ErrorCode.custom((String)"invalid.categories", (String)"Ticket categories: sales period not compatible with event dates")).checkPrecondition(() -> this.validateAdditionalFields(request), ErrorCode.custom((String)"invalid.additionalInfo", (String)"Additional info not valid")).checkPrecondition(() -> {
            EventModification eventModification = request.toEventModification(organization, arg_0 -> ((EventNameManager)this.eventNameManager).generateShortName(arg_0), imageRef);
            errorsContainer.set(new BeanPropertyBindingResult((Object)eventModification, "event"));
            int descriptionMaxLength = this.configurationManager.getFor(ConfigurationKeys.DESCRIPTION_MAXLENGTH, ConfigurationLevel.system()).getValueAsIntOrDefault(4096);
            ValidationResult validationResult = EventApiController.validateEvent((EventModification)eventModification, (Errors)((Errors)errorsContainer.get()), (int)descriptionMaxLength);
            if (!validationResult.isSuccess()) {
                log.warn("validation failed {}", (Object)validationResult.getValidationErrors());
            }
            return validationResult.isSuccess();
        }, ErrorCode.lazy(() -> this.toErrorCode((Errors)errorsContainer.get()))).build(() -> (String)this.insertEvent(request, user, imageRef).orElseThrow(IllegalStateException::new));
        if (result.isSuccess()) {
            return ResponseEntity.ok((Object)((String)result.getData()));
        }
        return ResponseEntity.badRequest().body((Object)Json.toJson((Object)result.getErrors()));
    }

    private boolean validateAdditionalFields(EventCreationRequest request) {
        return request.getAdditionalInfo().isEmpty() || request.getAdditionalInfo().stream().allMatch(f -> Validator.validateAdditionalInfoName((String)f.getName()));
    }

    private boolean validateCategoriesSalesPeriod(EventCreationRequest request) {
        LocalDateTime eventEnd = request.getEndDate();
        return request.getTickets().getCategories().stream().allMatch(tc -> tc.getStartSellingDate().isBefore(tc.getEndSellingDate()) && tc.getEndSellingDate().isBefore(eventEnd));
    }

    private ErrorCode toErrorCode(Errors errors) {
        return errors.getFieldErrors().stream().map(e -> ErrorCode.custom((String)e.getField(), (String)e.getCode())).findFirst().orElse((ErrorCode)ErrorCode.EventError.NOT_FOUND);
    }

    @GetMapping(value={"/{slug}/stats"})
    public ResponseEntity<EventWithAdditionalInfo> stats(@PathVariable String slug, Principal user) {
        this.accessService.checkEventOwnership(user, slug);
        Result result = new Result.Builder().build(() -> this.eventStatisticsManager.getEventWithAdditionalInfo(slug, user.getName()));
        if (result.isSuccess()) {
            return ResponseEntity.ok((Object)((EventWithAdditionalInfo)result.getData()));
        }
        return ResponseEntity.badRequest().build();
    }

    @DeleteMapping(value={"/{slug}"})
    public ResponseEntity<String> delete(@PathVariable String slug, Principal user) {
        this.accessService.checkEventOwnership(user, slug);
        Result result = new Result.Builder().build(() -> {
            this.eventManager.getOptionalEventAndOrganizationIdByName(slug, user.getName()).ifPresent(e -> this.eventManager.deleteEvent(e.getId(), user.getName()));
            return "Ok";
        });
        if (result.isSuccess()) {
            return ResponseEntity.ok((Object)((String)result.getData()));
        }
        return ResponseEntity.badRequest().build();
    }

    @PostMapping(value={"/update/{slug}"})
    @Transactional
    public ResponseEntity<String> update(@PathVariable String slug, @RequestBody EventCreationRequest request, Principal user) {
        this.accessService.checkEventOwnership(user, slug);
        String imageRef = this.fetchImage(request.getImageUrl());
        Result result = new Result.Builder().build(() -> this.updateEvent(slug, request, user, imageRef).map(Event::getShortName).orElseThrow());
        if (result.isSuccess()) {
            return ResponseEntity.ok((Object)((String)result.getData()));
        }
        return ResponseEntity.badRequest().build();
    }

    @GetMapping(value={"/{slug}/subscriptions"})
    public ResponseEntity<LinkedSubscription> getLinkedSubscriptions(@PathVariable String slug, Principal user) {
        EventAndOrganizationId event = this.accessService.checkEventOwnership(user, slug);
        return ResponseEntity.ok((Object)this.retrieveLinkedSubscriptionsForEvent(slug, event.getId(), event.getOrganizationId()));
    }

    @PutMapping(value={"/{slug}/subscriptions"})
    public ResponseEntity<LinkedSubscription> updateLinkedSubscriptions(@PathVariable String slug, @RequestBody List<LinkSubscriptionsToEventRequest> subscriptions, Principal user) {
        EventAndOrganizationId eventAndOrgId = this.accessService.checkDescriptorsLinkRequest(user, slug, subscriptions);
        this.eventManager.updateLinkedSubscriptions(subscriptions, eventAndOrgId.getId(), eventAndOrgId.getOrganizationId());
        return ResponseEntity.ok((Object)this.retrieveLinkedSubscriptionsForEvent(slug, eventAndOrgId.getId(), eventAndOrgId.getOrganizationId()));
    }

    @PostMapping(value={"/{slug}/generate-subscribers-tickets"})
    public ResponseEntity<Boolean> generateTicketsForSubscribers(@PathVariable String slug, Principal user) {
        EventAndOrganizationId eventAndOrganizationId = this.accessService.checkEventOwnership(user, slug);
        Map<String, Boolean> params = Map.of("eventId", eventAndOrganizationId.getId(), "organizationId", eventAndOrganizationId.getOrganizationId(), "forceGeneration", true);
        return ResponseEntity.ok((Object)this.adminJobManager.scheduleExecution(AdminJobExecutor.JobName.ASSIGN_TICKETS_TO_SUBSCRIBERS, params));
    }

    @GetMapping(value={"/{slug}/check-in-log"})
    public ResponseEntity<List<CheckInLogEntry>> checkInLog(@PathVariable String slug, Principal user) {
        this.accessService.checkEventOwnership(user, slug);
        try {
            return ResponseEntity.ok((Object)this.checkInManager.retrieveLogEntries(slug, user.getName()));
        }
        catch (Exception ex) {
            log.error("Error while loading check-in log entries", (Throwable)ex);
            return ResponseEntity.internalServerError().build();
        }
    }

    private LinkedSubscription retrieveLinkedSubscriptionsForEvent(String slug, int id, int organizationId) {
        List subscriptions = this.eventManager.getLinkedSubscriptions(id, organizationId);
        return new LinkedSubscription(slug, subscriptions.stream().collect(Collectors.toMap(EventSubscriptionLink::getSubscriptionDescriptorId, EventSubscriptionLink::getCompatibleCategories)));
    }

    private Optional<Event> updateEvent(String slug, EventCreationRequest request, Principal user, String imageRef) {
        Organization organization = (Organization)this.userManager.findUserOrganizations(user.getName()).get(0);
        EventWithAdditionalInfo original = this.eventStatisticsManager.getEventWithAdditionalInfo(slug, user.getName());
        Event event = original.getEvent();
        int originalSeats = original.getAvailableSeats();
        EventModification em = request.toEventModificationUpdate(original, organization, imageRef);
        this.eventManager.updateEventHeader(event, em, user.getName());
        if (originalSeats > em.getAvailableSeats()) {
            this.handleCategoriesUpdate(user, em, original, event);
            this.eventManager.updateEventSeatsAndPrices(event, em, user.getName(), false);
        } else {
            this.eventManager.updateEventSeatsAndPrices(event, em, user.getName(), false);
            this.handleCategoriesUpdate(user, em, original, event);
        }
        return this.eventManager.getOptionalByName(slug, user.getName());
    }

    private void handleCategoriesUpdate(Principal user, EventModification em, EventWithAdditionalInfo original, Event event) {
        if (em.getTicketCategories() != null && !em.getTicketCategories().isEmpty()) {
            List existingCategories = original.getTicketCategories();
            em.getTicketCategories().stream().sorted(Comparator.comparing(TicketCategoryModification::getMaxTickets)).forEach(c -> {
                Optional existingCategory = EventCreationRequest.findExistingCategory((List)existingCategories, (String)c.getName(), (Integer)c.getId());
                if (existingCategory.isPresent()) {
                    this.eventManager.updateCategory(((TicketCategoryWithAdditionalInfo)existingCategory.get()).getId(), event.getId(), c, user.getName());
                } else {
                    this.eventManager.insertCategory(event.getId(), c, user.getName());
                }
            });
        }
    }

    private Optional<String> insertEvent(EventCreationRequest request, Principal user, String imageRef) {
        try {
            Organization organization = (Organization)this.userManager.findUserOrganizations(user.getName()).get(0);
            EventModification em = request.toEventModification(organization, arg_0 -> ((EventNameManager)this.eventNameManager).generateShortName(arg_0), imageRef);
            this.eventManager.createEvent(em, user.getName());
            EventWithAdditionalInfo eventWithStatistics = this.eventStatisticsManager.getEventWithAdditionalInfo(em.getShortName(), user.getName());
            Event event = eventWithStatistics.getEvent();
            Optional.ofNullable(request.getTickets().getPromoCodes()).ifPresent(promoCodes -> promoCodes.forEach(pc -> this.eventManager.addPromoCode(pc.getName(), Integer.valueOf(event.getId()), Integer.valueOf(organization.getId()), ZonedDateTime.of(pc.getValidFrom(), event.getZoneId()), ZonedDateTime.of(pc.getValidTo(), event.getZoneId()), pc.getDiscount(), pc.getDiscountType(), Collections.emptyList(), null, null, null, PromoCodeDiscount.CodeType.DISCOUNT, null, pc.getDiscountType() != PromoCodeDiscount.DiscountType.PERCENTAGE ? event.getCurrency() : null)));
            request.getTickets().getCategories().stream().filter(cr -> cr.getGroupLink() != null && cr.getGroupLink().getGroupId() != null).map(cr -> Pair.of((Object)cr, (Object)this.groupManager.findById(cr.getGroupLink().getGroupId().intValue(), organization.getId()))).forEach(link -> {
                if (((Optional)link.getRight()).isPresent()) {
                    Group group = (Group)((Optional)link.getRight()).get();
                    EventCreationRequest.CategoryRequest categoryRequest = (EventCreationRequest.CategoryRequest)link.getLeft();
                    EventCreationRequest.findExistingCategory((List)eventWithStatistics.getTicketCategories(), (String)categoryRequest.getName(), (Integer)categoryRequest.getId()).ifPresent(category -> {
                        EventCreationRequest.GroupLinkRequest groupLinkRequest = categoryRequest.getGroupLink();
                        LinkedGroupModification modification = new LinkedGroupModification(null, group.getId(), event.getId(), Integer.valueOf(category.getId()), groupLinkRequest.getType(), groupLinkRequest.getMatchType(), groupLinkRequest.getMaxAllocation());
                        this.groupManager.createLink(group.getId(), event.getId(), modification);
                    });
                }
            });
            if (!CollectionUtils.isEmpty((Collection)request.getExtensionSettings())) {
                request.getExtensionSettings().stream().collect(Collectors.groupingBy(EventCreationRequest.ExtensionSetting::getExtensionId)).forEach((id, settings) -> {
                    List metadata = this.extensionService.getSingle(organization, (EventAndOrganizationId)event, id).map(es -> this.extensionRepository.findAllParametersForExtension(es.getId().intValue())).orElseGet(Collections::emptyList);
                    List<ExtensionSupport.ExtensionMetadataValue> values = settings.stream().map(es -> Pair.of((Object)es, metadata.stream().filter(mm -> mm.getName().equals(es.getKey())).findFirst())).filter(pair -> {
                        if (((Optional)pair.getRight()).isEmpty()) {
                            log.warn("ignoring non-existent extension setting key {}", (Object)((EventCreationRequest.ExtensionSetting)pair.getLeft()).getKey());
                        }
                        return ((Optional)pair.getRight()).isPresent();
                    }).map(pair -> new ExtensionSupport.ExtensionMetadataValue(((ExtensionSupport.ExtensionMetadataIdAndName)((Optional)pair.getRight()).get()).getId(), ((EventCreationRequest.ExtensionSetting)pair.getLeft()).getValue())).toList();
                    this.extensionService.bulkUpdateEventSettings(organization, (EventAndOrganizationId)event, values);
                });
            }
            return Optional.of(event.getShortName());
        }
        catch (Exception ex) {
            log.error("Error while inserting event", (Throwable)ex);
            return Optional.empty();
        }
    }

    private String fetchImage(String url) {
        if (url != null) {
            FileDownloadManager.DownloadedFile file = this.fileDownloadManager.downloadFile(url);
            return file != null ? this.fileUploadManager.insertFile(file.toUploadBase64FileModification()) : null;
        }
        return null;
    }

    @ConstructorProperties(value={"eventManager", "eventNameManager", "fileUploadManager", "fileDownloadManager", "userManager", "eventStatisticsManager", "groupManager", "extensionService", "extensionRepository", "configurationManager", "adminJobManager", "checkInManager", "accessService"})
    @Generated
    public EventApiV1Controller(EventManager eventManager, EventNameManager eventNameManager, FileUploadManager fileUploadManager, FileDownloadManager fileDownloadManager, UserManager userManager, EventStatisticsManager eventStatisticsManager, GroupManager groupManager, ExtensionService extensionService, ExtensionRepository extensionRepository, ConfigurationManager configurationManager, AdminJobManager adminJobManager, CheckInManager checkInManager, AccessService accessService) {
        this.eventManager = eventManager;
        this.eventNameManager = eventNameManager;
        this.fileUploadManager = fileUploadManager;
        this.fileDownloadManager = fileDownloadManager;
        this.userManager = userManager;
        this.eventStatisticsManager = eventStatisticsManager;
        this.groupManager = groupManager;
        this.extensionService = extensionService;
        this.extensionRepository = extensionRepository;
        this.configurationManager = configurationManager;
        this.adminJobManager = adminJobManager;
        this.checkInManager = checkInManager;
        this.accessService = accessService;
    }
}

