/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v1.admin;

import alfio.manager.AccessService;
import alfio.manager.OrganizationDeleter;
import alfio.manager.user.UserManager;
import alfio.model.api.v1.admin.ApiKeyType;
import alfio.model.api.v1.admin.CreateApiKeyRequest;
import alfio.model.api.v1.admin.OrganizationApiKey;
import alfio.model.modification.OrganizationModification;
import alfio.model.user.Organization;
import alfio.model.user.Role;
import alfio.model.user.User;
import alfio.model.user.UserWithPassword;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/admin/system/organization"})
public class OrganizationsApiV1Controller {
    private final UserManager userManager;
    private final OrganizationDeleter organizationDeleter;
    private final AccessService accessService;

    public OrganizationsApiV1Controller(UserManager userManager, OrganizationDeleter organizationDeleter, AccessService accessService) {
        this.userManager = userManager;
        this.organizationDeleter = organizationDeleter;
        this.accessService = accessService;
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<Organization> createOrganization(@RequestBody OrganizationModification om, Principal principal) {
        this.accessService.ensureSystemApiKey(principal);
        if (om == null || !om.isValid(true)) {
            return ResponseEntity.badRequest().build();
        }
        int orgId = this.userManager.createOrganization(om, principal);
        return ResponseEntity.ok((Object)this.userManager.findOrganizationById(orgId, "admin"));
    }

    @GetMapping(value={"/list"})
    public List<Organization> getAllOrganizations(Principal principal) {
        this.accessService.ensureSystemApiKey(principal);
        return this.userManager.findUserOrganizations("admin");
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Organization> getSingleOrganization(@PathVariable(value="id") int organizationId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        return ResponseEntity.of((Optional)this.userManager.findOptionalOrganizationById(organizationId, "admin"));
    }

    @PutMapping(value={"/{id}/api-key"})
    public ResponseEntity<OrganizationApiKey> createApiKeyForOrganization(@PathVariable(value="id") int organizationId, @RequestBody(required=false) CreateApiKeyRequest createApiKeyRequest, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        ApiKeyType keyType = ApiKeyType.API_CLIENT;
        String description = "Auto-generated API Key";
        if (createApiKeyRequest != null && StringUtils.isNotBlank((CharSequence)createApiKeyRequest.apiKeyType())) {
            Optional keyTypeOptional = ApiKeyType.safeValueOf((String)createApiKeyRequest.apiKeyType());
            if (keyTypeOptional.isEmpty()) {
                return ResponseEntity.badRequest().build();
            }
            keyType = (ApiKeyType)keyTypeOptional.get();
            description = createApiKeyRequest.description();
        }
        UserWithPassword user = this.userManager.insertUser(organizationId, null, null, null, null, Role.fromRoleName((String)keyType.roleName()), User.Type.API_KEY, null, description, principal);
        return ResponseEntity.ok((Object)new OrganizationApiKey(organizationId, user.getUsername(), keyType));
    }

    @DeleteMapping(value={"/{id}/api-key/{apiKey}"})
    public ResponseEntity<Boolean> deleteApiKeyForOrganization(@PathVariable(value="id") int organizationId, @PathVariable String apiKey, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        return ResponseEntity.of(this.userManager.findUserIdByApiKey(apiKey, organizationId).map(userId -> {
            this.userManager.deleteUser(userId.intValue(), principal);
            return true;
        }));
    }

    @PostMapping(value={"/{id}"})
    public ResponseEntity<Organization> update(@PathVariable(value="id") int organizationId, @RequestBody OrganizationModification om, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        if (om == null || !om.isValid(false) || organizationId != om.getId()) {
            return ResponseEntity.badRequest().build();
        }
        this.userManager.updateOrganization(om, principal);
        return ResponseEntity.ok((Object)this.userManager.findOrganizationById(organizationId, "admin"));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable(value="id") int organizationId, Principal principal) {
        this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        boolean result = this.organizationDeleter.deleteOrganization(organizationId, principal);
        if (result) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().build();
    }
}

