/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v1.admin;

import alfio.controller.api.v1.admin.ReservationApiV1Controller;
import alfio.controller.form.ReadOnlyAdditionalFieldsContainer;
import alfio.controller.form.ReservationCreate;
import alfio.manager.AccessService;
import alfio.manager.AdditionalServiceManager;
import alfio.manager.AdminReservationManager;
import alfio.manager.EventManager;
import alfio.manager.PromoCodeRequestManager;
import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.PurchaseContextManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldValue;
import alfio.model.ReservationMetadata;
import alfio.model.Ticket;
import alfio.model.TicketReservation;
import alfio.model.TicketWithMetadataAttributes;
import alfio.model.api.v1.admin.AttendeesByCategory;
import alfio.model.api.v1.admin.ReservationAPICreationRequest;
import alfio.model.api.v1.admin.ReservationConfiguration;
import alfio.model.api.v1.admin.ReservationConfirmationRequest;
import alfio.model.api.v1.admin.ReservationConfirmationResponse;
import alfio.model.api.v1.admin.ReservationDetail;
import alfio.model.api.v1.admin.ReservationUser;
import alfio.model.api.v1.admin.SubscriptionReservationCreationRequest;
import alfio.model.api.v1.admin.TicketReservationCreationRequest;
import alfio.model.api.v1.admin.subscription.Owner;
import alfio.model.metadata.SubscriptionMetadata;
import alfio.model.modification.AdminReservationModification;
import alfio.model.modification.AttendeeData;
import alfio.model.modification.AttendeeResources;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.subscription.SubscriptionWithUsageDetails;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Role;
import alfio.util.ReservationUtil;
import java.security.Principal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/admin"})
public class ReservationApiV1Controller {
    private final TicketReservationManager ticketReservationManager;
    private final PurchaseContextManager purchaseContextManager;
    private final EventManager eventManager;
    private final PromoCodeRequestManager promoCodeRequestManager;
    private final AdminReservationManager adminReservationManager;
    private final AdditionalServiceManager additionalServiceManager;
    private final AccessService accessService;
    private final PurchaseContextFieldManager purchaseContextFieldManager;
    private final ConfigurationManager configurationManager;

    public ReservationApiV1Controller(TicketReservationManager ticketReservationManager, PurchaseContextManager purchaseContextManager, PromoCodeRequestManager promoCodeRequestManager, EventManager eventManager, AccessService accessService, AdditionalServiceManager additionalServiceManager, AdminReservationManager adminReservationManager, PurchaseContextFieldManager purchaseContextFieldManager, ConfigurationManager configurationManager) {
        this.ticketReservationManager = ticketReservationManager;
        this.purchaseContextManager = purchaseContextManager;
        this.promoCodeRequestManager = promoCodeRequestManager;
        this.eventManager = eventManager;
        this.accessService = accessService;
        this.additionalServiceManager = additionalServiceManager;
        this.adminReservationManager = adminReservationManager;
        this.purchaseContextFieldManager = purchaseContextFieldManager;
        this.configurationManager = configurationManager;
    }

    @GetMapping(value={"/{purchaseContextType}/{publicIdentifier}/reservation/{id}"})
    public ResponseEntity<ReservationDetail> retrieveDetail(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable(value="id") String reservationId, Principal principal) {
        this.accessService.checkReservationOwnership(principal, purchaseContextType, publicIdentifier, reservationId);
        TicketReservation reservation = (TicketReservation)this.ticketReservationManager.findById(reservationId).orElseThrow();
        PurchaseContext purchaseContext = (PurchaseContext)this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier).orElseThrow();
        List<Object> attendeesByCategories = List.of();
        List<Object> subscriptionOwners = List.of();
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            Map conf = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.ENABLE_WALLET, ConfigurationKeys.ENABLE_PASS, ConfigurationKeys.BASE_URL), purchaseContext.getConfigurationLevel());
            List tickets = this.adminReservationManager.findTicketsWithMetadata(reservationId);
            Map valuesByTicketId = this.purchaseContextFieldManager.findAllValuesByTicketIds((Collection)tickets.stream().map(t -> t.getTicket().getId()).collect(Collectors.toList()));
            Map<Integer, List<TicketWithMetadataAttributes>> ticketsByCategories = tickets.stream().collect(Collectors.groupingBy(t -> t.getTicket().getCategoryId()));
            attendeesByCategories = ticketsByCategories.keySet().stream().map(categoryId -> {
                List ticketsForCategory = (List)ticketsByCategories.get(categoryId);
                List attendeesData = ticketsForCategory.stream().map(tfc -> {
                    Ticket ticket = tfc.getTicket();
                    Map additional = valuesByTicketId.getOrDefault(ticket.getId(), List.of()).stream().collect(Collectors.groupingBy(PurchaseContextFieldValue::getName, Collectors.mapping(PurchaseContextFieldValue::getValue, Collectors.toList())));
                    return new AttendeeData(ticket.getFirstName(), ticket.getLastName(), ticket.getEmail(), tfc.getAttributes(), additional, AttendeeResources.fromTicket((Ticket)ticket, (PurchaseContext)purchaseContext, (Map)conf));
                }).collect(Collectors.toList());
                return new AttendeesByCategory(categoryId, Integer.valueOf(ticketsForCategory.size()), attendeesData, List.of());
            }).collect(Collectors.toList());
        } else {
            SubscriptionWithUsageDetails subscriptionDetails = (SubscriptionWithUsageDetails)this.ticketReservationManager.findSubscriptionDetails(reservationId).orElseThrow();
            Subscription subscription = subscriptionDetails.getSubscription();
            UUID subscriptionId = subscription.getId();
            SubscriptionMetadata metadata = Objects.requireNonNullElseGet(this.adminReservationManager.findSubscriptionMetadata(subscriptionId), SubscriptionMetadata::empty);
            Map fields = this.purchaseContextFieldManager.findAllValuesBySubscriptionIds(List.of(subscriptionId)).getOrDefault(subscriptionId, List.of()).stream().collect(Collectors.groupingBy(PurchaseContextFieldValue::getName, Collectors.mapping(PurchaseContextFieldValue::getValue, Collectors.toList())));
            subscriptionOwners = List.of(new Owner(fields, subscriptionId, subscription.getFirstName(), subscription.getLastName(), subscription.getEmail(), metadata.getProperties()));
        }
        return ResponseEntity.ok((Object)new ReservationDetail(reservationId, reservation.getStatus(), new ReservationUser(null, reservation.getFirstName(), reservation.getLastName(), reservation.getEmail(), null), attendeesByCategories, subscriptionOwners));
    }

    @PostMapping(value={"/event/{slug}/reservation"})
    @Transactional
    public ResponseEntity<CreationResponse> createTicketsReservation(@PathVariable(value="slug") String eventSlug, @RequestBody TicketReservationCreationRequest reservationCreationRequest, Principal principal) {
        this.accessService.checkEventReservationCreationRequest(principal, eventSlug, (ReservationCreate)reservationCreationRequest);
        BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult((Object)reservationCreationRequest, "reservation");
        Optional optionalEvent = this.purchaseContextManager.findBy(PurchaseContext.PurchaseContextType.event, eventSlug);
        if (optionalEvent.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        Event event = (Event)optionalEvent.get();
        Optional promoCodeDiscount = ReservationUtil.checkPromoCode((ReservationCreate)reservationCreationRequest, (Event)event, (PromoCodeRequestManager)this.promoCodeRequestManager, (BindingResult)bindingResult);
        Locale locale = Locale.forLanguageTag(Objects.requireNonNullElseGet(reservationCreationRequest.getLanguage(), () -> ((ContentLanguage)event.getContentLanguages().get(0)).getLanguage()));
        Optional selected = ReservationUtil.validateCreateRequest((ReservationCreate)reservationCreationRequest, (Errors)bindingResult, (TicketReservationManager)this.ticketReservationManager, (EventManager)this.eventManager, (AdditionalServiceManager)this.additionalServiceManager, (String)"", (Event)event);
        if (selected.isPresent() && !bindingResult.hasErrors()) {
            Pair pair = (Pair)selected.get();
            return ReservationUtil.handleReservationCreationErrors(() -> this.ticketReservationManager.createTicketReservation(event, (List)pair.getLeft(), (List)pair.getRight(), promoCodeDiscount, locale, principal), (BindingResult)bindingResult, (PurchaseContext.PurchaseContextType)event.getType()).map(id -> ResponseEntity.ok((Object)this.postCreate((ReservationAPICreationRequest)reservationCreationRequest, id, (PurchaseContext)event, locale))).orElseGet(() -> ResponseEntity.badRequest().build());
        }
        return ResponseEntity.badRequest().body((Object)CreationResponse.error(bindingResult.getAllErrors().stream().map(err -> ErrorCode.custom((String)("invalid." + err.getObjectName()), (String)err.getCode())).collect(Collectors.toList())));
    }

    @PostMapping(value={"/subscription/{id}/reservation"})
    @Transactional
    public ResponseEntity<CreationResponse> createSubscriptionReservation(@PathVariable(value="id") String subscriptionId, @RequestBody SubscriptionReservationCreationRequest creationRequest, Principal principal) {
        this.accessService.checkSubscriptionDescriptorOwnership(principal, subscriptionId);
        BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult((Object)creationRequest, "reservation");
        Optional optionalDescriptor = this.purchaseContextManager.findBy(PurchaseContext.PurchaseContextType.subscription, subscriptionId);
        if (optionalDescriptor.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        SubscriptionDescriptor subscriptionDescriptor = (SubscriptionDescriptor)optionalDescriptor.get();
        Locale locale = Locale.forLanguageTag(Objects.requireNonNullElseGet(creationRequest.getLanguage(), () -> ((ContentLanguage)subscriptionDescriptor.getContentLanguages().get(0)).getLanguage()));
        return ReservationUtil.handleReservationCreationErrors(() -> this.ticketReservationManager.createSubscriptionReservation(subscriptionDescriptor, locale, principal, creationRequest.getMetadataOrNull()), (BindingResult)bindingResult, (PurchaseContext.PurchaseContextType)subscriptionDescriptor.getType()).map(id -> ResponseEntity.ok((Object)this.postCreate((ReservationAPICreationRequest)creationRequest, id, (PurchaseContext)subscriptionDescriptor, locale))).orElseGet(() -> {
            if (bindingResult.hasErrors()) {
                return ResponseEntity.badRequest().body((Object)CreationResponse.error(bindingResult.getAllErrors().stream().map(err -> ErrorCode.custom((String)("invalid." + err.getObjectName()), (String)err.getCode())).collect(Collectors.toList())));
            }
            return ResponseEntity.badRequest().build();
        });
    }

    @PutMapping(value={"/reservation/{reservationId}/confirm"})
    public ResponseEntity<ReservationConfirmationResponse> confirmReservation(@PathVariable String reservationId, @RequestBody ReservationConfirmationRequest reservationConfirmationRequest, Principal principal) {
        if (!reservationConfirmationRequest.isValid()) {
            return ResponseEntity.badRequest().build();
        }
        Result result = this.adminReservationManager.confirmReservation(reservationId, principal, reservationConfirmationRequest.transaction(), AdminReservationModification.Notification.orEmpty((AdminReservationModification.Notification)reservationConfirmationRequest.notification()), reservationConfirmationRequest.reservationBillingData());
        if (result.isSuccess()) {
            Triple data = (Triple)result.getData();
            PurchaseContext purchaseContext = (PurchaseContext)data.getRight();
            if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
                return ResponseEntity.ok((Object)new ReservationConfirmationResponse(((List)data.getMiddle()).stream().map(t -> new ReservationConfirmationResponse.HolderDetail(t.getUuid(), t.getFirstName(), t.getLastName(), t.getEmail())).collect(Collectors.toList())));
            }
            List subscriptions = this.ticketReservationManager.findSubscriptionDetails(((TicketReservation)data.getLeft()).getId()).map(List::of).orElseGet(List::of);
            return ResponseEntity.ok((Object)new ReservationConfirmationResponse(subscriptions.stream().map(s -> {
                Subscription subscription = s.getSubscription();
                return new ReservationConfirmationResponse.HolderDetail(subscription.getId().toString(), subscription.getFirstName(), subscription.getLastName(), subscription.getEmail());
            }).collect(Collectors.toList())));
        }
        return ResponseEntity.badRequest().build();
    }

    @DeleteMapping(value={"/event/{slug}/reservation/delete-ticket/{ticketUUID}"})
    public ResponseEntity<Boolean> deleteTicket(@PathVariable String slug, @PathVariable String ticketUUID, Principal user) {
        this.accessService.checkEventTicketIdentifierMembership(user, slug, ticketUUID, EnumSet.of(Role.OWNER, Role.API_CONSUMER));
        return ResponseEntity.of(this.adminReservationManager.findTicketWithReservationId(ticketUUID, slug, user.getName()).map(ticket -> {
            Result result = this.adminReservationManager.removeTickets(slug, ticket.getTicketsReservationId(), List.of(Integer.valueOf(ticket.getId())), List.of(), false, false, user.getName());
            return result.isSuccess();
        }));
    }

    @DeleteMapping(value={"/subscription/{id}/reservation/delete-subscription/{subscriptionToDelete}"})
    public ResponseEntity<Boolean> deleteSubscription(@PathVariable(value="id") String descriptorId, @PathVariable UUID subscriptionToDelete, Principal user) {
        this.accessService.checkSubscriptionDescriptorOwnership(user, descriptorId);
        return ResponseEntity.of(this.adminReservationManager.findReservationIdForSubscription(descriptorId, subscriptionToDelete, user).map(descriptorAndReservationId -> {
            Result result = this.adminReservationManager.removeSubscription((SubscriptionDescriptor)descriptorAndReservationId.getKey(), (String)descriptorAndReservationId.getValue(), subscriptionToDelete, user.getName());
            return result.isSuccess();
        }));
    }

    private CreationResponse postCreate(ReservationAPICreationRequest creationRequest, String id, PurchaseContext purchaseContext, Locale locale) {
        SubscriptionReservationCreationRequest request;
        String descriptorId;
        ReservationConfiguration reservationConfiguration;
        ReservationUser user = creationRequest.getUser();
        if (user != null) {
            this.ticketReservationManager.setReservationOwner(id, user.getUsername(), user.getEmail(), user.getFirstName(), user.getLastName(), locale.getLanguage());
        }
        if ((reservationConfiguration = creationRequest.getReservationConfiguration()) != null) {
            ReservationMetadata reservationMetadata = new ReservationMetadata(Boolean.valueOf(reservationConfiguration.isHideContactData()), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(reservationConfiguration.isHideConfirmationButtons()), Boolean.valueOf(reservationConfiguration.isLockEmailEdit()));
            this.ticketReservationManager.setReservationMetadata(id, reservationMetadata);
        }
        if (creationRequest instanceof TicketReservationCreationRequest) {
            TicketReservationCreationRequest trcr = (TicketReservationCreationRequest)creationRequest;
            v0 = trcr.getSubscriptionId();
        } else {
            v0 = descriptorId = null;
        }
        if (creationRequest instanceof SubscriptionReservationCreationRequest && (request = (SubscriptionReservationCreationRequest)creationRequest).hasAdditionalInfo()) {
            UUID subscriptionId = ((SubscriptionWithUsageDetails)this.ticketReservationManager.findSubscriptionDetails(id).orElseThrow()).getSubscription().getId();
            this.purchaseContextFieldManager.updateFieldsForReservation((ReadOnlyAdditionalFieldsContainer)request.getSubscriptionOwner(), purchaseContext, null, subscriptionId);
        }
        return CreationResponse.success((String)id, (String)this.ticketReservationManager.reservationUrlForExternalClients(id, purchaseContext, locale.getLanguage(), user != null, descriptorId));
    }
}

