/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v1.admin;

import alfio.controller.api.admin.SubscriptionApiController;
import alfio.manager.AccessService;
import alfio.manager.FileDownloadManager;
import alfio.manager.FileUploadManager;
import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.SubscriptionManager;
import alfio.manager.user.UserManager;
import alfio.model.PurchaseContext;
import alfio.model.api.v1.admin.LinkedEvent;
import alfio.model.api.v1.admin.SubscriptionDescriptorModificationRequest;
import alfio.model.modification.SubscriptionDescriptorModification;
import alfio.model.result.Result;
import alfio.model.subscription.EventSubscriptionLink;
import alfio.model.subscription.LinkEventsToSubscriptionRequest;
import alfio.model.subscription.SubscriptionDescriptorWithStatistics;
import alfio.model.user.Organization;
import alfio.util.Json;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/admin/subscription"})
@Transactional
public class SubscriptionApiV1Controller {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionApiV1Controller.class);
    private final SubscriptionManager subscriptionManager;
    private final FileUploadManager fileUploadManager;
    private final FileDownloadManager fileDownloadManager;
    private final UserManager userManager;
    private final AccessService accessService;
    private final PurchaseContextFieldManager purchaseContextFieldManager;

    public SubscriptionApiV1Controller(SubscriptionManager subscriptionManager, FileUploadManager fileUploadManager, FileDownloadManager fileDownloadManager, UserManager userManager, AccessService accessService, PurchaseContextFieldManager purchaseContextFieldManager) {
        this.subscriptionManager = subscriptionManager;
        this.fileUploadManager = fileUploadManager;
        this.fileDownloadManager = fileDownloadManager;
        this.userManager = userManager;
        this.accessService = accessService;
        this.purchaseContextFieldManager = purchaseContextFieldManager;
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<String> create(@RequestBody SubscriptionDescriptorModificationRequest request, Principal principal) {
        Organization organization = (Organization)this.userManager.findUserOrganizations(principal.getName()).get(0);
        String imageRef = null;
        if (StringUtils.isNotEmpty((CharSequence)request.getImageUrl())) {
            imageRef = this.fetchImage(request.getImageUrl());
        }
        Result modification = request.toDescriptorModification(null, organization.getId(), imageRef).flatMap(SubscriptionDescriptorModification::validate);
        Result additionalFields = request.toAdditionalFieldsRequest();
        if (modification.isSuccess() && additionalFields.isSuccess()) {
            Optional optionalId = this.subscriptionManager.createSubscriptionDescriptor((SubscriptionDescriptorModification)modification.getData());
            if (optionalId.isPresent()) {
                UUID id = (UUID)optionalId.get();
                this.purchaseContextFieldManager.addAdditionalFields((PurchaseContext)this.subscriptionManager.getSubscriptionById(id).orElseThrow(), (List)additionalFields.getData());
            }
            return optionalId.map(uuid -> ResponseEntity.ok((Object)uuid.toString())).orElseGet(() -> ResponseEntity.internalServerError().build());
        }
        ArrayList errors = new ArrayList(modification.getErrors());
        errors.addAll(additionalFields.getErrors());
        return ResponseEntity.badRequest().body((Object)Json.toJson(errors));
    }

    @PostMapping(value={"/{subscriptionId}/update"})
    public ResponseEntity<String> update(@PathVariable UUID subscriptionId, @RequestBody SubscriptionDescriptorModificationRequest request, Principal principal) {
        Result modification;
        this.accessService.checkSubscriptionDescriptorOwnership(principal, subscriptionId.toString());
        Organization organization = (Organization)this.userManager.findUserOrganizations(principal.getName()).get(0);
        String imageRef = null;
        if (StringUtils.isNotEmpty((CharSequence)request.getImageUrl())) {
            imageRef = this.fetchImage(request.getImageUrl());
        }
        if ((modification = request.toDescriptorModification(subscriptionId, organization.getId(), imageRef).flatMap(SubscriptionDescriptorModification::validate)).isSuccess()) {
            Optional optionalId = this.subscriptionManager.updateSubscriptionDescriptor((SubscriptionDescriptorModification)modification.getData());
            return optionalId.map(uuid -> ResponseEntity.ok((Object)uuid.toString())).orElseGet(() -> ResponseEntity.internalServerError().build());
        }
        return ResponseEntity.badRequest().body((Object)Json.toJson((Object)modification.getErrors()));
    }

    @GetMapping(value={"/{subscriptionId}"})
    public ResponseEntity<SubscriptionDescriptorWithStatistics> get(@PathVariable UUID subscriptionId, Principal principal) {
        this.accessService.checkSubscriptionDescriptorOwnership(principal, subscriptionId.toString());
        Organization organization = (Organization)this.userManager.findUserOrganizations(principal.getName()).get(0);
        return ResponseEntity.of((Optional)this.subscriptionManager.loadSubscriptionWithStatistics(subscriptionId, organization.getId()));
    }

    @GetMapping(value={"/{subscriptionId}/events"})
    public ResponseEntity<List<LinkedEvent>> getLinkedEvents(@PathVariable UUID subscriptionId, Principal principal) {
        this.accessService.checkSubscriptionDescriptorOwnership(principal, subscriptionId.toString());
        Organization organization = (Organization)this.userManager.findUserOrganizations(principal.getName()).get(0);
        return ResponseEntity.ok((Object)SubscriptionApiV1Controller.toLinkedEvents((List)this.subscriptionManager.getLinkedEvents(organization.getId(), subscriptionId)));
    }

    @PostMapping(value={"/{subscriptionId}/events"})
    public ResponseEntity<List<LinkedEvent>> updateLinkedEvents(@PathVariable UUID subscriptionId, @RequestBody List<LinkEventsToSubscriptionRequest> linkedEvents, Principal principal) {
        if (linkedEvents == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        this.accessService.checkEventLinkRequest(principal, subscriptionId.toString(), linkedEvents);
        Organization organization = (Organization)this.userManager.findUserOrganizations(principal.getName()).get(0);
        int organizationId = organization.getId();
        Result result = this.subscriptionManager.updateLinkedEvents(organizationId, subscriptionId, linkedEvents);
        if (result.isSuccess()) {
            return ResponseEntity.ok((Object)SubscriptionApiV1Controller.toLinkedEvents((List)((List)result.getData())));
        }
        if (log.isWarnEnabled()) {
            log.warn("Cannot update linked events {}", (Object)Json.toJson((Object)result.getErrors()));
        }
        return ResponseEntity.badRequest().build();
    }

    @DeleteMapping(value={"/{subscriptionId}/deactivate"})
    public ResponseEntity<Void> deactivate(@PathVariable(value="subscriptionId") UUID descriptorId, Principal principal) {
        this.accessService.checkSubscriptionDescriptorOwnership(principal, descriptorId.toString());
        Organization organization = (Organization)this.userManager.findUserOrganizations(principal.getName()).get(0);
        int organizationId = organization.getId();
        return SubscriptionApiController.deactivateSubscriptionDescriptor((int)organizationId, (UUID)descriptorId, (SubscriptionManager)this.subscriptionManager);
    }

    private String fetchImage(String url) {
        if (url != null) {
            FileDownloadManager.DownloadedFile file = this.fileDownloadManager.downloadFile(url);
            return file != null ? this.fileUploadManager.insertFile(file.toUploadBase64FileModification()) : null;
        }
        return null;
    }

    private static List<LinkedEvent> toLinkedEvents(List<EventSubscriptionLink> links) {
        return links.stream().map(l -> new LinkedEvent(l.getEventShortName(), l.getCompatibleCategories())).collect(Collectors.toList());
    }
}

