/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2;

import alfio.controller.api.support.TicketHelper;
import alfio.controller.api.v2.model.Language;
import alfio.manager.i18n.I18nManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.LocalizedCountry;
import alfio.model.system.ConfigurationKeys;
import alfio.util.LocaleUtil;
import java.text.Collator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v2/"})
public class TranslationsApiController {
    private final MessageSourceManager messageSourceManager;
    private final ConfigurationManager configurationManager;
    private final I18nManager i18nManager;

    public TranslationsApiController(MessageSourceManager messageSourceManager, ConfigurationManager configurationManager, I18nManager i18nManager) {
        this.messageSourceManager = messageSourceManager;
        this.configurationManager = configurationManager;
        this.i18nManager = i18nManager;
    }

    @GetMapping(value={"/public/i18n/bundle/{lang}"})
    public Map<String, String> getPublicTranslations(@PathVariable String lang, @RequestParam(value="withSystemOverride", defaultValue="true", required=false) boolean withSystemOverride) {
        return this.messageSourceManager.getBundleAsMap("alfio.i18n.public", withSystemOverride, lang, MessageSourceManager.PUBLIC_FRONTEND);
    }

    @GetMapping(value={"/admin/i18n/bundle/{lang}"})
    public Map<String, String> getAdminTranslations(@PathVariable String lang, @RequestParam(value="withSystemOverride", defaultValue="true", required=false) boolean withSystemOverride) {
        return this.messageSourceManager.getBundleAsMap("alfio.i18n.public", withSystemOverride, lang, MessageSourceManager.ADMIN_FRONTEND);
    }

    @GetMapping(value={"/public/i18n/countries/{lang}"})
    public List<LocalizedCountry> getCountries(@PathVariable String lang) {
        return TicketHelper.getSortedLocalizedCountries((Locale)LocaleUtil.forLanguageTag((String)lang));
    }

    @GetMapping(value={"/public/i18n/countries-vat/{lang}"})
    public List<LocalizedCountry> getCountriesForVat(@PathVariable String lang) {
        return TicketHelper.getSortedLocalizedVatCountries((Locale)LocaleUtil.forLanguageTag((String)lang));
    }

    @GetMapping(value={"/public/i18n/eu-countries-vat/{lang}"})
    public List<LocalizedCountry> getEuCountriesForVat(@PathVariable String lang) {
        List countries = TicketHelper.getLocalizedEUCountriesForVat((Locale)LocaleUtil.forLanguageTag((String)lang), (String)this.configurationManager.getForSystem(ConfigurationKeys.EU_COUNTRIES_LIST).getRequiredValue());
        return TranslationsApiController.fromPair((List)countries);
    }

    private static List<LocalizedCountry> fromPair(List<Pair<String, String>> countries) {
        Collator collator = Collator.getInstance(Locale.FRENCH);
        return countries.stream().map(p -> new LocalizedCountry((String)p.getKey(), (String)p.getValue())).sorted((lc1, lc2) -> collator.compare(lc1.name(), lc2.name())).collect(Collectors.toList());
    }

    @GetMapping(value={"/public/i18n/languages"})
    public List<Language> getSupportedLanguages() {
        return this.i18nManager.getAvailableLanguages().stream().map(cl -> new Language(cl.getLocale().getLanguage(), cl.getDisplayLanguage())).collect(Collectors.toList());
    }
}

