/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.model;

import alfio.manager.system.ConfigurationManager;
import alfio.model.system.ConfigurationKeys;
import jakarta.servlet.http.HttpSession;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalyticsConfiguration {
    private final String googleAnalyticsKey;
    private final boolean googleAnalyticsScrambledInfo;
    private final String clientId;

    public static AnalyticsConfiguration build(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> conf, HttpSession session) {
        String googAnalyticsKey = StringUtils.trimToNull((String)conf.get(ConfigurationKeys.GOOGLE_ANALYTICS_KEY).getValueOrNull());
        boolean googAnalyticsScrambled = conf.get(ConfigurationKeys.GOOGLE_ANALYTICS_ANONYMOUS_MODE).getValueAsBooleanOrDefault();
        String sessionId = session.getId();
        String clientId = googAnalyticsKey != null && googAnalyticsScrambled && sessionId != null ? DigestUtils.sha256Hex((String)sessionId) : null;
        return new AnalyticsConfiguration(googAnalyticsKey, googAnalyticsScrambled, clientId);
    }

    @ConstructorProperties(value={"googleAnalyticsKey", "googleAnalyticsScrambledInfo", "clientId"})
    @Generated
    public AnalyticsConfiguration(String googleAnalyticsKey, boolean googleAnalyticsScrambledInfo, String clientId) {
        this.googleAnalyticsKey = googleAnalyticsKey;
        this.googleAnalyticsScrambledInfo = googleAnalyticsScrambledInfo;
        this.clientId = clientId;
    }

    @Generated
    public String getGoogleAnalyticsKey() {
        return this.googleAnalyticsKey;
    }

    @Generated
    public boolean isGoogleAnalyticsScrambledInfo() {
        return this.googleAnalyticsScrambledInfo;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }
}

