/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.model;

import alfio.controller.api.support.CurrencyDescriptor;
import alfio.controller.api.v2.model.AnalyticsConfiguration;
import alfio.controller.api.v2.model.EmbeddingConfiguration;
import alfio.controller.api.v2.model.EventWithAdditionalInfo;
import alfio.controller.api.v2.model.InvoicingConfiguration;
import alfio.controller.api.v2.model.Language;
import alfio.controller.api.v2.model.OfflinePaymentConfiguration;
import alfio.model.PurchaseContext;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.money.CurrencyUnit;

public interface ApiPurchaseContext {
    public InvoicingConfiguration getInvoicingConfiguration();

    public EventWithAdditionalInfo.AssignmentConfiguration getAssignmentConfiguration();

    public AnalyticsConfiguration getAnalyticsConfiguration();

    public OfflinePaymentConfiguration getOfflinePaymentConfiguration();

    public EventWithAdditionalInfo.CaptchaConfiguration getCaptchaConfiguration();

    public EmbeddingConfiguration getEmbeddingConfiguration();

    public boolean isVatIncluded();

    public boolean isFree();

    public String getCurrency();

    public String getVat();

    default public List<Language> getContentLanguages() {
        return this.purchaseContext().getContentLanguages().stream().map(cl -> new Language(cl.getLocale().getLanguage(), cl.getDisplayLanguage())).collect(Collectors.toList());
    }

    default public CurrencyDescriptor getCurrencyDescriptor() {
        if (this.purchaseContext().isFreeOfCharge()) {
            return null;
        }
        CurrencyUnit currencyUnit = CurrencyUnit.of((String)this.getCurrency());
        return new CurrencyDescriptor(currencyUnit.getCode(), currencyUnit.toCurrency().getDisplayName(), currencyUnit.getSymbol(), currencyUnit.getDecimalPlaces());
    }

    public String getPrivacyPolicyUrl();

    public String getTermsAndConditionsUrl();

    public String getFileBlobId();

    public Map<String, String> getTitle();

    public Map<String, String> getDescription();

    public String getBankAccount();

    public List<String> getBankAccountOwner();

    public String getOrganizationEmail();

    public String getOrganizationName();

    @JsonIgnore
    public PurchaseContext purchaseContext();

    public boolean isCanApplySubscriptions();
}

