/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.model;

import alfio.controller.api.v2.model.EmptyChallengeConfiguration;
import alfio.controller.api.v2.model.TurnstileChallengeConfiguration;
import alfio.manager.system.ConfigurationManager;
import alfio.model.system.ConfigurationKeys;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ChallengeConfiguration {
    @JsonProperty
    public String apiKey();

    @JsonProperty
    public boolean enabled();

    @JsonProperty
    public String providerId();

    public static ChallengeConfiguration build(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configuration) {
        if (configuration.get(ConfigurationKeys.CF_TURNSTILE_ENABLED).getValueAsBooleanOrDefault()) {
            String siteKey = configuration.get(ConfigurationKeys.CF_TURNSTILE_SITE_KEY).getRequiredValue();
            return new TurnstileChallengeConfiguration(siteKey, true);
        }
        return new EmptyChallengeConfiguration();
    }
}

