/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.model;

import alfio.controller.api.v2.model.AnalyticsConfiguration;
import alfio.controller.api.v2.model.ApiPurchaseContext;
import alfio.controller.api.v2.model.DateValidity;
import alfio.controller.api.v2.model.DatesWithTimeZoneOffset;
import alfio.controller.api.v2.model.EmbeddingConfiguration;
import alfio.controller.api.v2.model.EventWithAdditionalInfo;
import alfio.controller.api.v2.model.InvoicingConfiguration;
import alfio.controller.api.v2.model.OfflinePaymentConfiguration;
import alfio.model.Event;
import alfio.model.PurchaseContext;
import alfio.model.user.Organization;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class EventWithAdditionalInfo
implements DateValidity,
ApiPurchaseContext {
    private final Event event;
    private final String mapUrl;
    private final Organization.OrganizationContact organization;
    private final Map<String, String> description;
    private final String bankAccount;
    private final List<String> bankAccountOwner;
    private final Map<String, String> formattedBeginDate;
    private final Map<String, String> formattedBeginTime;
    private final Map<String, String> formattedEndDate;
    private final Map<String, String> formattedEndTime;
    private final InvoicingConfiguration invoicingConfiguration;
    private final CaptchaConfiguration captchaConfiguration;
    private final AssignmentConfiguration assignmentConfiguration;
    private final PromotionsConfiguration promotionsConfiguration;
    private final AnalyticsConfiguration analyticsConfiguration;
    private final OfflinePaymentConfiguration offlinePaymentConfiguration;
    private final EmbeddingConfiguration embeddingConfiguration;
    private final Map<String, Map<String, String>> i18nOverride;
    private final Integer availableTicketsCount;
    private final String customCss;
    private final boolean canApplySubscriptions;

    public String getShortName() {
        return this.event.getShortName();
    }

    public String getDisplayName() {
        return this.event.getDisplayName();
    }

    public String getFileBlobId() {
        return this.event.getFileBlobId();
    }

    public String getWebsiteUrl() {
        return this.event.getWebsiteUrl();
    }

    public Integer getAvailableTicketsCount() {
        return this.availableTicketsCount;
    }

    public String getMapUrl() {
        return this.mapUrl;
    }

    public String getOrganizationName() {
        return this.organization.getName();
    }

    public String getOrganizationEmail() {
        return this.organization.getEmail();
    }

    public String getLocation() {
        return this.event.getLocation();
    }

    public Map<String, String> getDescription() {
        return this.description;
    }

    public String getPrivacyPolicyUrl() {
        return this.event.getPrivacyPolicyLinkOrNull();
    }

    public String getTermsAndConditionsUrl() {
        return this.event.getTermsAndConditionsUrl();
    }

    public String getCurrency() {
        return this.event.getCurrency();
    }

    public boolean isVatIncluded() {
        return this.event.isVatIncluded();
    }

    public String getVat() {
        return this.event.getVat().toString();
    }

    public boolean isFree() {
        return this.event.getFree();
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public List<String> getBankAccountOwner() {
        return this.bankAccountOwner;
    }

    public boolean isSameDay() {
        return this.event.getSameDay();
    }

    public Map<String, String> getFormattedBeginDate() {
        return this.formattedBeginDate;
    }

    public Map<String, String> getFormattedBeginTime() {
        return this.formattedBeginTime;
    }

    public Map<String, String> getFormattedEndDate() {
        return this.formattedEndDate;
    }

    public Map<String, String> getFormattedEndTime() {
        return this.formattedEndTime;
    }

    public String getTimeZone() {
        return this.event.getTimeZone();
    }

    public DatesWithTimeZoneOffset getDatesWithOffset() {
        return DatesWithTimeZoneOffset.fromEvent((Event)this.event);
    }

    public InvoicingConfiguration getInvoicingConfiguration() {
        return this.invoicingConfiguration;
    }

    public CaptchaConfiguration getCaptchaConfiguration() {
        return this.captchaConfiguration;
    }

    public AssignmentConfiguration getAssignmentConfiguration() {
        return this.assignmentConfiguration;
    }

    public PromotionsConfiguration getPromotionsConfiguration() {
        return this.promotionsConfiguration;
    }

    public AnalyticsConfiguration getAnalyticsConfiguration() {
        return this.analyticsConfiguration;
    }

    public Map<String, Map<String, String>> getI18nOverride() {
        return this.i18nOverride;
    }

    public Event.EventFormat getFormat() {
        return this.event.getFormat();
    }

    public String getCustomCss() {
        return this.customCss;
    }

    public Map<String, String> getTitle() {
        return this.event.getTitle();
    }

    public OfflinePaymentConfiguration getOfflinePaymentConfiguration() {
        return this.offlinePaymentConfiguration;
    }

    public EmbeddingConfiguration getEmbeddingConfiguration() {
        return this.embeddingConfiguration;
    }

    @JsonIgnore
    public PurchaseContext purchaseContext() {
        return this.event;
    }

    public boolean isCanApplySubscriptions() {
        return this.canApplySubscriptions;
    }

    @ConstructorProperties(value={"event", "mapUrl", "organization", "description", "bankAccount", "bankAccountOwner", "formattedBeginDate", "formattedBeginTime", "formattedEndDate", "formattedEndTime", "invoicingConfiguration", "captchaConfiguration", "assignmentConfiguration", "promotionsConfiguration", "analyticsConfiguration", "offlinePaymentConfiguration", "embeddingConfiguration", "i18nOverride", "availableTicketsCount", "customCss", "canApplySubscriptions"})
    @Generated
    public EventWithAdditionalInfo(Event event, String mapUrl, Organization.OrganizationContact organization, Map<String, String> description, String bankAccount, List<String> bankAccountOwner, Map<String, String> formattedBeginDate, Map<String, String> formattedBeginTime, Map<String, String> formattedEndDate, Map<String, String> formattedEndTime, InvoicingConfiguration invoicingConfiguration, CaptchaConfiguration captchaConfiguration, AssignmentConfiguration assignmentConfiguration, PromotionsConfiguration promotionsConfiguration, AnalyticsConfiguration analyticsConfiguration, OfflinePaymentConfiguration offlinePaymentConfiguration, EmbeddingConfiguration embeddingConfiguration, Map<String, Map<String, String>> i18nOverride, Integer availableTicketsCount, String customCss, boolean canApplySubscriptions) {
        this.event = event;
        this.mapUrl = mapUrl;
        this.organization = organization;
        this.description = description;
        this.bankAccount = bankAccount;
        this.bankAccountOwner = bankAccountOwner;
        this.formattedBeginDate = formattedBeginDate;
        this.formattedBeginTime = formattedBeginTime;
        this.formattedEndDate = formattedEndDate;
        this.formattedEndTime = formattedEndTime;
        this.invoicingConfiguration = invoicingConfiguration;
        this.captchaConfiguration = captchaConfiguration;
        this.assignmentConfiguration = assignmentConfiguration;
        this.promotionsConfiguration = promotionsConfiguration;
        this.analyticsConfiguration = analyticsConfiguration;
        this.offlinePaymentConfiguration = offlinePaymentConfiguration;
        this.embeddingConfiguration = embeddingConfiguration;
        this.i18nOverride = i18nOverride;
        this.availableTicketsCount = availableTicketsCount;
        this.customCss = customCss;
        this.canApplySubscriptions = canApplySubscriptions;
    }
}

