/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.model;

import alfio.controller.api.v2.model.ReservationHeader;
import alfio.model.PurchaseContext;
import alfio.model.ReservationWithPurchaseContext;
import alfio.util.LocaleUtil;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.Validate;

/*
 * Exception performing whole class analysis ignored.
 */
public class PurchaseContextWithReservations {
    private final Map<String, String> title;
    private final String publicIdentifier;
    private final PurchaseContext.PurchaseContextType type;
    private final Map<String, String> formattedStartDate;
    private final Map<String, String> formattedEndDate;
    private final boolean sameDay;
    private final List<ReservationHeader> reservations;

    public static PurchaseContextWithReservations from(List<ReservationWithPurchaseContext> reservations, Map<Locale, String> datePatternsMap) {
        Validate.isTrue((!reservations.isEmpty() ? 1 : 0) != 0, (String)"Cannot build PurchaseContextWithReservation out of an empty list", (Object[])new Object[0]);
        ReservationWithPurchaseContext first = reservations.get(0);
        return new PurchaseContextWithReservations(first.getPurchaseContextTitle(), first.getPurchaseContextPublicIdentifier(), first.getPurchaseContextType(), LocaleUtil.formatDate((ZonedDateTime)first.getPurchaseContextStartDate(), datePatternsMap), LocaleUtil.formatDate((ZonedDateTime)first.getPurchaseContextEndDate(), datePatternsMap), PurchaseContextWithReservations.isSameDay((ZonedDateTime)first.getPurchaseContextStartDate(), (ZonedDateTime)first.getPurchaseContextEndDate()), reservations.stream().map(r -> ReservationHeader.from((ReservationWithPurchaseContext)r, (Map)datePatternsMap)).collect(Collectors.toList()));
    }

    private static boolean isSameDay(ZonedDateTime startDate, ZonedDateTime endDate) {
        return startDate != null && endDate != null && startDate.truncatedTo(ChronoUnit.DAYS).equals(endDate.truncatedTo(ChronoUnit.DAYS));
    }

    @ConstructorProperties(value={"title", "publicIdentifier", "type", "formattedStartDate", "formattedEndDate", "sameDay", "reservations"})
    @Generated
    public PurchaseContextWithReservations(Map<String, String> title, String publicIdentifier, PurchaseContext.PurchaseContextType type, Map<String, String> formattedStartDate, Map<String, String> formattedEndDate, boolean sameDay, List<ReservationHeader> reservations) {
        this.title = title;
        this.publicIdentifier = publicIdentifier;
        this.type = type;
        this.formattedStartDate = formattedStartDate;
        this.formattedEndDate = formattedEndDate;
        this.sameDay = sameDay;
        this.reservations = reservations;
    }

    @Generated
    public Map<String, String> getTitle() {
        return this.title;
    }

    @Generated
    public String getPublicIdentifier() {
        return this.publicIdentifier;
    }

    @Generated
    public PurchaseContext.PurchaseContextType getType() {
        return this.type;
    }

    @Generated
    public Map<String, String> getFormattedStartDate() {
        return this.formattedStartDate;
    }

    @Generated
    public Map<String, String> getFormattedEndDate() {
        return this.formattedEndDate;
    }

    @Generated
    public boolean isSameDay() {
        return this.sameDay;
    }

    @Generated
    public List<ReservationHeader> getReservations() {
        return this.reservations;
    }
}

