/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.model;

import alfio.model.PriceContainer;
import alfio.model.ReservationWithPurchaseContext;
import alfio.model.TicketReservation;
import alfio.util.LocaleUtil;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;

public class ReservationHeader {
    private final String id;
    private final TicketReservation.TicketReservationStatus status;
    private final Map<String, String> formattedExpiresOn;
    private final Map<String, String> formattedConfirmedOn;
    private final Map<String, String> formattedCreatedOn;
    private final String invoiceNumber;
    private final BigDecimal finalPrice;
    private final String currencyCode;
    private final BigDecimal usedVatPercent;
    private final PriceContainer.VatStatus vatStatus;
    private final List<ReservationWithPurchaseContext.PurchaseContextItem> items;

    public static ReservationHeader from(ReservationWithPurchaseContext r, Map<Locale, String> datePatternsMap) {
        return new ReservationHeader(r.getId(), r.getStatus(), LocaleUtil.formatDate((ZonedDateTime)r.getValidity(), datePatternsMap), LocaleUtil.formatDate((ZonedDateTime)r.getConfirmationTs(), datePatternsMap), LocaleUtil.formatDate((ZonedDateTime)r.getRegistrationTs(), datePatternsMap), r.getInvoiceNumber(), r.getFinalPrice(), r.getCurrencyCode(), r.getVatPercentage(), r.getVatStatus(), r.getItems());
    }

    @ConstructorProperties(value={"id", "status", "formattedExpiresOn", "formattedConfirmedOn", "formattedCreatedOn", "invoiceNumber", "finalPrice", "currencyCode", "usedVatPercent", "vatStatus", "items"})
    @Generated
    public ReservationHeader(String id, TicketReservation.TicketReservationStatus status, Map<String, String> formattedExpiresOn, Map<String, String> formattedConfirmedOn, Map<String, String> formattedCreatedOn, String invoiceNumber, BigDecimal finalPrice, String currencyCode, BigDecimal usedVatPercent, PriceContainer.VatStatus vatStatus, List<ReservationWithPurchaseContext.PurchaseContextItem> items) {
        this.id = id;
        this.status = status;
        this.formattedExpiresOn = formattedExpiresOn;
        this.formattedConfirmedOn = formattedConfirmedOn;
        this.formattedCreatedOn = formattedCreatedOn;
        this.invoiceNumber = invoiceNumber;
        this.finalPrice = finalPrice;
        this.currencyCode = currencyCode;
        this.usedVatPercent = usedVatPercent;
        this.vatStatus = vatStatus;
        this.items = items;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public TicketReservation.TicketReservationStatus getStatus() {
        return this.status;
    }

    @Generated
    public Map<String, String> getFormattedExpiresOn() {
        return this.formattedExpiresOn;
    }

    @Generated
    public Map<String, String> getFormattedConfirmedOn() {
        return this.formattedConfirmedOn;
    }

    @Generated
    public Map<String, String> getFormattedCreatedOn() {
        return this.formattedCreatedOn;
    }

    @Generated
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    @Generated
    public BigDecimal getFinalPrice() {
        return this.finalPrice;
    }

    @Generated
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Generated
    public BigDecimal getUsedVatPercent() {
        return this.usedVatPercent;
    }

    @Generated
    public PriceContainer.VatStatus getVatStatus() {
        return this.vatStatus;
    }

    @Generated
    public List<ReservationWithPurchaseContext.PurchaseContextItem> getItems() {
        return this.items;
    }
}

