/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.model;

import alfio.controller.api.v2.model.AnalyticsConfiguration;
import alfio.controller.api.v2.model.ApiPurchaseContext;
import alfio.controller.api.v2.model.DatesWithTimeZoneOffset;
import alfio.controller.api.v2.model.EmbeddingConfiguration;
import alfio.controller.api.v2.model.EventWithAdditionalInfo;
import alfio.controller.api.v2.model.InvoicingConfiguration;
import alfio.controller.api.v2.model.OfflinePaymentConfiguration;
import alfio.controller.support.Formatters;
import alfio.model.PriceContainer;
import alfio.model.PurchaseContext;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.util.MonetaryUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SubscriptionDescriptorWithAdditionalInfo
implements ApiPurchaseContext {
    private final SubscriptionDescriptor subscriptionDescriptor;
    private final InvoicingConfiguration invoicingConfiguration;
    private final AnalyticsConfiguration analyticsConfiguration;
    private final EventWithAdditionalInfo.CaptchaConfiguration captchaConfiguration;
    private final EmbeddingConfiguration embeddingConfiguration;
    private final String bankAccount;
    private final List<String> bankAccountOwner;
    private final String organizationEmail;
    private final String organizationName;
    private final DatesWithTimeZoneOffset salePeriod;
    private final Map<String, String> formattedOnSaleFrom;
    private final Map<String, String> formattedOnSaleTo;
    private final String timeZone;
    private final Map<String, String> formattedValidFrom;
    private final Map<String, String> formattedValidTo;
    private final Integer numAvailable;

    public InvoicingConfiguration getInvoicingConfiguration() {
        return this.invoicingConfiguration;
    }

    public EventWithAdditionalInfo.AssignmentConfiguration getAssignmentConfiguration() {
        return new EventWithAdditionalInfo.AssignmentConfiguration(false, false, false);
    }

    public AnalyticsConfiguration getAnalyticsConfiguration() {
        return this.analyticsConfiguration;
    }

    public boolean isFree() {
        return this.subscriptionDescriptor.isFreeOfCharge();
    }

    public String getCurrency() {
        return this.subscriptionDescriptor.getCurrency();
    }

    public String getVat() {
        return this.subscriptionDescriptor.getVat().toString();
    }

    @JsonIgnore
    public PurchaseContext purchaseContext() {
        return this.subscriptionDescriptor;
    }

    public EventWithAdditionalInfo.CaptchaConfiguration getCaptchaConfiguration() {
        return this.captchaConfiguration;
    }

    public boolean isVatIncluded() {
        return this.subscriptionDescriptor.getVatStatus() == PriceContainer.VatStatus.INCLUDED;
    }

    public String getPrivacyPolicyUrl() {
        return this.purchaseContext().getPrivacyPolicyLinkOrNull();
    }

    public String getTermsAndConditionsUrl() {
        return this.purchaseContext().getTermsAndConditionsUrl();
    }

    public String getFileBlobId() {
        return this.subscriptionDescriptor.getFileBlobId();
    }

    public Map<String, String> getDescription() {
        return Formatters.applyCommonMark((Map)this.subscriptionDescriptor.getDescription());
    }

    public Map<String, String> getTitle() {
        return this.subscriptionDescriptor.getTitle();
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public List<String> getBankAccountOwner() {
        return this.bankAccountOwner;
    }

    public String getOrganizationEmail() {
        return this.organizationEmail;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getFormattedPrice() {
        return MonetaryUtil.formatCents((int)this.subscriptionDescriptor.getPrice(), (String)this.subscriptionDescriptor.getCurrency());
    }

    public DatesWithTimeZoneOffset getSalePeriod() {
        return this.salePeriod;
    }

    public Map<String, String> getFormattedOnSaleFrom() {
        return this.formattedOnSaleFrom;
    }

    public Map<String, String> getFormattedOnSaleTo() {
        return this.formattedOnSaleTo;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public SubscriptionDescriptor.SubscriptionValidityType getValidityType() {
        return this.subscriptionDescriptor.getValidityType();
    }

    public SubscriptionDescriptor.SubscriptionUsageType getUsageType() {
        return this.subscriptionDescriptor.getUsageType();
    }

    public SubscriptionDescriptor.SubscriptionTimeUnit getValidityTimeUnit() {
        return this.subscriptionDescriptor.getValidityTimeUnit();
    }

    public Integer getValidityUnits() {
        return this.subscriptionDescriptor.getValidityUnits();
    }

    public Map<String, String> getFormattedValidFrom() {
        return this.formattedValidFrom;
    }

    public Map<String, String> getFormattedValidTo() {
        return this.formattedValidTo;
    }

    public Integer getMaxEntries() {
        return this.subscriptionDescriptor.getMaxEntries() > 0 ? Integer.valueOf(this.subscriptionDescriptor.getMaxEntries()) : null;
    }

    public OfflinePaymentConfiguration getOfflinePaymentConfiguration() {
        return null;
    }

    public EmbeddingConfiguration getEmbeddingConfiguration() {
        return this.embeddingConfiguration;
    }

    public boolean isCanApplySubscriptions() {
        return false;
    }

    public Integer getNumAvailable() {
        return this.numAvailable;
    }

    @ConstructorProperties(value={"subscriptionDescriptor", "invoicingConfiguration", "analyticsConfiguration", "captchaConfiguration", "embeddingConfiguration", "bankAccount", "bankAccountOwner", "organizationEmail", "organizationName", "salePeriod", "formattedOnSaleFrom", "formattedOnSaleTo", "timeZone", "formattedValidFrom", "formattedValidTo", "numAvailable"})
    @Generated
    public SubscriptionDescriptorWithAdditionalInfo(SubscriptionDescriptor subscriptionDescriptor, InvoicingConfiguration invoicingConfiguration, AnalyticsConfiguration analyticsConfiguration, EventWithAdditionalInfo.CaptchaConfiguration captchaConfiguration, EmbeddingConfiguration embeddingConfiguration, String bankAccount, List<String> bankAccountOwner, String organizationEmail, String organizationName, DatesWithTimeZoneOffset salePeriod, Map<String, String> formattedOnSaleFrom, Map<String, String> formattedOnSaleTo, String timeZone, Map<String, String> formattedValidFrom, Map<String, String> formattedValidTo, Integer numAvailable) {
        this.subscriptionDescriptor = subscriptionDescriptor;
        this.invoicingConfiguration = invoicingConfiguration;
        this.analyticsConfiguration = analyticsConfiguration;
        this.captchaConfiguration = captchaConfiguration;
        this.embeddingConfiguration = embeddingConfiguration;
        this.bankAccount = bankAccount;
        this.bankAccountOwner = bankAccountOwner;
        this.organizationEmail = organizationEmail;
        this.organizationName = organizationName;
        this.salePeriod = salePeriod;
        this.formattedOnSaleFrom = formattedOnSaleFrom;
        this.formattedOnSaleTo = formattedOnSaleTo;
        this.timeZone = timeZone;
        this.formattedValidFrom = formattedValidFrom;
        this.formattedValidTo = formattedValidTo;
        this.numAvailable = numAvailable;
    }
}

