/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.model;

import alfio.controller.decorator.SaleableTicketCategory;
import alfio.model.TicketCategory;
import java.util.Map;
import lombok.Generated;

public class TicketCategory {
    private final Map<String, String> description;
    private final int id;
    private final String name;
    private final TicketCategory.TicketAccessType ticketAccessType;
    private final boolean bounded;
    private final int maximumSaleableTickets;
    private final boolean free;
    private final String formattedFinalPrice;
    private final boolean hasDiscount;
    private final String formattedDiscountedPrice;
    private final int ordinal;
    private final boolean expired;
    private final boolean saleInFuture;
    private final boolean containsPendingTickets;
    private final Map<String, String> formattedInception;
    private final Map<String, String> formattedExpiration;
    private final boolean saleableAndLimitNotReached;
    private final boolean accessRestricted;
    private final boolean soldOutOrLimitReached;
    private final Integer availableTickets;
    private final boolean displayTaxInformation;

    public TicketCategory(SaleableTicketCategory saleableTicketCategory, Map<String, String> description, Map<String, String> formattedInception, Map<String, String> formattedExpiration, boolean displayTicketsLeft, boolean displayTaxInformation) {
        this.description = description;
        this.id = saleableTicketCategory.getId();
        this.name = saleableTicketCategory.getName();
        this.ticketAccessType = saleableTicketCategory.getTicketAccessType();
        this.bounded = saleableTicketCategory.isBounded();
        this.maximumSaleableTickets = Math.max(0, Math.min(saleableTicketCategory.getMaxTicketsAfterConfiguration(), saleableTicketCategory.getAvailableTickets()));
        this.free = saleableTicketCategory.getFree();
        this.formattedFinalPrice = saleableTicketCategory.getFormattedFinalPrice();
        this.hasDiscount = saleableTicketCategory.getSupportsDiscount();
        this.formattedDiscountedPrice = this.hasDiscount ? saleableTicketCategory.getDiscountedPrice() : "";
        this.expired = saleableTicketCategory.getExpired();
        this.saleInFuture = saleableTicketCategory.getSaleInFuture();
        this.containsPendingTickets = saleableTicketCategory.hasPendingTickets();
        this.formattedInception = formattedInception;
        this.formattedExpiration = formattedExpiration;
        this.saleableAndLimitNotReached = saleableTicketCategory.getSaleableAndLimitNotReached();
        this.accessRestricted = saleableTicketCategory.getAccessRestricted();
        this.soldOutOrLimitReached = saleableTicketCategory.getSouldOutOrLimitReached();
        this.availableTickets = displayTicketsLeft && saleableTicketCategory.isBounded() ? Integer.valueOf(saleableTicketCategory.getAvailableTickets()) : null;
        this.ordinal = saleableTicketCategory.isAccessRestricted() ? -1 : saleableTicketCategory.getOrdinal();
        this.displayTaxInformation = displayTaxInformation;
    }

    @Generated
    public Map<String, String> getDescription() {
        return this.description;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public TicketCategory.TicketAccessType getTicketAccessType() {
        return this.ticketAccessType;
    }

    @Generated
    public boolean isBounded() {
        return this.bounded;
    }

    @Generated
    public int getMaximumSaleableTickets() {
        return this.maximumSaleableTickets;
    }

    @Generated
    public boolean isFree() {
        return this.free;
    }

    @Generated
    public String getFormattedFinalPrice() {
        return this.formattedFinalPrice;
    }

    @Generated
    public boolean isHasDiscount() {
        return this.hasDiscount;
    }

    @Generated
    public String getFormattedDiscountedPrice() {
        return this.formattedDiscountedPrice;
    }

    @Generated
    public int getOrdinal() {
        return this.ordinal;
    }

    @Generated
    public boolean isExpired() {
        return this.expired;
    }

    @Generated
    public boolean isSaleInFuture() {
        return this.saleInFuture;
    }

    @Generated
    public boolean isContainsPendingTickets() {
        return this.containsPendingTickets;
    }

    @Generated
    public Map<String, String> getFormattedInception() {
        return this.formattedInception;
    }

    @Generated
    public Map<String, String> getFormattedExpiration() {
        return this.formattedExpiration;
    }

    @Generated
    public boolean isSaleableAndLimitNotReached() {
        return this.saleableAndLimitNotReached;
    }

    @Generated
    public boolean isAccessRestricted() {
        return this.accessRestricted;
    }

    @Generated
    public boolean isSoldOutOrLimitReached() {
        return this.soldOutOrLimitReached;
    }

    @Generated
    public Integer getAvailableTickets() {
        return this.availableTickets;
    }

    @Generated
    public boolean isDisplayTaxInformation() {
        return this.displayTaxInformation;
    }
}

