/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.user;

import alfio.controller.api.v2.model.BasicEventInfo;
import alfio.controller.api.v2.model.DatesWithTimeZoneOffset;
import alfio.controller.api.v2.model.DynamicDiscount;
import alfio.controller.api.v2.model.EventCode;
import alfio.controller.api.v2.model.EventWithAdditionalInfo;
import alfio.controller.api.v2.model.ItemsByCategory;
import alfio.controller.api.v2.model.Language;
import alfio.controller.api.v2.user.EventApiV2Controller;
import alfio.controller.api.v2.user.support.EventLoader;
import alfio.controller.form.ReservationCreate;
import alfio.controller.form.ReservationForm;
import alfio.controller.form.SearchOptions;
import alfio.controller.form.WaitingQueueSubscriptionForm;
import alfio.controller.support.FormattedEventDates;
import alfio.controller.support.Formatters;
import alfio.manager.AdditionalServiceManager;
import alfio.manager.EventManager;
import alfio.manager.ExtensionManager;
import alfio.manager.PromoCodeRequestManager;
import alfio.manager.RecaptchaService;
import alfio.manager.TicketCategoryAvailabilityManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.WaitingQueueManager;
import alfio.manager.i18n.I18nManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.support.response.ValidatedResponse;
import alfio.manager.system.ConfigurationManager;
import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.EventDescription;
import alfio.model.LocalizedContent;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.TicketCategory;
import alfio.model.modification.TicketReservationModification;
import alfio.model.result.ValidationResult;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.EventDescriptionRepository;
import alfio.repository.EventRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.util.EventUtil;
import alfio.util.LocaleUtil;
import alfio.util.MonetaryUtil;
import alfio.util.ReservationUtil;
import alfio.util.Validator;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.context.MessageSource;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v2/public/"})
public class EventApiV2Controller {
    private final EventManager eventManager;
    private final EventRepository eventRepository;
    private final ConfigurationManager configurationManager;
    private final EventDescriptionRepository eventDescriptionRepository;
    private final TicketCategoryAvailabilityManager ticketCategoryAvailabilityManager;
    private final MessageSourceManager messageSourceManager;
    private final WaitingQueueManager waitingQueueManager;
    private final I18nManager i18nManager;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final TicketRepository ticketRepository;
    private final TicketReservationManager ticketReservationManager;
    private final RecaptchaService recaptchaService;
    private final PromoCodeRequestManager promoCodeRequestManager;
    private final EventLoader eventLoader;
    private final ExtensionManager extensionManager;
    private final AdditionalServiceManager additionalServiceManager;

    public EventApiV2Controller(EventManager eventManager, EventRepository eventRepository, ConfigurationManager configurationManager, EventDescriptionRepository eventDescriptionRepository, TicketCategoryAvailabilityManager ticketCategoryAvailabilityManager, MessageSourceManager messageSourceManager, WaitingQueueManager waitingQueueManager, I18nManager i18nManager, TicketCategoryRepository ticketCategoryRepository, TicketRepository ticketRepository, TicketReservationManager ticketReservationManager, RecaptchaService recaptchaService, PromoCodeRequestManager promoCodeRequestManager, EventLoader eventLoader, ExtensionManager extensionManager, AdditionalServiceManager additionalServiceManager) {
        this.eventManager = eventManager;
        this.eventRepository = eventRepository;
        this.configurationManager = configurationManager;
        this.eventDescriptionRepository = eventDescriptionRepository;
        this.ticketCategoryAvailabilityManager = ticketCategoryAvailabilityManager;
        this.messageSourceManager = messageSourceManager;
        this.waitingQueueManager = waitingQueueManager;
        this.i18nManager = i18nManager;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.ticketRepository = ticketRepository;
        this.ticketReservationManager = ticketReservationManager;
        this.recaptchaService = recaptchaService;
        this.promoCodeRequestManager = promoCodeRequestManager;
        this.eventLoader = eventLoader;
        this.extensionManager = extensionManager;
        this.additionalServiceManager = additionalServiceManager;
    }

    @GetMapping(value={"events"})
    public ResponseEntity<List<BasicEventInfo>> listEvents(SearchOptions searchOptions) {
        List contentLanguages = this.i18nManager.getAvailableLanguages();
        List events = this.eventManager.getPublishedEvents(searchOptions).stream().map(e -> {
            MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)e);
            FormattedEventDates formattedDates = Formatters.getFormattedDates((Event)e, (MessageSource)messageSource, (List)contentLanguages);
            return new BasicEventInfo(e.getShortName(), e.getFileBlobId(), e.getTitle(), e.getFormat(), e.getLocation(), e.getTimeZone(), DatesWithTimeZoneOffset.fromEvent((Event)e), e.getSameDay(), formattedDates.beginDate, formattedDates.beginTime, formattedDates.endDate, formattedDates.endTime, e.getContentLanguages().stream().map(cl -> new Language(cl.getLocale().getLanguage(), cl.getDisplayLanguage())).collect(Collectors.toList()));
        }).collect(Collectors.toList());
        return new ResponseEntity(events, (MultiValueMap)EventApiV2Controller.getCorsHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"event/{eventName}"})
    public ResponseEntity<EventWithAdditionalInfo> getEvent(@PathVariable String eventName, HttpSession session) {
        return this.eventLoader.loadEventInfo(eventName, session).map(eventWithAdditionalInfo -> new ResponseEntity(eventWithAdditionalInfo, (MultiValueMap)EventApiV2Controller.getCorsHeaders(), (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> ResponseEntity.notFound().headers(EventApiV2Controller.getCorsHeaders()).build());
    }

    @PostMapping(value={"event/{eventName}/waiting-list/subscribe"})
    public ResponseEntity<ValidatedResponse<Boolean>> subscribeToWaitingList(@PathVariable String eventName, @RequestBody WaitingQueueSubscriptionForm subscription, BindingResult bindingResult) {
        Optional<ResponseEntity> res = this.eventRepository.findOptionalByShortName(eventName).map(event -> {
            Validator.validateWaitingQueueSubscription((WaitingQueueSubscriptionForm)subscription, (Errors)bindingResult, (Event)event);
            if (bindingResult.hasErrors()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)ValidatedResponse.toResponse((BindingResult)bindingResult, null));
            }
            boolean subscriptionResult = this.waitingQueueManager.subscribe(event, subscription.toCustomerName(event), subscription.getEmail(), subscription.getSelectedCategory(), subscription.getUserLanguage());
            return ResponseEntity.ok((Object)new ValidatedResponse(ValidationResult.success(), (Object)subscriptionResult));
        });
        return res.orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"event/{eventName}/ticket-categories"})
    public ResponseEntity<ItemsByCategory> getTicketCategories(@PathVariable String eventName, @RequestParam(value="code", required=false) String code) {
        return this.ticketCategoryAvailabilityManager.getTicketCategories(eventName, code).map(i -> new ResponseEntity(i, (MultiValueMap)EventApiV2Controller.getCorsHeaders(), (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> ResponseEntity.notFound().headers(EventApiV2Controller.getCorsHeaders()).build());
    }

    @GetMapping(value={"event/{eventName}/calendar/{locale}"})
    public void getCalendar(@PathVariable String eventName, @PathVariable String locale, @RequestParam(value="type", required=false) String calendarType, @RequestParam(value="ticketId", required=false) String ticketId, HttpServletResponse response) {
        this.eventRepository.findOptionalByShortName(eventName).ifPresentOrElse(ev -> {
            String description = this.eventDescriptionRepository.findDescriptionByEventIdTypeAndLocale(ev.getId(), EventDescription.EventDescriptionType.DESCRIPTION, locale).orElse("");
            TicketCategory category = this.ticketRepository.findOptionalByUUID(ticketId).map(t -> this.ticketCategoryRepository.getById(t.getCategoryId().intValue())).orElse(null);
            if ("google".equals(calendarType)) {
                try {
                    response.sendRedirect(EventUtil.getGoogleCalendarURL((Event)ev, (TicketCategory)category, (String)description));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                EventUtil.getIcalForEvent((Event)ev, (TicketCategory)category, (String)description).ifPresentOrElse(ical -> {
                    response.setContentType("text/calendar");
                    response.setHeader("Content-Disposition", "inline; filename=\"calendar.ics\"");
                    try (ServletOutputStream os = response.getOutputStream();){
                        os.write(ical);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }, () -> response.setStatus(404));
            }
        }, () -> response.setStatus(404));
    }

    @PostMapping(value={"event/{eventName}/reserve-tickets"})
    public ResponseEntity<ValidatedResponse<String>> reserveTickets(@PathVariable String eventName, @RequestParam(value="lang") String lang, @RequestBody ReservationForm reservation, BindingResult bindingResult, ServletWebRequest request, Principal principal) {
        Optional<ResponseEntity> r = this.eventRepository.findOptionalByShortName(eventName).map(event -> {
            Locale locale = LocaleUtil.forLanguageTag((String)lang, (LocalizedContent)event);
            Optional promoCodeDiscount = ReservationUtil.checkPromoCode((ReservationCreate)reservation, (Event)event, (PromoCodeRequestManager)this.promoCodeRequestManager, (BindingResult)bindingResult);
            Map configurationValues = this.configurationManager.getFor(List.of(ConfigurationKeys.ENABLE_CAPTCHA_FOR_TICKET_SELECTION, ConfigurationKeys.RECAPTCHA_API_KEY), event.getConfigurationLevel());
            if (this.isCaptchaInvalid(reservation.getCaptcha(), request.getRequest(), configurationValues)) {
                bindingResult.reject("error.STEP_2_CAPTCHA_VALIDATION_FAILED");
            }
            Optional reservationIdRes = this.createTicketReservation(reservation, bindingResult, event, locale, promoCodeDiscount, principal);
            if (bindingResult.hasErrors()) {
                return new ResponseEntity((Object)ValidatedResponse.toResponse((BindingResult)bindingResult, null), (MultiValueMap)EventApiV2Controller.getCorsHeaders(), (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
            }
            String reservationIdentifier = (String)reservationIdRes.orElseThrow(IllegalStateException::new);
            return ResponseEntity.ok((Object)new ValidatedResponse(ValidationResult.success(), (Object)reservationIdentifier));
        });
        return r.orElseGet(() -> ResponseEntity.notFound().build());
    }

    private Optional<String> createTicketReservation(ReservationForm reservation, BindingResult bindingResult, Event event, Locale locale, Optional<String> promoCodeDiscount, Principal principal) {
        return ReservationUtil.validateCreateRequest((ReservationCreate)reservation, (Errors)bindingResult, (TicketReservationManager)this.ticketReservationManager, (EventManager)this.eventManager, (AdditionalServiceManager)this.additionalServiceManager, (String)promoCodeDiscount.orElse(null), (Event)event).flatMap(selected -> ReservationUtil.handleReservationCreationErrors(() -> this.ticketReservationManager.createTicketReservation(event, (List)selected.getLeft(), (List)selected.getRight(), promoCodeDiscount, locale, principal), (BindingResult)bindingResult, (PurchaseContext.PurchaseContextType)event.getType()));
    }

    @GetMapping(value={"event/{eventName}/validate-code"})
    public ResponseEntity<ValidatedResponse<EventCode>> validateCode(@PathVariable String eventName, @RequestParam(value="code") String code) {
        ValidatedResponse res = this.promoCodeRequestManager.checkCode(eventName, code);
        if (res.isSuccess()) {
            Triple value = (Triple)res.getValue();
            EventCode eventCode = ((Optional)value.getLeft()).map(sp -> new EventCode(code, EventCode.EventCodeType.SPECIAL_PRICE, PromoCodeDiscount.DiscountType.NONE, null)).orElseGet(() -> {
                PromoCodeDiscount promoCodeDiscount = (PromoCodeDiscount)((Optional)value.getRight()).orElseThrow();
                EventCode.EventCodeType type = promoCodeDiscount.getCodeType() == PromoCodeDiscount.CodeType.ACCESS ? EventCode.EventCodeType.ACCESS : EventCode.EventCodeType.DISCOUNT;
                String formattedDiscountAmount = PromoCodeDiscount.format((PromoCodeDiscount)promoCodeDiscount, (String)((Event)value.getMiddle()).getCurrency());
                return new EventCode(code, type, promoCodeDiscount.getDiscountType(), formattedDiscountAmount);
            });
            return ResponseEntity.ok((Object)res.withValue((Object)eventCode));
        }
        return new ResponseEntity((Object)res.withValue((Object)new EventCode(code, null, null, null)), (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @PostMapping(value={"event/{eventName}/check-discount"})
    public ResponseEntity<DynamicDiscount> checkDiscount(@PathVariable String eventName, @RequestBody ReservationForm reservation) {
        return this.eventRepository.findOptionalByShortName(eventName).flatMap(event -> {
            Map<Integer, Long> quantityByCategory = reservation.getReservation().stream().filter(trm -> trm.getQuantity() > 0).collect(Collectors.groupingBy(TicketReservationModification::getTicketCategoryId, Collectors.summingLong(TicketReservationModification::getQuantity)));
            if (quantityByCategory.isEmpty() || this.ticketCategoryRepository.countPaidCategoriesInReservation(quantityByCategory.keySet()) == 0) {
                return Optional.empty();
            }
            return this.extensionManager.handleDynamicDiscount(event, quantityByCategory, null).filter(d -> d.getDiscountType() != PromoCodeDiscount.DiscountType.NONE).map(d -> {
                String formattedDiscount = d.getDiscountType() == PromoCodeDiscount.DiscountType.PERCENTAGE ? String.valueOf(d.getDiscountAmount()) : MonetaryUtil.formatCents((int)d.getDiscountAmount(), (String)event.getCurrency());
                return new DynamicDiscount(formattedDiscount, d.getDiscountType(), this.formatDynamicCodeMessage(event, d));
            });
        }).filter(d -> d.getDiscountType() != PromoCodeDiscount.DiscountType.NONE).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.noContent().build());
    }

    @GetMapping(value={"event/{eventName}/code/{code}"})
    public ResponseEntity<Void> handleCode(@PathVariable String eventName, @PathVariable String code, ServletWebRequest request, Principal principal) {
        String trimmedCode = StringUtils.trimToNull((String)code);
        HashMap queryStrings = new HashMap();
        Function<Pair, Optional> handleErrors = res -> {
            if (((BindingResult)res.getRight()).hasErrors()) {
                queryStrings.put("errors", ((BindingResult)res.getRight()).getAllErrors().stream().map(DefaultMessageSourceResolvable::getCode).collect(Collectors.joining(",")));
            }
            return (Optional)res.getLeft();
        };
        String url = this.promoCodeRequestManager.createReservationFromPromoCode(eventName, trimmedCode, queryStrings::put, handleErrors, request, principal).map(reservationId -> UriComponentsBuilder.fromPath((String)"/event/{eventShortName}/reservation/{reservationId}/book").build(Map.of("eventShortName", eventName, "reservationId", reservationId)).toString()).orElseGet(() -> {
            UriComponentsBuilder backToEvent = UriComponentsBuilder.fromPath((String)"/event/{eventShortName}");
            queryStrings.forEach((x$0, xva$1) -> backToEvent.queryParam(x$0, new Object[]{xva$1}));
            return backToEvent.build(Map.of("eventShortName", eventName)).toString();
        });
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.TEMPORARY_REDIRECT).header("Location", new String[]{url})).build();
    }

    private static HttpHeaders getCorsHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Access-Control-Allow-Origin", "*");
        return headers;
    }

    private boolean isCaptchaInvalid(String recaptchaResponse, HttpServletRequest request, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configurationValues) {
        return this.eventLoader.isRecaptchaForTicketSelectionEnabled(configurationValues) && !this.recaptchaService.checkRecaptcha(recaptchaResponse, request);
    }

    private Map<String, String> formatDynamicCodeMessage(Event event, PromoCodeDiscount promoCodeDiscount) {
        Object amount;
        String code;
        Validate.isTrue((promoCodeDiscount != null && promoCodeDiscount.getDiscountType() != PromoCodeDiscount.DiscountType.NONE ? 1 : 0) != 0);
        MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event);
        HashMap<String, String> res = new HashMap<String, String>();
        switch (1.$SwitchMap$alfio$model$PromoCodeDiscount$DiscountType[promoCodeDiscount.getDiscountType().ordinal()]) {
            case 1: {
                code = "reservation.dynamic.discount.confirmation.percentage.message";
                amount = String.valueOf(promoCodeDiscount.getDiscountAmount());
                break;
            }
            case 2: {
                amount = event.getCurrency() + " " + MonetaryUtil.formatCents((int)promoCodeDiscount.getDiscountAmount(), (String)event.getCurrency());
                code = "reservation.dynamic.discount.confirmation.fix-per-ticket.message";
                break;
            }
            case 3: {
                amount = event.getCurrency() + " " + MonetaryUtil.formatCents((int)promoCodeDiscount.getDiscountAmount(), (String)event.getCurrency());
                code = "reservation.dynamic.discount.confirmation.fix-per-reservation.message";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected discount code type");
            }
        }
        for (ContentLanguage cl : event.getContentLanguages()) {
            res.put(cl.getLocale().getLanguage(), messageSource.getMessage(code, new Object[]{amount}, cl.getLocale()));
        }
        return res;
    }
}

