/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.user;

import alfio.controller.form.PollVoteForm;
import alfio.manager.PollManager;
import alfio.manager.support.response.ValidatedResponse;
import alfio.model.poll.Poll;
import alfio.model.poll.PollWithOptions;
import alfio.model.result.Result;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/public/event/{eventName}/poll"})
public class PollApiController {
    private final PollManager pollManager;

    @GetMapping(value={""})
    ResponseEntity<ValidatedResponse<List<Poll>>> getAll(@PathVariable String eventName, @RequestParam(value="pin") String pin) {
        Result result = this.pollManager.getActiveForEvent(eventName, pin);
        if (result.isSuccess()) {
            return ResponseEntity.ok((Object)ValidatedResponse.fromResult((Result)result, (String)"pin"));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)ValidatedResponse.fromResult((Result)result, (String)"pin"));
    }

    @GetMapping(value={"/{pollId}"})
    ResponseEntity<ValidatedResponse<PollWithOptions>> getSingle(@PathVariable String eventName, @PathVariable Long pollId, @RequestParam(value="pin") String pin) {
        Result result = this.pollManager.getSingleActiveForEvent(eventName, pollId, pin);
        if (result.isSuccess()) {
            return ResponseEntity.ok((Object)ValidatedResponse.fromResult((Result)result, (String)"pin"));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)ValidatedResponse.fromResult((Result)result, (String)"pin"));
    }

    @PostMapping(value={"/{pollId}/answer"})
    ResponseEntity<ValidatedResponse<Boolean>> registerAnswer(@PathVariable String eventName, @PathVariable Long pollId, @RequestBody PollVoteForm form) {
        Result result = this.pollManager.registerAnswer(eventName, pollId, form.getOptionId(), form.getPin());
        if (result.isSuccess()) {
            return ResponseEntity.ok((Object)ValidatedResponse.fromResult((Result)result, (String)"pin"));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)ValidatedResponse.fromResult((Result)result, (String)"pin"));
    }

    @ConstructorProperties(value={"pollManager"})
    @Generated
    public PollApiController(PollManager pollManager) {
        this.pollManager = pollManager;
    }
}

