/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.user;

import alfio.controller.api.support.BookingInfoTicketLoader;
import alfio.controller.api.support.TicketHelper;
import alfio.controller.api.v2.model.PaymentProxyWithParameters;
import alfio.controller.api.v2.model.ReservationInfo;
import alfio.controller.api.v2.model.ReservationPaymentResult;
import alfio.controller.api.v2.model.ReservationStatusInfo;
import alfio.controller.api.v2.user.support.ReservationAccessDenied;
import alfio.controller.form.ContactAndTicketsForm;
import alfio.controller.form.PaymentForm;
import alfio.controller.form.ReadOnlyAdditionalFieldsContainer;
import alfio.controller.form.ReservationCodeForm;
import alfio.controller.form.UpdateSubscriptionOwnerForm;
import alfio.controller.support.CustomBindingResult;
import alfio.controller.support.TemplateProcessor;
import alfio.manager.AdditionalServiceManager;
import alfio.manager.BillingDocumentManager;
import alfio.manager.EuVatChecker;
import alfio.manager.ExtensionManager;
import alfio.manager.FileUploadManager;
import alfio.manager.PaymentManager;
import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.PurchaseContextManager;
import alfio.manager.RecaptchaService;
import alfio.manager.ReverseChargeManager;
import alfio.manager.SameCountryValidator;
import alfio.manager.TicketReservationManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.AdditionalServiceHelper;
import alfio.manager.support.PaymentResult;
import alfio.manager.support.response.ValidatedResponse;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.user.PublicUserManager;
import alfio.model.AdditionalServiceFieldValue;
import alfio.model.AdditionalServiceItem;
import alfio.model.AllocationStatus;
import alfio.model.BillingDocument;
import alfio.model.Configurable;
import alfio.model.ContentLanguage;
import alfio.model.CustomerName;
import alfio.model.Event;
import alfio.model.LocalizedContent;
import alfio.model.OrderSummary;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.PurchaseContextFieldValue;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.TicketReservationAdditionalInfo;
import alfio.model.TicketReservationInvoicingAdditionalInfo;
import alfio.model.TotalPrice;
import alfio.model.extension.CustomTaxPolicy;
import alfio.model.metadata.SubscriptionMetadata;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.subscription.UsageDetails;
import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.PaymentToken;
import alfio.model.transaction.TransactionInitializationToken;
import alfio.model.transaction.TransactionRequest;
import alfio.repository.EventRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.util.FileUtil;
import alfio.util.LocaleUtil;
import alfio.util.TemplateManager;
import alfio.util.TemplateResource;
import alfio.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v2/public/"})
public class ReservationApiV2Controller {
    private static final Logger log = LoggerFactory.getLogger(ReservationApiV2Controller.class);
    private final EventRepository eventRepository;
    private final TicketReservationManager ticketReservationManager;
    private final TicketReservationRepository ticketReservationRepository;
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;
    private final MessageSourceManager messageSourceManager;
    private final ConfigurationManager configurationManager;
    private final PaymentManager paymentManager;
    private final FileUploadManager fileUploadManager;
    private final TemplateManager templateManager;
    private final ExtensionManager extensionManager;
    private final TicketHelper ticketHelper;
    private final EuVatChecker vatChecker;
    private final RecaptchaService recaptchaService;
    private final BookingInfoTicketLoader bookingInfoTicketLoader;
    private final BillingDocumentManager billingDocumentManager;
    private final PurchaseContextManager purchaseContextManager;
    private final SubscriptionRepository subscriptionRepository;
    private final TicketRepository ticketRepository;
    private final PublicUserManager publicUserManager;
    private final ReverseChargeManager reverseChargeManager;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final AdditionalServiceManager additionalServiceManager;
    private final AdditionalServiceHelper additionalServiceHelper;
    private final PurchaseContextFieldManager purchaseContextFieldManager;

    @GetMapping(value={"/reservation/{reservationId}"})
    public ResponseEntity<ReservationInfo> getReservationInfo(@PathVariable String reservationId, Principal principal) {
        Optional<ResponseEntity> res = this.purchaseContextManager.findByReservationId(reservationId).flatMap(purchaseContext -> this.ticketReservationManager.findById(reservationId).flatMap(reservation -> {
            this.validateAccessToReservation(principal, reservation);
            OrderSummary orderSummary = this.ticketReservationManager.orderSummaryForReservationId(reservationId, purchaseContext);
            List ticketsInReservation = null;
            Set<Integer> categoryIds = null;
            TicketReservationAdditionalInfo additionalInfo = this.ticketReservationRepository.getAdditionalInfo(reservationId);
            boolean containsCategoriesLinkedToGroups = false;
            List additionalServices = null;
            Map descriptionsByFieldId = this.purchaseContextFieldManager.findDescriptionsGroupedByFieldId(purchaseContext);
            if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
                Event event = (Event)purchaseContext;
                List tickets = this.ticketReservationManager.findTicketsInReservation(reservationId);
                Set ticketIds = tickets.stream().map(Ticket::getId).collect(Collectors.toSet());
                if (!ticketIds.isEmpty()) {
                    Map<Integer, List<PurchaseContextFieldValue>> valuesByTicketIds = this.purchaseContextFieldRepository.findAllValuesByTicketIds(ticketIds).stream().collect(Collectors.groupingBy(PurchaseContextFieldValue::getTicketId));
                    Validator.AdditionalFieldsFilterer ticketFieldsFilterer = this.bookingInfoTicketLoader.getTicketFieldsFilterer(reservationId, event);
                    Map<Integer, List<Ticket>> ticketsByCategory = tickets.stream().collect(Collectors.groupingBy(Ticket::getCategoryId));
                    boolean hasPaidSupplement = this.ticketReservationManager.hasPaidSupplements(event.getId(), reservationId);
                    List categories = this.ticketCategoryRepository.findCategoriesInReservation(reservationId);
                    ticketsInReservation = ticketsByCategory.entrySet().stream().map(e -> {
                        TicketCategory tc = categories.stream().filter(t -> t.getId() == ((Integer)e.getKey()).intValue()).findFirst().orElseThrow();
                        EnumSet<PurchaseContextFieldConfiguration.Context> context = event.supportsLinkedAdditionalServices() ? EnumSet.of(PurchaseContextFieldConfiguration.Context.ATTENDEE) : PurchaseContextFieldConfiguration.EVENT_RELATED_CONTEXTS;
                        List ts = ((List)e.getValue()).stream().map(t -> this.bookingInfoTicketLoader.toBookingInfoTicket(t, hasPaidSupplement, event, ticketFieldsFilterer, descriptionsByFieldId, valuesByTicketIds, Map.of(), false, context)).collect(Collectors.toList());
                        return new ReservationInfo.TicketsByTicketCategory(tc.getName(), tc.getTicketAccessType(), ts);
                    }).collect(Collectors.toList());
                    containsCategoriesLinkedToGroups = this.ticketReservationManager.containsCategoriesLinkedToGroups(reservationId, event.getId());
                    categoryIds = ticketsByCategory.keySet();
                    List additionalServiceItems = this.additionalServiceManager.findItemsInReservation(event.getId(), reservationId);
                    Map additionalServicesByItemId = additionalServiceItems.isEmpty() ? Map.of() : this.purchaseContextFieldRepository.findAdditionalServicesValueByItemIds(additionalServiceItems.stream().map(AdditionalServiceItem::getId).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(AdditionalServiceFieldValue::getAdditionalServiceItemId));
                    additionalServices = this.additionalServiceHelper.getAdditionalServicesWithData((PurchaseContext)event, additionalServiceItems, additionalServicesByItemId, descriptionsByFieldId, tickets);
                }
            }
            String shortReservationId = this.configurationManager.getShortReservationID((Configurable)purchaseContext, reservation);
            Map formattedExpirationDate = reservation.getValidity() != null ? this.formatDateForLocales(purchaseContext, ZonedDateTime.ofInstant(reservation.getValidity().toInstant(), purchaseContext.getZoneId()), "datetime.pattern") : null;
            Optional paymentToken = this.paymentManager.getPaymentToken(reservationId);
            boolean tokenAcquired = paymentToken.isPresent();
            PaymentProxy selectedPaymentProxy = paymentToken.map(PaymentToken::getPaymentProvider).orElse(null);
            List subscriptionInfos = null;
            if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.subscription)) {
                subscriptionInfos = this.subscriptionRepository.findSubscriptionsByReservationId(reservationId).stream().limit(1L).map(s -> {
                    int usageCount = this.ticketRepository.countSubscriptionUsage(s.getId(), null);
                    SubscriptionMetadata metadata = Objects.requireNonNullElseGet(this.subscriptionRepository.getSubscriptionMetadata(s.getId()), SubscriptionMetadata::empty);
                    List fields = this.purchaseContextFieldManager.findAdditionalFields(purchaseContext);
                    Map<Long, List<PurchaseContextFieldValue>> valuesById = this.purchaseContextFieldRepository.findAllValuesBySubscriptionIds(List.of(s.getId())).stream().collect(Collectors.groupingBy(PurchaseContextFieldValue::getFieldConfigurationId));
                    List additionalFields = fields.stream().sorted(Comparator.comparing(PurchaseContextFieldConfiguration::getOrder)).flatMap(tfc -> BookingInfoTicketLoader.toAdditionalFieldsStream((Map)descriptionsByFieldId, (PurchaseContextFieldConfiguration)tfc, (Map)valuesById)).collect(Collectors.toList());
                    return new ReservationInfo.SubscriptionInfo(s.getStatus() == AllocationStatus.ACQUIRED ? s.getId() : null, s.getStatus() == AllocationStatus.ACQUIRED ? s.getPin() : null, UsageDetails.fromSubscription((Subscription)s, (int)usageCount), new ReservationInfo.SubscriptionOwner(s.getFirstName(), s.getLastName(), s.getEmail()), metadata.getConfiguration(), additionalFields);
                }).collect(Collectors.toList());
            }
            return Optional.of(new ReservationInfo(reservation.getId(), shortReservationId, reservation.getFirstName(), reservation.getLastName(), reservation.getEmail(), reservation.getValidity().getTime(), Objects.requireNonNullElse(ticketsInReservation, List.of()), new ReservationInfo.ReservationInfoOrderSummary(orderSummary), reservation.getStatus(), additionalInfo.hasBeenValidated(), formattedExpirationDate, reservation.getInvoiceNumber(), reservation.isInvoiceRequested(), reservation.getHasInvoiceOrReceiptDocument(), reservation.getHasBeenPaid(), tokenAcquired, selectedPaymentProxy != null ? selectedPaymentProxy : reservation.getPaymentMethod(), additionalInfo.getAddCompanyBillingDetails(), reservation.getCustomerReference(), additionalInfo.getSkipVatNr(), reservation.getBillingAddress(), additionalInfo.getBillingDetails(), containsCategoriesLinkedToGroups, this.getActivePaymentMethods(purchaseContext, (Collection)Objects.requireNonNullElse(categoryIds, Set.of()), orderSummary, reservationId), subscriptionInfos, this.ticketReservationRepository.getMetadata(reservationId), Objects.requireNonNullElse(additionalServices, List.of())));
        }));
        return res.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    private Map<PaymentMethod, PaymentProxyWithParameters> getActivePaymentMethods(PurchaseContext purchaseContext, Collection<Integer> categoryIds, OrderSummary orderSummary, String reservationId) {
        if (!purchaseContext.isFreeOfCharge()) {
            List blacklistedMethodsForReservation = this.configurationManager.getBlacklistedMethodsForReservation(purchaseContext, categoryIds);
            return this.paymentManager.getPaymentMethods(purchaseContext, new TransactionRequest(orderSummary.getOriginalTotalPrice(), this.ticketReservationRepository.getBillingDetailsForReservation(reservationId))).stream().filter(p -> !blacklistedMethodsForReservation.contains(p.getPaymentMethod())).filter(p -> TicketReservationManager.isValidPaymentMethod((PaymentManager.PaymentMethodDTO)p, (PurchaseContext)purchaseContext, (ConfigurationManager)this.configurationManager)).collect(Collectors.toMap(PaymentManager.PaymentMethodDTO::getPaymentMethod, pm -> new PaymentProxyWithParameters(pm.getPaymentProxy(), this.paymentManager.loadModelOptionsFor(List.of(pm.getPaymentProxy()), purchaseContext))));
        }
        return Map.of();
    }

    @GetMapping(value={"/reservation/{reservationId}/status"})
    public ResponseEntity<ReservationStatusInfo> getReservationStatus(@PathVariable String reservationId) {
        Optional<ReservationStatusInfo> res = this.ticketReservationRepository.findOptionalStatusAndValidationById(reservationId).map(status -> new ReservationStatusInfo(status.getStatus(), Boolean.TRUE.equals(status.getValidated())));
        return res.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/reservation/{reservationId}"})
    public ResponseEntity<Boolean> cancelPendingReservation(@PathVariable String reservationId) {
        this.getReservationWithPendingStatus(reservationId).ifPresent(er -> this.ticketReservationManager.cancelPendingReservation(reservationId, false, null));
        return ResponseEntity.ok((Object)true);
    }

    @PostMapping(value={"/reservation/{reservationId}/back-to-booking"})
    public ResponseEntity<Boolean> backToBooking(@PathVariable String reservationId) {
        this.getReservationWithPendingStatus(reservationId).ifPresent(er -> this.ticketReservationRepository.updateValidationStatus(reservationId, false));
        return ResponseEntity.ok((Object)true);
    }

    @PostMapping(value={"/reservation/{reservationId}"})
    public ResponseEntity<ValidatedResponse<ReservationPaymentResult>> confirmOverview(@PathVariable String reservationId, @RequestParam(value="lang") String lang, @RequestBody PaymentForm paymentForm, BindingResult bindingResult, HttpServletRequest request, Principal principal) {
        return this.getReservation(reservationId).map(er -> {
            PaymentSpecification spec;
            PaymentResult status;
            PurchaseContext event = (PurchaseContext)er.getLeft();
            TicketReservation reservation = (TicketReservation)er.getRight();
            Locale locale = LocaleUtil.forLanguageTag((String)lang, (LocalizedContent)event);
            this.validateAccessToReservation(principal, reservation);
            if (!reservation.getValidity().after(new Date())) {
                bindingResult.reject("error.STEP_2_ORDER_HAS_EXPIRED");
            }
            TotalPrice reservationCost = (TotalPrice)this.ticketReservationManager.totalReservationCostWithVAT(reservationId).getLeft();
            paymentForm.validate(bindingResult, event, reservationCost);
            if (bindingResult.hasErrors()) {
                return ReservationApiV2Controller.buildReservationPaymentStatus((BindingResult)bindingResult);
            }
            if (this.isCaptchaInvalid(reservationCost.getPriceWithVAT(), paymentForm.getPaymentProxy(), paymentForm.getCaptcha(), request, (Configurable)event)) {
                log.debug("captcha validation failed.");
                bindingResult.reject("error.STEP_2_CAPTCHA_VALIDATION_FAILED");
            }
            if (!bindingResult.hasErrors()) {
                this.extensionManager.handleReservationValidation(event, reservation, (Object)paymentForm, bindingResult);
            }
            if (bindingResult.hasErrors()) {
                return ReservationApiV2Controller.buildReservationPaymentStatus((BindingResult)bindingResult);
            }
            CustomerName customerName = new CustomerName(reservation.getFullName(), reservation.getFirstName(), reservation.getLastName(), true);
            OrderSummary orderSummary = this.ticketReservationManager.orderSummaryForReservationId(reservationId, event);
            PaymentToken paymentToken = this.paymentManager.getPaymentToken(reservationId).orElse(null);
            if (paymentToken == null && StringUtils.isNotEmpty((CharSequence)paymentForm.getGatewayToken())) {
                paymentToken = this.paymentManager.buildPaymentToken(paymentForm.getGatewayToken(), paymentForm.getPaymentProxy(), new PaymentContext(event, reservationId));
            }
            if ((status = this.ticketReservationManager.performPayment(spec = new PaymentSpecification(reservationId, paymentToken, reservationCost.getPriceWithVAT(), event, reservation.getEmail(), customerName, reservation.getBillingAddress(), reservation.getCustomerReference(), locale, reservation.isInvoiceRequested(), !reservation.isDirectAssignmentRequested(), orderSummary, reservation.getVatCountryCode(), reservation.getVatNr(), reservation.getVatStatus(), Boolean.TRUE.equals(paymentForm.getTermAndConditionsAccepted()), Boolean.TRUE.equals(paymentForm.getPrivacyPolicyAccepted())), reservationCost, paymentForm.getPaymentProxy(), paymentForm.getSelectedPaymentMethod(), principal)).isRedirect()) {
                ValidatedResponse body = ValidatedResponse.toResponse((BindingResult)bindingResult, (Object)new ReservationPaymentResult(!bindingResult.hasErrors(), true, status.getRedirectUrl(), status.isFailed(), status.getGatewayIdOrNull()));
                return ResponseEntity.ok((Object)body);
            }
            if (!status.isSuccessful()) {
                String errorMessageCode = status.getErrorCode().orElse("error.STEP2_STRIPE_unexpected");
                DefaultMessageSourceResolvable message = new DefaultMessageSourceResolvable(new String[]{errorMessageCode, "error.STEP2_STRIPE_unexpected"});
                bindingResult.reject("error.STEP_2_PAYMENT_PROCESSING_ERROR", new Object[]{this.messageSourceManager.getMessageSourceFor(event).getMessage((MessageSourceResolvable)message, locale)}, null);
                return ReservationApiV2Controller.buildReservationPaymentStatus((BindingResult)bindingResult);
            }
            return ReservationApiV2Controller.buildReservationPaymentStatus((BindingResult)bindingResult);
        }).orElseGet(() -> ResponseEntity.notFound().build());
    }

    private static ResponseEntity<ValidatedResponse<ReservationPaymentResult>> buildReservationPaymentStatus(BindingResult bindingResult) {
        ValidatedResponse body = ValidatedResponse.toResponse((BindingResult)bindingResult, (Object)new ReservationPaymentResult(!bindingResult.hasErrors(), false, null, true, null));
        return ResponseEntity.status((HttpStatusCode)(bindingResult.hasErrors() ? HttpStatus.UNPROCESSABLE_ENTITY : HttpStatus.OK)).body((Object)body);
    }

    @PostMapping(value={"/reservation/{reservationId}/validate-to-overview"})
    public ResponseEntity<ValidatedResponse<Boolean>> validateToOverview(@PathVariable String reservationId, @RequestParam(value="lang") String lang, @RequestParam(value="ignoreWarnings", defaultValue="false") boolean ignoreWarnings, @RequestBody ContactAndTicketsForm contactAndTicketsForm, BindingResult br, Authentication principal) {
        CustomBindingResult bindingResult = new CustomBindingResult(br);
        return this.getPurchaseContextAndReservationWithPendingStatus(reservationId).map(er -> {
            PurchaseContext purchaseContext = (PurchaseContext)er.getLeft();
            TicketReservation reservation = (TicketReservation)er.getRight();
            this.validateAccessToReservation((Principal)principal, reservation);
            Locale locale = LocaleUtil.forLanguageTag((String)lang, (LocalizedContent)purchaseContext);
            TotalPrice reservationCost = (TotalPrice)this.ticketReservationManager.totalReservationCostWithVAT(reservation.withVatStatus(purchaseContext.getVatStatus())).getLeft();
            purchaseContext.event().ifPresent(event -> {
                boolean forceAssignment = this.configurationManager.getFor(ConfigurationKeys.FORCE_TICKET_OWNER_ASSIGNMENT_AT_RESERVATION, purchaseContext.getConfigurationLevel()).getValueAsBooleanOrDefault();
                if (forceAssignment || this.ticketReservationManager.containsCategoriesLinkedToGroups(reservationId, event.getId())) {
                    contactAndTicketsForm.setPostponeAssignment(false);
                }
            });
            boolean invoiceOnly = this.configurationManager.isInvoiceOnly((Configurable)purchaseContext);
            if (invoiceOnly && reservationCost.getPriceWithVAT() > 0) {
                contactAndTicketsForm.setInvoiceRequested(true);
            } else if (reservationCost.getPriceWithVAT() == 0) {
                contactAndTicketsForm.setInvoiceRequested(false);
            }
            CustomerName customerName = new CustomerName(contactAndTicketsForm.getFullName(), contactAndTicketsForm.getFirstName(), contactAndTicketsForm.getLastName(), true, false);
            this.ticketReservationRepository.resetVat(reservationId, contactAndTicketsForm.isInvoiceRequested(), purchaseContext.getVatStatus(), reservation.getSrcPriceCts(), reservationCost.getPriceWithVAT(), reservationCost.getVAT(), Math.abs(reservationCost.getDiscount()), reservation.getCurrencyCode());
            Optional optionalCustomTaxPolicy = this.extensionManager.handleCustomTaxPolicy(purchaseContext, reservationId, contactAndTicketsForm, reservationCost);
            if (optionalCustomTaxPolicy.isPresent()) {
                log.debug("Custom tax policy returned for reservation {}. Applying it.", (Object)reservationId);
                this.reverseChargeManager.applyCustomTaxPolicy(purchaseContext, (CustomTaxPolicy)optionalCustomTaxPolicy.get(), reservationId, contactAndTicketsForm, bindingResult);
            } else if (reservationCost.getPriceWithVAT() > 0 && (contactAndTicketsForm.isBusiness() || this.configurationManager.noTaxesFlagDefinedFor(this.ticketCategoryRepository.findCategoriesInReservation(reservationId)))) {
                this.reverseChargeManager.checkAndApplyVATRules(purchaseContext, reservationId, contactAndTicketsForm, (BindingResult)bindingResult);
            } else if (reservationCost.getPriceWithVAT() > 0) {
                this.reverseChargeManager.resetVat(purchaseContext, reservationId);
            }
            this.ticketReservationManager.updateReservation(reservationId, customerName, contactAndTicketsForm.getEmail(), contactAndTicketsForm.getBillingAddressCompany(), contactAndTicketsForm.getBillingAddressLine1(), contactAndTicketsForm.getBillingAddressLine2(), contactAndTicketsForm.getBillingAddressZip(), contactAndTicketsForm.getBillingAddressCity(), contactAndTicketsForm.getBillingAddressState(), contactAndTicketsForm.getVatCountryCode(), contactAndTicketsForm.getCustomerReference(), contactAndTicketsForm.getVatNr(), contactAndTicketsForm.isInvoiceRequested(), contactAndTicketsForm.getAddCompanyBillingDetails(), contactAndTicketsForm.canSkipVatNrCheck(), false, locale, (Principal)principal);
            boolean italyEInvoicing = this.configurationManager.getFor(ConfigurationKeys.ENABLE_ITALY_E_INVOICING, purchaseContext.getConfigurationLevel()).getValueAsBooleanOrDefault();
            if (italyEInvoicing) {
                this.ticketReservationManager.updateReservationInvoicingAdditionalInformation(reservationId, purchaseContext, new TicketReservationInvoicingAdditionalInfo(this.getItalianInvoicingInfo(contactAndTicketsForm)));
            }
            if (purchaseContext instanceof Event) {
                Event event2 = (Event)purchaseContext;
                if (event2.supportsLinkedAdditionalServices() && contactAndTicketsForm.hasAdditionalServices()) {
                    List tickets = this.ticketReservationManager.findTicketsInReservation(reservationId);
                    this.additionalServiceManager.linkItemsToTickets(reservationId, contactAndTicketsForm.getAdditionalServices(), tickets);
                    this.additionalServiceManager.persistFieldsForAdditionalItems(event2.getId(), event2.getOrganizationId(), contactAndTicketsForm.getAdditionalServices(), tickets);
                }
                this.assignTickets(event2, reservationId, contactAndTicketsForm, (BindingResult)bindingResult, locale, true, true);
            }
            if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.subscription)) {
                UpdateSubscriptionOwnerForm owner = contactAndTicketsForm.getSubscriptionOwner();
                if (contactAndTicketsForm.isDifferentSubscriptionOwner()) {
                    Validate.isTrue((this.subscriptionRepository.assignSubscription(reservationId, owner.getFirstName(), owner.getLastName(), owner.getEmail()) == 1 ? 1 : 0) != 0);
                } else {
                    Validate.isTrue((this.subscriptionRepository.assignSubscription(reservationId, null, null, null) == 1 ? 1 : 0) != 0);
                }
                if (MapUtils.isNotEmpty((Map)owner.getAdditional())) {
                    this.purchaseContextFieldManager.updateFieldsForReservation((ReadOnlyAdditionalFieldsContainer)owner, purchaseContext, null, ((Subscription)this.subscriptionRepository.findSubscriptionsByReservationId(reservationId).get(0)).getId());
                }
            }
            Map<ConfigurationKeys, Boolean> formValidationParameters = Collections.singletonMap(ConfigurationKeys.ENABLE_ITALY_E_INVOICING, italyEInvoicing);
            Optional<Validator.AdditionalFieldsFilterer> fieldsFilterer = purchaseContext.event().map(event -> this.bookingInfoTicketLoader.getTicketFieldsFilterer(reservationId, event)).or(() -> Optional.of(this.bookingInfoTicketLoader.getSubscriptionFieldsFilterer(reservationId, (SubscriptionDescriptor)purchaseContext)));
            contactAndTicketsForm.validate(bindingResult, purchaseContext, new SameCountryValidator(this.configurationManager, this.extensionManager, purchaseContext, reservationId, this.vatChecker), formValidationParameters, fieldsFilterer, reservationCost.requiresPayment(), this.extensionManager, () -> this.additionalServiceManager.findItemsInReservation(purchaseContext, reservationId));
            if (!bindingResult.hasErrors()) {
                this.extensionManager.handleReservationValidation(purchaseContext, reservation, (Object)contactAndTicketsForm, (BindingResult)bindingResult);
            }
            if (!(bindingResult.hasErrors() || bindingResult.hasWarnings() && !ignoreWarnings)) {
                this.ticketReservationManager.flagAsValidated(reservationId, purchaseContext, bindingResult.getWarnings());
                if (principal != null && this.configurationManager.isPublicOpenIdEnabled()) {
                    Map additionalData = contactAndTicketsForm.getTickets().values().stream().filter(f -> principal.getName().equals(f.getEmail()) && !f.getAdditional().isEmpty()).limit(1L).map(form -> this.publicUserManager.buildAdditionalInfoWithLabels(principal, purchaseContext, form)).findFirst().orElse(Map.of());
                    this.publicUserManager.persistProfileForPublicUser((Principal)principal, (Object)contactAndTicketsForm, (BindingResult)bindingResult, this.ticketReservationManager.loadAdditionalInfo(reservationId), additionalData);
                }
            }
            ValidatedResponse body = ValidatedResponse.toResponse((BindingResult)bindingResult, (Object)(!bindingResult.hasErrors() ? 1 : 0));
            return ResponseEntity.status((HttpStatusCode)(bindingResult.hasErrors() ? HttpStatus.UNPROCESSABLE_ENTITY : HttpStatus.OK)).body((Object)body);
        }).orElseGet(() -> ResponseEntity.notFound().build());
    }

    private void validateAccessToReservation(Principal principal, TicketReservation reservation) {
        if (!this.ticketReservationManager.validateAccessToReservation(reservation, principal)) {
            log.warn("Access to reservation {} has been denied to principal {}", (Object)reservation.getId(), (Object)principal);
            throw new ReservationAccessDenied();
        }
    }

    private TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing getItalianInvoicingInfo(ContactAndTicketsForm contactAndTicketsForm) {
        return new TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing(StringUtils.upperCase((String)contactAndTicketsForm.getItalyEInvoicingFiscalCode()), contactAndTicketsForm.getItalyEInvoicingReferenceType(), contactAndTicketsForm.getItalyEInvoicingReferenceAddresseeCode(), contactAndTicketsForm.getItalyEInvoicingReferencePEC(), contactAndTicketsForm.isItalyEInvoicingSplitPayment());
    }

    private void assignTickets(Event event, String reservationId, ContactAndTicketsForm contactAndTicketsForm, BindingResult bindingResult, Locale locale, boolean preAssign, boolean skipValidation) {
        if (!contactAndTicketsForm.isPostponeAssignment()) {
            contactAndTicketsForm.getTickets().forEach((ticketPublicId, owner) -> {
                UUID publicUUID = UUID.fromString(ticketPublicId);
                if (preAssign) {
                    Optional<Object> bindingResultOptional = skipValidation ? Optional.empty() : Optional.of(bindingResult);
                    Validate.isTrue((boolean)this.ticketHelper.preAssignTicket(event.getShortName(), reservationId, publicUUID, owner, bindingResultOptional, locale).isPresent());
                } else {
                    Validate.isTrue((boolean)this.ticketHelper.assignTicket(event.getShortName(), publicUUID, owner, Optional.of(bindingResult), locale, Optional.empty(), true).isPresent());
                }
            });
        }
    }

    private Optional<Pair<PurchaseContext, TicketReservation>> getReservation(String reservationId) {
        return this.purchaseContextManager.findByReservationId(reservationId).flatMap(purchaseContext -> this.ticketReservationManager.findById(reservationId).flatMap(reservation -> Optional.of(Pair.of((Object)purchaseContext, (Object)reservation))));
    }

    private Optional<TicketReservation> getReservationWithPendingStatus(String reservationId) {
        return this.ticketReservationManager.findById(reservationId).filter(reservation -> reservation.getStatus() == TicketReservation.TicketReservationStatus.PENDING);
    }

    private Optional<Pair<PurchaseContext, TicketReservation>> getPurchaseContextAndReservationWithPendingStatus(String reservationId) {
        return this.purchaseContextManager.findByReservationId(reservationId).flatMap(event -> this.ticketReservationManager.findById(reservationId).filter(reservation -> reservation.getStatus() == TicketReservation.TicketReservationStatus.PENDING).flatMap(reservation -> Optional.of(Pair.of((Object)event, (Object)reservation))));
    }

    @PostMapping(value={"/{purchaseContextType}/{publicIdentifier}/reservation/{reservationId}/re-send-email"})
    public ResponseEntity<Boolean> reSendReservationConfirmationEmail(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String publicIdentifier, @PathVariable String reservationId, @RequestParam(value="lang") String lang, Principal principal) {
        return ResponseEntity.of(this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier).map(purchaseContext -> this.ticketReservationManager.findById(reservationId).map(ticketReservation -> {
            this.validateAccessToReservation(principal, ticketReservation);
            this.ticketReservationManager.sendConfirmationEmail(purchaseContext, ticketReservation, LocaleUtil.forLanguageTag((String)lang, (LocalizedContent)purchaseContext), principal != null ? principal.getName() : null);
            return true;
        }).orElse(false)));
    }

    @GetMapping(value={"/event/{eventName}/reservation/{reservationId}/receipt"})
    public ResponseEntity<Void> getReceipt(@PathVariable String eventName, @PathVariable String reservationId, HttpServletResponse response, Authentication authentication) {
        return this.handleReservationWith(eventName, reservationId, authentication, this.generatePdfFunction(false, response));
    }

    @GetMapping(value={"/event/{eventName}/reservation/{reservationId}/invoice"})
    public ResponseEntity<Void> getInvoice(@PathVariable String eventName, @PathVariable String reservationId, HttpServletResponse response, Authentication authentication) {
        return this.handleReservationWith(eventName, reservationId, authentication, this.generatePdfFunction(true, response));
    }

    private ResponseEntity<Void> handleReservationWith(String eventName, String reservationId, Authentication authentication, BiFunction<Event, TicketReservation, ResponseEntity<Void>> with) {
        ResponseEntity notFound = ResponseEntity.notFound().build();
        ResponseEntity badRequest = ResponseEntity.badRequest().build();
        return this.eventRepository.findOptionalByShortName(eventName).map(event -> {
            if (this.canAccessReceiptOrInvoice((Configurable)event, authentication)) {
                return this.ticketReservationManager.findById(reservationId).map(ticketReservation -> (ResponseEntity)with.apply((Event)event, (TicketReservation)ticketReservation)).orElse(notFound);
            }
            return badRequest;
        }).orElse(notFound);
    }

    private boolean canAccessReceiptOrInvoice(Configurable configurable, Authentication authentication) {
        return this.configurationManager.canGenerateReceiptOrInvoiceToCustomer(configurable) || !this.isAnonymous(authentication);
    }

    private boolean isAnonymous(Authentication authentication) {
        return authentication == null || authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch("ROLE_ANONYMOUS"::equals);
    }

    private BiFunction<Event, TicketReservation, ResponseEntity<Void>> generatePdfFunction(boolean forInvoice, HttpServletResponse response) {
        return (event, reservation) -> {
            if (forInvoice ^ reservation.getInvoiceNumber() != null || reservation.isCancelled()) {
                return ResponseEntity.notFound().build();
            }
            BillingDocument billingDocument = this.billingDocumentManager.getOrCreateBillingDocument((PurchaseContext)event, reservation, null, this.ticketReservationManager.orderSummaryForReservation(reservation, (PurchaseContext)event));
            try {
                FileUtil.sendHeaders((HttpServletResponse)response, (String)event.getShortName(), (String)reservation.getId(), (BillingDocument)billingDocument);
                TemplateProcessor.buildReceiptOrInvoicePdf((PurchaseContext)event, (FileUploadManager)this.fileUploadManager, (Locale)LocaleUtil.forLanguageTag((String)reservation.getUserLanguage()), (TemplateManager)this.templateManager, (Map)billingDocument.getModel(), (TemplateResource)(forInvoice ? TemplateResource.INVOICE_PDF : TemplateResource.RECEIPT_PDF), (ExtensionManager)this.extensionManager, (OutputStream)response.getOutputStream());
                return ResponseEntity.ok().build();
            }
            catch (IOException ioe) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
            }
        };
    }

    @PostMapping(value={"/reservation/{reservationId}/payment/{method}/init"})
    public ResponseEntity<TransactionInitializationToken> initTransaction(@PathVariable String reservationId, @PathVariable(value="method") String paymentMethodStr, @RequestParam MultiValueMap<String, String> allParams) {
        PaymentMethod paymentMethod = PaymentMethod.safeParse((String)paymentMethodStr);
        if (paymentMethod == null) {
            return ResponseEntity.badRequest().build();
        }
        Optional<ResponseEntity> responseEntity = this.purchaseContextManager.getReservationWithPurchaseContext(reservationId).map(pair -> {
            PurchaseContext event = (PurchaseContext)pair.getLeft();
            return this.ticketReservationManager.initTransaction(event, reservationId, paymentMethod, (Map)allParams).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
        });
        return responseEntity.orElseGet(() -> ResponseEntity.badRequest().build());
    }

    @DeleteMapping(value={"/reservation/{reservationId}/payment/token"})
    public ResponseEntity<Boolean> removeToken(@PathVariable String reservationId) {
        Boolean res = this.purchaseContextManager.getReservationWithPurchaseContext(reservationId).map(et -> this.paymentManager.removePaymentTokenReservation(((TicketReservation)et.getRight()).getId())).orElse(false);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/reservation/{reservationId}/payment"})
    public ResponseEntity<Boolean> deletePaymentAttempt(@PathVariable String reservationId) {
        Boolean res = this.purchaseContextManager.getReservationWithPurchaseContext(reservationId).map(et -> this.ticketReservationManager.cancelPendingPayment(((TicketReservation)et.getRight()).getId(), (PurchaseContext)et.getLeft())).orElse(false);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/reservation/{reservationId}/payment/{method}/status"})
    public ResponseEntity<ReservationPaymentResult> getTransactionStatus(@PathVariable String reservationId, @PathVariable(value="method") String paymentMethodStr) {
        PaymentMethod paymentMethod = PaymentMethod.safeParse((String)paymentMethodStr);
        if (paymentMethod == null) {
            return ResponseEntity.badRequest().build();
        }
        return this.purchaseContextManager.getReservationWithPurchaseContext(reservationId).flatMap(pair -> this.paymentManager.getTransactionStatus((TicketReservation)pair.getRight(), paymentMethod)).map(pr -> ResponseEntity.ok((Object)new ReservationPaymentResult(pr.isSuccessful(), pr.isRedirect(), pr.getRedirectUrl(), pr.isFailed(), pr.getGatewayIdOrNull()))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/reservation/{reservationId}/apply-code"})
    public ResponseEntity<ValidatedResponse<Boolean>> applyCode(@PathVariable String reservationId, @RequestBody ReservationCodeForm reservationCodeForm, BindingResult bindingResult) {
        if (reservationCodeForm.getType() != ReservationCodeForm.ReservationCodeType.SUBSCRIPTION) {
            throw new IllegalStateException(reservationCodeForm.getType() + " not supported");
        }
        boolean res = this.purchaseContextManager.getReservationWithPurchaseContext(reservationId).map(et -> this.ticketReservationManager.validateAndApplySubscriptionCode((PurchaseContext)et.getLeft(), (TicketReservation)et.getRight(), reservationCodeForm.getCodeAsUUID(), reservationCodeForm.getCode(), reservationCodeForm.getEmail(), bindingResult)).orElse(false);
        return ResponseEntity.ok((Object)ValidatedResponse.toResponse((BindingResult)bindingResult, (Object)res));
    }

    @DeleteMapping(value={"/reservation/{reservationId}/remove-code"})
    public ResponseEntity<Boolean> removeCode(@PathVariable String reservationId, @RequestParam(value="type") ReservationCodeForm.ReservationCodeType type) {
        boolean res = false;
        if (type == ReservationCodeForm.ReservationCodeType.SUBSCRIPTION) {
            res = this.purchaseContextManager.getReservationWithPurchaseContext(reservationId).map(et -> this.ticketReservationManager.removeSubscription((TicketReservation)et.getRight())).orElse(false);
        }
        return ResponseEntity.ok((Object)res);
    }

    private Map<String, String> formatDateForLocales(PurchaseContext purchaseContext, ZonedDateTime date, String formattingCode) {
        MessageSource messageSource = this.messageSourceManager.getMessageSourceFor(purchaseContext);
        HashMap<String, String> res = new HashMap<String, String>();
        for (ContentLanguage cl : purchaseContext.getContentLanguages()) {
            String formatter = messageSource.getMessage(formattingCode, null, cl.getLocale());
            res.put(cl.getLocale().getLanguage(), DateTimeFormatter.ofPattern(formatter, cl.getLocale()).format(date));
        }
        return res;
    }

    private boolean isCaptchaInvalid(int cost, PaymentProxy paymentMethod, String recaptchaResponse, HttpServletRequest request, Configurable configurable) {
        return (cost == 0 || paymentMethod == PaymentProxy.OFFLINE || paymentMethod == PaymentProxy.ON_SITE) && this.configurationManager.isRecaptchaForOfflinePaymentAndFreeEnabled(configurable.getConfigurationLevel()) && !this.recaptchaService.checkRecaptcha(recaptchaResponse, request);
    }

    @ConstructorProperties(value={"eventRepository", "ticketReservationManager", "ticketReservationRepository", "purchaseContextFieldRepository", "messageSourceManager", "configurationManager", "paymentManager", "fileUploadManager", "templateManager", "extensionManager", "ticketHelper", "vatChecker", "recaptchaService", "bookingInfoTicketLoader", "billingDocumentManager", "purchaseContextManager", "subscriptionRepository", "ticketRepository", "publicUserManager", "reverseChargeManager", "ticketCategoryRepository", "additionalServiceManager", "additionalServiceHelper", "purchaseContextFieldManager"})
    @Generated
    public ReservationApiV2Controller(EventRepository eventRepository, TicketReservationManager ticketReservationManager, TicketReservationRepository ticketReservationRepository, PurchaseContextFieldRepository purchaseContextFieldRepository, MessageSourceManager messageSourceManager, ConfigurationManager configurationManager, PaymentManager paymentManager, FileUploadManager fileUploadManager, TemplateManager templateManager, ExtensionManager extensionManager, TicketHelper ticketHelper, EuVatChecker vatChecker, RecaptchaService recaptchaService, BookingInfoTicketLoader bookingInfoTicketLoader, BillingDocumentManager billingDocumentManager, PurchaseContextManager purchaseContextManager, SubscriptionRepository subscriptionRepository, TicketRepository ticketRepository, PublicUserManager publicUserManager, ReverseChargeManager reverseChargeManager, TicketCategoryRepository ticketCategoryRepository, AdditionalServiceManager additionalServiceManager, AdditionalServiceHelper additionalServiceHelper, PurchaseContextFieldManager purchaseContextFieldManager) {
        this.eventRepository = eventRepository;
        this.ticketReservationManager = ticketReservationManager;
        this.ticketReservationRepository = ticketReservationRepository;
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
        this.messageSourceManager = messageSourceManager;
        this.configurationManager = configurationManager;
        this.paymentManager = paymentManager;
        this.fileUploadManager = fileUploadManager;
        this.templateManager = templateManager;
        this.extensionManager = extensionManager;
        this.ticketHelper = ticketHelper;
        this.vatChecker = vatChecker;
        this.recaptchaService = recaptchaService;
        this.bookingInfoTicketLoader = bookingInfoTicketLoader;
        this.billingDocumentManager = billingDocumentManager;
        this.purchaseContextManager = purchaseContextManager;
        this.subscriptionRepository = subscriptionRepository;
        this.ticketRepository = ticketRepository;
        this.publicUserManager = publicUserManager;
        this.reverseChargeManager = reverseChargeManager;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.additionalServiceManager = additionalServiceManager;
        this.additionalServiceHelper = additionalServiceHelper;
        this.purchaseContextFieldManager = purchaseContextFieldManager;
    }
}

