/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.user;

import alfio.controller.api.support.CurrencyDescriptor;
import alfio.controller.api.v2.model.AnalyticsConfiguration;
import alfio.controller.api.v2.model.BasicSubscriptionDescriptorInfo;
import alfio.controller.api.v2.model.DatesWithTimeZoneOffset;
import alfio.controller.api.v2.model.EmbeddingConfiguration;
import alfio.controller.api.v2.model.EventWithAdditionalInfo;
import alfio.controller.api.v2.model.InvoicingConfiguration;
import alfio.controller.api.v2.model.Language;
import alfio.controller.api.v2.model.SubscriptionDescriptorWithAdditionalInfo;
import alfio.controller.api.v2.user.support.PurchaseContextInfoBuilder;
import alfio.controller.form.SearchOptions;
import alfio.controller.support.Formatters;
import alfio.manager.SubscriptionManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.i18n.I18nManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.support.response.ValidatedResponse;
import alfio.manager.system.ConfigurationManager;
import alfio.model.LocalizedContent;
import alfio.model.PriceContainer;
import alfio.model.PurchaseContext;
import alfio.model.result.ValidationResult;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.user.OrganizationRepository;
import alfio.util.ClockProvider;
import alfio.util.MonetaryUtil;
import alfio.util.ReservationUtil;
import jakarta.servlet.http.HttpSession;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.joda.money.CurrencyUnit;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.validation.MapBindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v2/public/"})
public class SubscriptionsApiController {
    private static final String DATE_FORMAT_KEY = "common.event.date-format";
    private final SubscriptionManager subscriptionManager;
    private final I18nManager i18nManager;
    private final TicketReservationManager reservationManager;
    private final ConfigurationManager configurationManager;
    private final OrganizationRepository organizationRepository;
    private final MessageSourceManager messageSourceManager;
    private final ClockProvider clockProvider;

    @GetMapping(value={"subscriptions"})
    public ResponseEntity<List<BasicSubscriptionDescriptorInfo>> listSubscriptions(SearchOptions searchOptions) {
        ZonedDateTime now = ZonedDateTime.now(ClockProvider.clock());
        List activeSubscriptions = this.subscriptionManager.getActivePublicSubscriptionsDescriptor(now, searchOptions).stream().map(s -> SubscriptionsApiController.subscriptionDescriptorMapper((SubscriptionDescriptor)s, (MessageSource)this.messageSourceManager.getMessageSourceFor((PurchaseContext)s))).collect(Collectors.toList());
        return ResponseEntity.ok(activeSubscriptions);
    }

    private static BasicSubscriptionDescriptorInfo subscriptionDescriptorMapper(SubscriptionDescriptor s, MessageSource messageSource) {
        CurrencyUnit currencyUnit = CurrencyUnit.of((String)s.getCurrency());
        CurrencyDescriptor currencyDescriptor = new CurrencyDescriptor(currencyUnit.getCode(), currencyUnit.toCurrency().getDisplayName(), currencyUnit.getSymbol(), currencyUnit.getDecimalPlaces());
        return new BasicSubscriptionDescriptorInfo(s.getId(), s.getFileBlobId(), s.getTitle(), s.getDescription(), DatesWithTimeZoneOffset.fromDates((ZonedDateTime)s.getOnSaleFrom(), (ZonedDateTime)s.getOnSaleTo()), s.getValidityType(), s.getUsageType(), s.getZoneId(), s.getValidityTimeUnit(), s.getValidityUnits(), Integer.valueOf(s.getMaxEntries()), null, null, MonetaryUtil.formatCents((int)s.getPrice(), (String)s.getCurrency()), s.getCurrency(), currencyDescriptor, s.getVat(), PriceContainer.VatStatus.isVatIncluded((PriceContainer.VatStatus)s.getVatStatus()), Formatters.getFormattedDate((LocalizedContent)s, (ZonedDateTime)s.getOnSaleFrom(), (String)"common.event.date-format", (MessageSource)messageSource), Formatters.getFormattedDate((LocalizedContent)s, (ZonedDateTime)s.getOnSaleTo(), (String)"common.event.date-format", (MessageSource)messageSource), Formatters.getFormattedDate((LocalizedContent)s, (ZonedDateTime)s.getValidityFrom(), (String)"common.event.date-format", (MessageSource)messageSource), Formatters.getFormattedDate((LocalizedContent)s, (ZonedDateTime)s.getValidityTo(), (String)"common.event.date-format", (MessageSource)messageSource), s.getContentLanguages().stream().map(cl -> new Language(cl.getLocale().getLanguage(), cl.getDisplayLanguage())).collect(Collectors.toList()));
    }

    @GetMapping(value={"subscription/{id}"})
    public ResponseEntity<SubscriptionDescriptorWithAdditionalInfo> getSubscriptionInfo(@PathVariable String id, HttpSession session) {
        Optional res = this.subscriptionManager.getSubscriptionById(UUID.fromString(id));
        return res.map(s -> {
            Map configurationsValues = PurchaseContextInfoBuilder.configurationsValues((PurchaseContext)s, (ConfigurationManager)this.configurationManager);
            InvoicingConfiguration invoicingInfo = PurchaseContextInfoBuilder.invoicingInfo((ConfigurationManager)this.configurationManager, (Map)configurationsValues);
            AnalyticsConfiguration analyticsConf = AnalyticsConfiguration.build((Map)configurationsValues, (HttpSession)session);
            EventWithAdditionalInfo.CaptchaConfiguration captchaConf = PurchaseContextInfoBuilder.captchaConfiguration((ConfigurationManager)this.configurationManager, (Map)configurationsValues);
            String bankAccount = ((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.BANK_ACCOUNT_NR)).getValueOrDefault("");
            List<String> bankAccountOwner = Arrays.asList(((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.BANK_ACCOUNT_OWNER)).getValueOrDefault("").split("\n"));
            Organization.OrganizationContact orgContact = this.organizationRepository.getContactById(s.getOrganizationId());
            MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)s);
            int available = !s.withinSalePeriod(this.clockProvider.getClock()) ? 0 : (s.getMaxAvailable() == -1 ? Integer.MAX_VALUE : this.subscriptionManager.countFree(s.getId()));
            return new SubscriptionDescriptorWithAdditionalInfo(s, invoicingInfo, analyticsConf, captchaConf, new EmbeddingConfiguration(((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.EMBED_POST_MESSAGE_ORIGIN)).getValueOrNull()), bankAccount, bankAccountOwner, orgContact.getEmail(), orgContact.getName(), DatesWithTimeZoneOffset.fromDates((ZonedDateTime)s.getOnSaleFrom(), (ZonedDateTime)s.getOnSaleTo()), Formatters.getFormattedDate((LocalizedContent)s, (ZonedDateTime)s.getOnSaleFrom(), (String)"common.event.date-format", (MessageSource)messageSource), Formatters.getFormattedDate((LocalizedContent)s, (ZonedDateTime)s.getOnSaleTo(), (String)"common.event.date-format", (MessageSource)messageSource), s.getZoneId().toString(), Formatters.getFormattedDate((LocalizedContent)s, (ZonedDateTime)s.getValidityFrom(), (String)"common.event.date-format", (MessageSource)messageSource), Formatters.getFormattedDate((LocalizedContent)s, (ZonedDateTime)s.getValidityTo(), (String)"common.event.date-format", (MessageSource)messageSource), Integer.valueOf(available));
        }).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value={"subscription/{id}"})
    public ResponseEntity<ValidatedResponse<String>> reserveSubscription(@PathVariable String id, Locale locale, Principal principal) {
        MapBindingResult bindingResult = new MapBindingResult(new HashMap(), "request");
        return this.subscriptionManager.getSubscriptionById(UUID.fromString(id)).map(subscriptionDescriptor -> {
            Optional reservationOptional = ReservationUtil.handleReservationCreationErrors(() -> this.reservationManager.createSubscriptionReservation(subscriptionDescriptor, locale, principal), (BindingResult)bindingResult, (PurchaseContext.PurchaseContextType)subscriptionDescriptor.getType());
            if (bindingResult.hasErrors()) {
                return new ResponseEntity((Object)ValidatedResponse.toResponse((BindingResult)bindingResult, null), (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
            }
            return reservationOptional.map(reservationId -> ResponseEntity.ok((Object)new ValidatedResponse(ValidationResult.success(), reservationId))).orElseGet(() -> ResponseEntity.unprocessableEntity().build());
        }).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @ConstructorProperties(value={"subscriptionManager", "i18nManager", "reservationManager", "configurationManager", "organizationRepository", "messageSourceManager", "clockProvider"})
    @Generated
    public SubscriptionsApiController(SubscriptionManager subscriptionManager, I18nManager i18nManager, TicketReservationManager reservationManager, ConfigurationManager configurationManager, OrganizationRepository organizationRepository, MessageSourceManager messageSourceManager, ClockProvider clockProvider) {
        this.subscriptionManager = subscriptionManager;
        this.i18nManager = i18nManager;
        this.reservationManager = reservationManager;
        this.configurationManager = configurationManager;
        this.organizationRepository = organizationRepository;
        this.messageSourceManager = messageSourceManager;
        this.clockProvider = clockProvider;
    }
}

