/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.user;

import alfio.controller.api.support.BookingInfoTicketLoader;
import alfio.controller.api.support.TicketHelper;
import alfio.controller.api.v2.model.DatesWithTimeZoneOffset;
import alfio.controller.api.v2.model.OnlineCheckInInfo;
import alfio.controller.api.v2.model.ReservationInfo;
import alfio.controller.api.v2.model.TicketInfo;
import alfio.controller.form.UpdateTicketOwnerForm;
import alfio.controller.support.FormattedEventDates;
import alfio.controller.support.Formatters;
import alfio.controller.support.TemplateProcessor;
import alfio.manager.ExtensionManager;
import alfio.manager.FileUploadManager;
import alfio.manager.NotificationManager;
import alfio.manager.SubscriptionManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.support.AdditionalServiceHelper;
import alfio.manager.support.response.ValidatedResponse;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Configurable;
import alfio.model.Event;
import alfio.model.LocalizedContent;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.TicketWithMetadataAttributes;
import alfio.model.checkin.EventWithCheckInInfo;
import alfio.model.metadata.JoinLink;
import alfio.model.metadata.OnlineConfiguration;
import alfio.model.metadata.TicketMetadataContainer;
import alfio.model.result.ValidationResult;
import alfio.model.transaction.PaymentProxy;
import alfio.model.user.Organization;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.util.EventUtil;
import alfio.util.ExportUtils;
import alfio.util.ImageUtil;
import alfio.util.LocaleUtil;
import alfio.util.TemplateManager;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TicketApiV2Controller {
    private final TicketHelper ticketHelper;
    private final TicketReservationManager ticketReservationManager;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final MessageSourceManager messageSourceManager;
    private final ExtensionManager extensionManager;
    private final FileUploadManager fileUploadManager;
    private final OrganizationRepository organizationRepository;
    private final TemplateManager templateManager;
    private final NotificationManager notificationManager;
    private final BookingInfoTicketLoader bookingInfoTicketLoader;
    private final TicketRepository ticketRepository;
    private final SubscriptionManager subscriptionManager;
    private final ConfigurationManager configurationManager;
    private final AdditionalServiceHelper additionalServiceHelper;

    @GetMapping(value={"/api/v2/public/event/{eventName}/ticket/{ticketIdentifier}/code.png", "/event/{eventName}/ticket/{ticketIdentifier}/code.png"})
    public void showQrCode(@PathVariable String eventName, @PathVariable UUID ticketIdentifier, HttpServletResponse response) throws IOException {
        Optional oData = this.ticketReservationManager.fetchCompleteAndAssigned(eventName, ticketIdentifier);
        if (oData.isEmpty()) {
            response.sendError(403);
            return;
        }
        Event event = (Event)((Triple)oData.get()).getLeft();
        Ticket ticket = (Ticket)((Triple)oData.get()).getRight();
        String qrCodeText = ticket.ticketCode(event.getPrivateKey(), event.supportsQRCodeCaseInsensitive());
        response.setContentType("image/png");
        ExportUtils.markAsNoIndex((HttpServletResponse)response);
        try (ServletOutputStream os = response.getOutputStream();){
            os.write(ImageUtil.createQRCode((String)qrCodeText));
            response.flushBuffer();
        }
    }

    @GetMapping(value={"/api/v2/public/event/{eventName}/ticket/{ticketIdentifier}/download-ticket"})
    public void generateTicketPdf(@PathVariable String eventName, @PathVariable UUID ticketIdentifier, HttpServletResponse response) {
        this.ticketReservationManager.fetchCompleteAndAssigned(eventName, ticketIdentifier).ifPresentOrElse(data -> {
            Ticket ticket = (Ticket)data.getRight();
            Event event = (Event)data.getLeft();
            TicketReservation ticketReservation = (TicketReservation)data.getMiddle();
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", "attachment; filename=ticket-" + ticketIdentifier + ".pdf");
            ExportUtils.markAsNoIndex((HttpServletResponse)response);
            try (ServletOutputStream os = response.getOutputStream();){
                TicketCategory ticketCategory = this.ticketCategoryRepository.getByIdAndActive(ticket.getCategoryId().intValue(), event.getId());
                Organization organization = this.organizationRepository.getById(event.getOrganizationId());
                String reservationID = this.configurationManager.getShortReservationID((Configurable)event, ticketReservation);
                TicketWithMetadataAttributes ticketWithMetadata = TicketWithMetadataAttributes.build((Ticket)ticket, (TicketMetadataContainer)this.ticketRepository.getTicketMetadata(ticket.getId()));
                Locale locale = LocaleUtil.getTicketLanguage((Ticket)ticket, (Locale)LocaleUtil.forLanguageTag((String)ticketReservation.getUserLanguage(), (LocalizedContent)event));
                TemplateProcessor.renderPDFTicket((Locale)locale, (Event)event, (TicketReservation)ticketReservation, (TicketWithMetadataAttributes)ticketWithMetadata, (TicketCategory)ticketCategory, (Organization)organization, (TemplateManager)this.templateManager, (FileUploadManager)this.fileUploadManager, (String)reservationID, (OutputStream)os, (BiFunction)this.ticketHelper.buildRetrieveFieldValuesFunction(true), (ExtensionManager)this.extensionManager, (Map)TemplateProcessor.getSubscriptionDetailsModelForTicket((Ticket)ticket, arg_0 -> ((SubscriptionManager)this.subscriptionManager).findDescriptorBySubscriptionId(arg_0), (Locale)locale), (List)this.additionalServiceHelper.findForTicket(ticket, event));
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }, () -> {
            try {
                response.sendError(403);
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        });
    }

    @PostMapping(value={"/api/v2/public/event/{eventName}/ticket/{ticketIdentifier}/send-ticket-by-email"})
    public ResponseEntity<Boolean> sendTicketByEmail(@PathVariable String eventName, @PathVariable UUID ticketIdentifier) {
        return this.ticketReservationManager.fetchCompleteAndAssigned(eventName, ticketIdentifier).map(data -> {
            Event event = (Event)data.getLeft();
            TicketReservation reservation = (TicketReservation)data.getMiddle();
            Ticket ticket = (Ticket)data.getRight();
            Locale locale = LocaleUtil.getTicketLanguage((Ticket)ticket, (Locale)LocaleUtil.forLanguageTag((String)reservation.getUserLanguage(), (LocalizedContent)event));
            this.notificationManager.sendTicketByEmail(ticket, event, locale, this.ticketHelper.getConfirmationTextBuilder(locale, event, reservation, ticket), reservation, this.ticketCategoryRepository.getByIdAndActive(ticket.getCategoryId().intValue(), event.getId()), () -> this.ticketReservationManager.retrieveAttendeeAdditionalInfoForTicket(ticket));
            return ResponseEntity.ok((Object)true);
        }).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/api/v2/public/event/{eventName}/ticket/{ticketIdentifier}"})
    public ResponseEntity<Boolean> releaseTicket(@PathVariable String eventName, @PathVariable UUID ticketIdentifier) {
        Optional oData = this.ticketReservationManager.fetchCompleteAndAssigned(eventName, ticketIdentifier);
        try {
            oData.ifPresent(triple -> this.ticketReservationManager.releaseTicket((Event)triple.getLeft(), (TicketReservation)triple.getMiddle(), (Ticket)triple.getRight()));
            return ResponseEntity.ok((Object)true);
        }
        catch (IllegalStateException ise) {
            return ResponseEntity.badRequest().body((Object)false);
        }
    }

    @GetMapping(value={"/api/v2/public/event/{eventName}/ticket/{ticketIdentifier}/full"})
    public ResponseEntity<ReservationInfo.TicketsByTicketCategory> getTicket(@PathVariable String eventName, @PathVariable UUID ticketIdentifier) {
        Optional<ReservationInfo.TicketsByTicketCategory> optionalTicket = this.ticketReservationManager.fetchCompleteAndAssigned(eventName, ticketIdentifier).map(complete -> {
            Ticket ticket = (Ticket)complete.getRight();
            Event event = (Event)complete.getLeft();
            TicketCategory category = this.ticketCategoryRepository.getByIdAndActive(ticket.getCategoryId().intValue(), event.getId());
            return new ReservationInfo.TicketsByTicketCategory(category.getName(), category.getTicketAccessType(), List.of(this.bookingInfoTicketLoader.toBookingInfoTicket(ticket, event, PurchaseContextFieldConfiguration.EVENT_RELATED_CONTEXTS)));
        });
        return ResponseEntity.of(optionalTicket);
    }

    @GetMapping(value={"/api/v2/public/event/{eventName}/ticket/{ticketIdentifier}"})
    public ResponseEntity<TicketInfo> getTicketInfo(@PathVariable String eventName, @PathVariable UUID ticketIdentifier) {
        Optional oData = this.ticketReservationManager.fetchCompleteAndAssigned(eventName, ticketIdentifier);
        if (oData.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        Triple data = (Triple)oData.get();
        TicketReservation ticketReservation = (TicketReservation)data.getMiddle();
        Ticket ticket = (Ticket)data.getRight();
        Event event = (Event)data.getLeft();
        TicketCategory ticketCategory = this.ticketCategoryRepository.getByIdAndActive(ticket.getCategoryId().intValue(), event.getId());
        boolean deskPaymentRequired = Optional.ofNullable(ticketReservation.getPaymentMethod()).orElse(PaymentProxy.STRIPE).isDeskPaymentRequired();
        ZonedDateTime validityStart = Optional.ofNullable(ticketCategory.getTicketValidityStart(event.getZoneId())).orElse(event.getBegin());
        ZonedDateTime validityEnd = Optional.ofNullable(ticketCategory.getTicketValidityEnd(event.getZoneId())).orElse(event.getEnd());
        boolean sameDay = validityStart.truncatedTo(ChronoUnit.DAYS).equals(validityEnd.truncatedTo(ChronoUnit.DAYS));
        MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event);
        FormattedEventDates formattedDates = Formatters.getFormattedDates((Event)event, (MessageSource)messageSource, (List)event.getContentLanguages());
        return ResponseEntity.ok((Object)new TicketInfo(ticket.getFullName(), ticket.getEmail(), ticket.getPublicUuid().toString(), ticketCategory.getName(), ticketReservation.getFullName(), this.configurationManager.getShortReservationID((Configurable)event, ticketReservation), deskPaymentRequired, event.getTimeZone(), DatesWithTimeZoneOffset.fromEvent((Event)event), sameDay, formattedDates.beginDate, formattedDates.beginTime, formattedDates.endDate, formattedDates.endTime, this.additionalServiceHelper.findForTicket(ticket, event)));
    }

    @PutMapping(value={"/api/v2/public/event/{eventName}/ticket/{ticketIdentifier}"})
    public ResponseEntity<ValidatedResponse<Boolean>> updateTicketInfo(@PathVariable String eventName, @PathVariable UUID ticketIdentifier, @RequestBody UpdateTicketOwnerForm updateTicketOwner, BindingResult bindingResult, Authentication authentication) {
        Optional a = this.ticketReservationManager.fetchComplete(eventName, ticketIdentifier);
        if (a.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        Optional<UserDetails> userDetails = Optional.ofNullable(authentication).map(Authentication::getPrincipal).filter(UserDetails.class::isInstance).map(UserDetails.class::cast);
        Locale locale = LocaleUtil.forLanguageTag((String)((TicketReservation)((Triple)a.get()).getMiddle()).getUserLanguage(), (LocalizedContent)((LocalizedContent)((Triple)a.get()).getLeft()));
        Optional assignmentResult = this.ticketHelper.assignTicket(eventName, ticketIdentifier, updateTicketOwner, Optional.of(bindingResult), locale, userDetails, false);
        return assignmentResult.map(r -> ResponseEntity.status((HttpStatusCode)(((ValidationResult)r.getLeft()).isSuccess() ? HttpStatus.OK : HttpStatus.UNPROCESSABLE_ENTITY)).body((Object)new ValidatedResponse((ValidationResult)r.getLeft(), (Object)((ValidationResult)r.getLeft()).isSuccess()))).orElseThrow(IllegalStateException::new);
    }

    @GetMapping(value={"/api/v2/public/event/{eventName}/ticket/{ticketIdentifier}/code/{checkInCode}/check-in-info"})
    public ResponseEntity<OnlineCheckInInfo> getCheckInInfo(@PathVariable String eventName, @PathVariable UUID ticketIdentifier, @PathVariable String checkInCode, @RequestParam(value="tz", required=false) String userTz) {
        return ResponseEntity.of(this.ticketReservationManager.fetchCompleteAndAssignedForOnlineCheckIn(eventName, ticketIdentifier).flatMap(info -> {
            Ticket ticket = info.getTicket();
            EventWithCheckInInfo event = info.getEventWithCheckInInfo();
            MessageSource messageSource = this.messageSourceManager.getMessageSourceFor(event.getOrganizationId(), event.getId());
            String ticketCode = ticket.ticketCode(event.getPrivateKey(), event.supportsQRCodeCaseInsensitive());
            if (MessageDigest.isEqual(DigestUtils.sha256Hex((String)ticketCode).getBytes(StandardCharsets.UTF_8), checkInCode.getBytes(StandardCharsets.UTF_8))) {
                OnlineConfiguration categoryConfiguration = info.getCategoryMetadata().getOnlineConfiguration();
                OnlineConfiguration eventConfiguration = event.getMetadata().getOnlineConfiguration();
                ZoneId zoneId = StringUtils.isNotBlank((CharSequence)userTz) ? ZoneId.of(userTz) : event.getZoneId();
                return EventUtil.firstMatchingCallLink((ZoneId)event.getZoneId(), (OnlineConfiguration)categoryConfiguration, (OnlineConfiguration)eventConfiguration).map(joinLink -> OnlineCheckInInfo.fromJoinLink((JoinLink)joinLink, (EventWithCheckInInfo)event, (ZoneId)zoneId, (MessageSource)messageSource)).or(() -> Optional.of(OnlineCheckInInfo.fromEvent((EventWithCheckInInfo)event, (ZoneId)zoneId, (MessageSource)messageSource)));
            }
            return Optional.empty();
        }));
    }

    @ConstructorProperties(value={"ticketHelper", "ticketReservationManager", "ticketCategoryRepository", "messageSourceManager", "extensionManager", "fileUploadManager", "organizationRepository", "templateManager", "notificationManager", "bookingInfoTicketLoader", "ticketRepository", "subscriptionManager", "configurationManager", "additionalServiceHelper"})
    @Generated
    public TicketApiV2Controller(TicketHelper ticketHelper, TicketReservationManager ticketReservationManager, TicketCategoryRepository ticketCategoryRepository, MessageSourceManager messageSourceManager, ExtensionManager extensionManager, FileUploadManager fileUploadManager, OrganizationRepository organizationRepository, TemplateManager templateManager, NotificationManager notificationManager, BookingInfoTicketLoader bookingInfoTicketLoader, TicketRepository ticketRepository, SubscriptionManager subscriptionManager, ConfigurationManager configurationManager, AdditionalServiceHelper additionalServiceHelper) {
        this.ticketHelper = ticketHelper;
        this.ticketReservationManager = ticketReservationManager;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.messageSourceManager = messageSourceManager;
        this.extensionManager = extensionManager;
        this.fileUploadManager = fileUploadManager;
        this.organizationRepository = organizationRepository;
        this.templateManager = templateManager;
        this.notificationManager = notificationManager;
        this.bookingInfoTicketLoader = bookingInfoTicketLoader;
        this.ticketRepository = ticketRepository;
        this.subscriptionManager = subscriptionManager;
        this.configurationManager = configurationManager;
        this.additionalServiceHelper = additionalServiceHelper;
    }
}

