/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.user;

import alfio.config.authentication.support.OpenIdPrincipal;
import alfio.controller.api.v2.model.ClientRedirect;
import alfio.controller.api.v2.model.PurchaseContextWithReservations;
import alfio.controller.form.UpdateProfileForm;
import alfio.controller.support.CustomBindingResult;
import alfio.manager.ExtensionManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.support.response.ValidatedResponse;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.user.PublicUserManager;
import alfio.model.ContentLanguage;
import alfio.model.user.PublicUserProfile;
import alfio.model.user.User;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/public/user"})
public class UserApiV2Controller {
    private final PublicUserManager publicUserManager;
    private final TicketReservationManager ticketReservationManager;
    private final ConfigurationManager configurationManager;
    private final ExtensionManager extensionManager;
    private final MessageSourceManager messageSourceManager;
    private final SecurityContextLogoutHandler logoutHandler = new SecurityContextLogoutHandler();

    @Autowired
    public UserApiV2Controller(PublicUserManager publicUserManager, TicketReservationManager ticketReservationManager, ConfigurationManager configurationManager, ExtensionManager extensionManager, MessageSourceManager messageSourceManager) {
        this.publicUserManager = publicUserManager;
        this.ticketReservationManager = ticketReservationManager;
        this.configurationManager = configurationManager;
        this.extensionManager = extensionManager;
        this.messageSourceManager = messageSourceManager;
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<alfio.controller.api.v2.model.User> getUserIdentity(Authentication principal) {
        if (principal != null) {
            return this.publicUserManager.findOptionalProfileForUser(principal).map(userWithOptionalProfile -> {
                User user = (User)userWithOptionalProfile.getLeft();
                return ResponseEntity.ok((Object)new alfio.controller.api.v2.model.User(user.getFirstName(), user.getLastName(), user.getEmailAddress(), user.getType(), (PublicUserProfile)((Optional)userWithOptionalProfile.getRight()).orElse(null)));
            }).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build());
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    @PostMapping(value={"/me"})
    public ResponseEntity<ValidatedResponse<alfio.controller.api.v2.model.User>> updateProfile(@RequestBody UpdateProfileForm update, BindingResult bindingResult, Principal principal) {
        if (principal != null) {
            boolean italianEInvoicingEnabled = this.configurationManager.isItalianEInvoicingEnabled(ConfigurationLevel.system());
            return this.publicUserManager.findOptionalEnabledUserByUsername(principal.getName()).map(u -> {
                CustomBindingResult customBindingResult = new CustomBindingResult(bindingResult);
                update.setEmail(u.getEmailAddress());
                update.formalValidation(customBindingResult, italianEInvoicingEnabled, italianEInvoicingEnabled);
                if (!customBindingResult.hasErrors()) {
                    this.extensionManager.handleUserProfileValidation((Object)update, bindingResult);
                }
                if (!customBindingResult.hasErrors()) {
                    Optional publicUserProfile = this.publicUserManager.updateProfile(u, update, italianEInvoicingEnabled);
                    if (publicUserProfile.isPresent()) {
                        PublicUserProfile profile = (PublicUserProfile)publicUserProfile.get();
                        alfio.controller.api.v2.model.User updatedUser = new alfio.controller.api.v2.model.User(update.getFirstName(), update.getLastName(), u.getEmailAddress(), u.getType(), profile);
                        return ResponseEntity.ok((Object)ValidatedResponse.toResponse((BindingResult)customBindingResult, (Object)updatedUser));
                    }
                    customBindingResult.reject("error.emptyField");
                }
                ValidatedResponse body = ValidatedResponse.toResponse((BindingResult)customBindingResult, null);
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)body);
            }).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build());
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
    }

    @DeleteMapping(value={"/me"})
    public ResponseEntity<ClientRedirect> deleteCurrentUser(HttpServletRequest request, HttpServletResponse response, OAuth2AuthenticationToken authentication) {
        if (this.publicUserManager.deleteUserProfile(authentication)) {
            return this.redirectToIdpLogout(request, response, (Authentication)authentication);
        }
        return ResponseEntity.badRequest().build();
    }

    @GetMapping(value={"/authentication-enabled"})
    public ResponseEntity<Boolean> userAuthenticationEnabled() {
        return ResponseEntity.ok((Object)this.configurationManager.isPublicOpenIdEnabled());
    }

    @PostMapping(value={"/logout"})
    public ResponseEntity<ClientRedirect> logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        return this.redirectToIdpLogout(request, response, authentication);
    }

    @GetMapping(value={"/reservations"})
    public ResponseEntity<List<PurchaseContextWithReservations>> getUserReservations(Principal principal) {
        if (principal != null) {
            List reservations = this.ticketReservationManager.loadReservationsForUser(principal);
            if (reservations.isEmpty()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
            }
            MessageSource messageSource = this.messageSourceManager.getRootMessageSource();
            Map<Locale, String> datePatternsMap = ContentLanguage.ALL_LANGUAGES.stream().map(l -> Map.entry(l.getLocale(), messageSource.getMessage("datetime.pattern", null, l.getLocale()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<PurchaseContextWithReservations> results = reservations.stream().collect(Collectors.groupingBy(p -> p.getPurchaseContextType().name() + "/" + p.getPurchaseContextPublicIdentifier())).values().stream().map(pc -> PurchaseContextWithReservations.from((List)pc, (Map)datePatternsMap)).toList();
            return ResponseEntity.ok(results);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    private ResponseEntity<ClientRedirect> redirectToIdpLogout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        OAuth2AuthenticationToken oauth;
        OAuth2User oAuth2User;
        this.logoutHandler.logout(request, response, authentication);
        String redirectUrl = "/";
        if (authentication instanceof OAuth2AuthenticationToken && (oAuth2User = (oauth = (OAuth2AuthenticationToken)authentication).getPrincipal()) instanceof OpenIdPrincipal) {
            OpenIdPrincipal principal = (OpenIdPrincipal)oAuth2User;
            redirectUrl = principal.idpLogoutRedirectionUrl();
        }
        return ResponseEntity.ok((Object)new ClientRedirect(redirectUrl));
    }
}

