/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.user.support;

import alfio.controller.api.v2.model.AnalyticsConfiguration;
import alfio.controller.api.v2.model.EmbeddingConfiguration;
import alfio.controller.api.v2.model.EventWithAdditionalInfo;
import alfio.controller.api.v2.model.InvoicingConfiguration;
import alfio.controller.api.v2.model.OfflinePaymentConfiguration;
import alfio.controller.api.v2.user.support.PurchaseContextInfoBuilder;
import alfio.controller.support.FormattedEventDates;
import alfio.controller.support.Formatters;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Event;
import alfio.model.PurchaseContext;
import alfio.model.modification.support.LocationDescriptor;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.EventDescriptionRepository;
import alfio.repository.EventRepository;
import alfio.repository.PromoCodeDiscountRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.user.OrganizationRepository;
import jakarta.servlet.http.HttpSession;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class EventLoader {
    private final EventRepository eventRepository;
    private final MessageSourceManager messageSourceManager;
    private final EventDescriptionRepository eventDescriptionRepository;
    private final OrganizationRepository organizationRepository;
    private final ConfigurationManager configurationManager;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final TicketRepository ticketRepository;
    private final PromoCodeDiscountRepository promoCodeRepository;
    private final SubscriptionRepository subscriptionRepository;

    public Optional<EventWithAdditionalInfo> loadEventInfo(String eventName, HttpSession session) {
        return this.eventRepository.findOptionalByShortName(eventName).filter(e -> e.getStatus() != Event.Status.DISABLED).map(event -> {
            Pair messageSourceAndOverride = this.messageSourceManager.getMessageSourceForPurchaseContextAndOverride((PurchaseContext)event);
            MessageSource messageSource = (MessageSource)messageSourceAndOverride.getLeft();
            Map i18nOverride = (Map)messageSourceAndOverride.getRight();
            Map descriptions = Formatters.applyCommonMark((Map)this.eventDescriptionRepository.findDescriptionByEventIdAsMap(event.getId()), (MessageSource)messageSource);
            Organization.OrganizationContact organization = this.organizationRepository.getContactById(event.getOrganizationId());
            Map configurationsValues = PurchaseContextInfoBuilder.configurationsValues((PurchaseContext)event, (ConfigurationManager)this.configurationManager);
            LocationDescriptor locationDescriptor = LocationDescriptor.fromGeoData((Event.EventFormat)event.getFormat(), (Pair)event.getLatLong(), (TimeZone)TimeZone.getTimeZone(event.getTimeZone()), (Map)configurationsValues);
            EventWithAdditionalInfo.CaptchaConfiguration captchaConf = PurchaseContextInfoBuilder.captchaConfiguration((ConfigurationManager)this.configurationManager, (Map)configurationsValues);
            String bankAccount = ((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.BANK_ACCOUNT_NR)).getValueOrDefault("");
            List<String> bankAccountOwner = Arrays.asList(((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.BANK_ACCOUNT_OWNER)).getValueOrDefault("").split("\n"));
            FormattedEventDates formattedDates = Formatters.getFormattedDates((Event)event, (MessageSource)messageSource, (List)event.getContentLanguages());
            InvoicingConfiguration invoicingConf = PurchaseContextInfoBuilder.invoicingInfo((ConfigurationManager)this.configurationManager, (Map)configurationsValues);
            boolean forceAssignment = ((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.FORCE_TICKET_OWNER_ASSIGNMENT_AT_RESERVATION)).getValueAsBooleanOrDefault();
            boolean enableAttendeeAutocomplete = ((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.ENABLE_ATTENDEE_AUTOCOMPLETE)).getValueAsBooleanOrDefault();
            boolean enableTicketTransfer = ((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.ENABLE_TICKET_TRANSFER)).getValueAsBooleanOrDefault();
            EventWithAdditionalInfo.AssignmentConfiguration assignmentConf = new EventWithAdditionalInfo.AssignmentConfiguration(forceAssignment, enableAttendeeAutocomplete, enableTicketTransfer);
            boolean hasAccessPromotions = ((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.DISPLAY_DISCOUNT_CODE_BOX)).getValueAsBooleanOrDefault() && (this.ticketCategoryRepository.countAccessRestrictedRepositoryByEventId(event.getId()) > 0 || this.promoCodeRepository.countByEventAndOrganizationId(event.getId(), event.getOrganizationId()) > 0);
            boolean usePartnerCode = ((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.USE_PARTNER_CODE_INSTEAD_OF_PROMOTIONAL)).getValueAsBooleanOrDefault();
            EventWithAdditionalInfo.PromotionsConfiguration promoConf = new EventWithAdditionalInfo.PromotionsConfiguration(hasAccessPromotions, usePartnerCode);
            AnalyticsConfiguration analyticsConf = AnalyticsConfiguration.build((Map)configurationsValues, (HttpSession)session);
            Integer availableTicketsCount = null;
            if (((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.DISPLAY_TICKETS_LEFT_INDICATOR)).getValueAsBooleanOrDefault()) {
                availableTicketsCount = this.ticketRepository.countFreeTicketsForPublicStatistics(event.getId());
            }
            String customCss = ((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.EVENT_CUSTOM_CSS)).getValueOrNull();
            boolean hasLinkedSubscription = this.subscriptionRepository.hasLinkedSubscription(event.getId());
            OfflinePaymentConfiguration offlinePaymentConfiguration = new OfflinePaymentConfiguration(((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.SHOW_ONLY_BASIC_INSTRUCTIONS)).getValueAsBooleanOrDefault());
            return new EventWithAdditionalInfo(event, locationDescriptor.getMapUrl(), organization, descriptions, bankAccount, bankAccountOwner, formattedDates.beginDate, formattedDates.beginTime, formattedDates.endDate, formattedDates.endTime, invoicingConf, captchaConf, assignmentConf, promoConf, analyticsConf, offlinePaymentConfiguration, new EmbeddingConfiguration(((ConfigurationManager.MaybeConfiguration)configurationsValues.get(ConfigurationKeys.EMBED_POST_MESSAGE_ORIGIN)).getValueOrNull()), MessageSourceManager.convertPlaceholdersForEachLanguage((Map)i18nOverride), availableTicketsCount, customCss, hasLinkedSubscription);
        });
    }

    public boolean isRecaptchaForTicketSelectionEnabled(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configurationValues) {
        return PurchaseContextInfoBuilder.isRecaptchaForTicketSelectionEnabled(configurationValues);
    }

    @ConstructorProperties(value={"eventRepository", "messageSourceManager", "eventDescriptionRepository", "organizationRepository", "configurationManager", "ticketCategoryRepository", "ticketRepository", "promoCodeRepository", "subscriptionRepository"})
    @Generated
    public EventLoader(EventRepository eventRepository, MessageSourceManager messageSourceManager, EventDescriptionRepository eventDescriptionRepository, OrganizationRepository organizationRepository, ConfigurationManager configurationManager, TicketCategoryRepository ticketCategoryRepository, TicketRepository ticketRepository, PromoCodeDiscountRepository promoCodeRepository, SubscriptionRepository subscriptionRepository) {
        this.eventRepository = eventRepository;
        this.messageSourceManager = messageSourceManager;
        this.eventDescriptionRepository = eventDescriptionRepository;
        this.organizationRepository = organizationRepository;
        this.configurationManager = configurationManager;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.ticketRepository = ticketRepository;
        this.promoCodeRepository = promoCodeRepository;
        this.subscriptionRepository = subscriptionRepository;
    }
}

