/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.v2.user.support;

import alfio.controller.api.v2.model.EventWithAdditionalInfo;
import alfio.controller.api.v2.model.InvoicingConfiguration;
import alfio.manager.EuVatChecker;
import alfio.manager.system.ConfigurationManager;
import alfio.model.PurchaseContext;
import alfio.model.system.ConfigurationKeys;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

/*
 * Exception performing whole class analysis ignored.
 */
public class PurchaseContextInfoBuilder {
    private PurchaseContextInfoBuilder() {
    }

    public static Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configurationsValues(PurchaseContext purchaseContext, ConfigurationManager configurationManager) {
        return configurationManager.getFor(List.of(ConfigurationKeys.MAPS_PROVIDER, ConfigurationKeys.MAPS_CLIENT_API_KEY, ConfigurationKeys.MAPS_HERE_API_KEY, ConfigurationKeys.RECAPTCHA_API_KEY, ConfigurationKeys.BANK_ACCOUNT_NR, ConfigurationKeys.BANK_ACCOUNT_OWNER, ConfigurationKeys.ENABLE_CUSTOMER_REFERENCE, ConfigurationKeys.ENABLE_ITALY_E_INVOICING, ConfigurationKeys.VAT_NUMBER_IS_REQUIRED, ConfigurationKeys.FORCE_TICKET_OWNER_ASSIGNMENT_AT_RESERVATION, ConfigurationKeys.ENABLE_ATTENDEE_AUTOCOMPLETE, ConfigurationKeys.ENABLE_TICKET_TRANSFER, ConfigurationKeys.DISPLAY_DISCOUNT_CODE_BOX, ConfigurationKeys.USE_PARTNER_CODE_INSTEAD_OF_PROMOTIONAL, ConfigurationKeys.GOOGLE_ANALYTICS_KEY, ConfigurationKeys.GOOGLE_ANALYTICS_ANONYMOUS_MODE, ConfigurationKeys.ENABLE_CAPTCHA_FOR_TICKET_SELECTION, ConfigurationKeys.RECAPTCHA_API_KEY, ConfigurationKeys.ENABLE_CAPTCHA_FOR_OFFLINE_PAYMENTS, ConfigurationKeys.GENERATE_ONLY_INVOICE, ConfigurationKeys.INVOICE_ADDRESS, ConfigurationKeys.VAT_NR, ConfigurationKeys.SHOW_ONLY_BASIC_INSTRUCTIONS, ConfigurationKeys.ENABLE_EU_VAT_DIRECTIVE, ConfigurationKeys.COUNTRY_OF_BUSINESS, ConfigurationKeys.ENABLE_REVERSE_CHARGE_IN_PERSON, ConfigurationKeys.ENABLE_REVERSE_CHARGE_ONLINE, ConfigurationKeys.DISPLAY_TICKETS_LEFT_INDICATOR, ConfigurationKeys.EVENT_CUSTOM_CSS, ConfigurationKeys.EMBED_POST_MESSAGE_ORIGIN), purchaseContext.getConfigurationLevel());
    }

    public static InvoicingConfiguration invoicingInfo(ConfigurationManager configurationManager, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configurationsValues) {
        boolean canGenerateReceiptOrInvoiceToCustomer = configurationManager.canGenerateReceiptOrInvoiceToCustomer(configurationsValues);
        boolean euVatCheckingEnabled = EuVatChecker.reverseChargeEnabled(configurationsValues);
        boolean invoiceAllowed = configurationManager.hasAllConfigurationsForInvoice(configurationsValues);
        boolean onlyInvoice = invoiceAllowed && configurationManager.isInvoiceOnly(configurationsValues);
        boolean customerReferenceEnabled = configurationsValues.get(ConfigurationKeys.ENABLE_CUSTOMER_REFERENCE).getValueAsBooleanOrDefault();
        boolean enabledItalyEInvoicing = configurationsValues.get(ConfigurationKeys.ENABLE_ITALY_E_INVOICING).getValueAsBooleanOrDefault();
        boolean vatNumberStrictlyRequired = configurationsValues.get(ConfigurationKeys.VAT_NUMBER_IS_REQUIRED).getValueAsBooleanOrDefault();
        return new InvoicingConfiguration(canGenerateReceiptOrInvoiceToCustomer, euVatCheckingEnabled, invoiceAllowed, onlyInvoice, customerReferenceEnabled, enabledItalyEInvoicing, vatNumberStrictlyRequired);
    }

    public static EventWithAdditionalInfo.CaptchaConfiguration captchaConfiguration(ConfigurationManager configurationManager, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configurationsValues) {
        boolean captchaForTicketSelection = PurchaseContextInfoBuilder.isRecaptchaForTicketSelectionEnabled(configurationsValues);
        String recaptchaApiKey = null;
        if (captchaForTicketSelection) {
            recaptchaApiKey = configurationsValues.get(ConfigurationKeys.RECAPTCHA_API_KEY).getValueOrNull();
        }
        boolean captchaForOfflinePaymentAndFreeEnabled = configurationManager.isRecaptchaForOfflinePaymentAndFreeEnabled(configurationsValues);
        return new EventWithAdditionalInfo.CaptchaConfiguration(captchaForTicketSelection, captchaForOfflinePaymentAndFreeEnabled, recaptchaApiKey);
    }

    public static boolean isRecaptchaForTicketSelectionEnabled(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> configurationValues) {
        Validate.isTrue((configurationValues.containsKey(ConfigurationKeys.ENABLE_CAPTCHA_FOR_TICKET_SELECTION) && configurationValues.containsKey(ConfigurationKeys.RECAPTCHA_API_KEY) ? 1 : 0) != 0);
        return configurationValues.get(ConfigurationKeys.ENABLE_CAPTCHA_FOR_TICKET_SELECTION).getValueAsBooleanOrDefault() && configurationValues.get(ConfigurationKeys.RECAPTCHA_API_KEY).getValueOrNull() != null;
    }
}

