/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.api.wallet;

import alfio.manager.wallet.GoogleWalletManager;
import alfio.model.EventAndOrganizationId;
import alfio.model.Ticket;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/wallet/event/{eventName}/v1"})
public class GoogleWalletApiController {
    private final GoogleWalletManager walletManager;

    @GetMapping(value={"/version/passes/{uuid}"})
    public void walletPass(@PathVariable String eventName, @PathVariable(value="uuid") String serialNumber, HttpServletResponse response) throws IOException {
        Optional validationResult = this.walletManager.validateTicket(eventName, serialNumber);
        if (validationResult.isEmpty()) {
            response.sendError(404);
        } else {
            String walletUrl = this.walletManager.createAddToWalletUrl((Ticket)((Pair)validationResult.get()).getRight(), (EventAndOrganizationId)((Pair)validationResult.get()).getLeft());
            response.sendRedirect(walletUrl);
        }
    }

    @ConstructorProperties(value={"walletManager"})
    @Generated
    public GoogleWalletApiController(GoogleWalletManager walletManager) {
        this.walletManager = walletManager;
    }
}

