/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.decorator;

import alfio.controller.decorator.SaleableAdditionalService;
import alfio.controller.decorator.SaleableTicketCategory;
import alfio.model.AdditionalService;
import alfio.model.Event;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.util.ClockProvider;
import alfio.util.MonetaryUtil;
import java.math.BigDecimal;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import lombok.Generated;

public class SaleableAdditionalService
implements PriceContainer {
    private final Event event;
    private final AdditionalService additionalService;
    private final PromoCodeDiscount promoCodeDiscount;
    private final Clock clock;

    public SaleableAdditionalService(Event event, AdditionalService additionalService, PromoCodeDiscount promoCodeDiscount) {
        this.event = event;
        this.additionalService = additionalService;
        this.promoCodeDiscount = promoCodeDiscount;
        this.clock = ClockProvider.clock().withZone(event.getZoneId());
    }

    public boolean isExpired() {
        return this.utcExpiration().isBefore(ZonedDateTime.now(this.clock));
    }

    public boolean getExpired() {
        return this.isExpired();
    }

    public boolean getSaleInFuture() {
        return this.utcInception().isAfter(ZonedDateTime.now(this.clock));
    }

    public boolean getFree() {
        return this.fixPrice() && this.getFinalPrice().compareTo(BigDecimal.ZERO) == 0;
    }

    public ZonedDateTime getZonedInception() {
        return this.getInception(this.event.getZoneId());
    }

    public ZonedDateTime getZonedExpiration() {
        return this.getExpiration(this.event.getZoneId());
    }

    public int getSrcPriceCts() {
        return Optional.ofNullable(this.additionalService.srcPriceCts()).orElse(0);
    }

    public Optional<PromoCodeDiscount> getDiscount() {
        return Optional.ofNullable(this.promoCodeDiscount).filter(x -> x.getCodeType() == PromoCodeDiscount.CodeType.DISCOUNT && this.type() != AdditionalService.AdditionalServiceType.DONATION);
    }

    public String getCurrencyCode() {
        return this.event.getCurrency();
    }

    public Optional<BigDecimal> getOptionalVatPercentage() {
        if (this.getVatStatus() != PriceContainer.VatStatus.NONE) {
            return Optional.ofNullable(this.event.getVat());
        }
        return Optional.of(BigDecimal.ZERO);
    }

    public PriceContainer.VatStatus getVatStatus() {
        return AdditionalService.getVatStatus((AdditionalService.VatType)this.vatType(), (PriceContainer.VatStatus)this.event.getVatStatus());
    }

    public String getFormattedFinalPrice() {
        if (AdditionalService.SupplementPolicy.isMandatoryPercentage((AdditionalService.SupplementPolicy)this.supplementPolicy())) {
            return MonetaryUtil.formatPercentage((int)this.srcPriceCts());
        }
        return SaleableTicketCategory.getFinalPriceToDisplay((BigDecimal)this.getFinalPrice().add(this.getAppliedDiscount()), (BigDecimal)this.getVAT(), (PriceContainer.VatStatus)this.getVatStatus()).toPlainString();
    }

    public boolean getSupportsDiscount() {
        return this.type() != AdditionalService.AdditionalServiceType.DONATION && this.fixPrice() && this.promoCodeDiscount != null && this.promoCodeDiscount.getCodeType() == PromoCodeDiscount.CodeType.DISCOUNT;
    }

    public String getDiscountedPrice() {
        return this.getFinalPrice().toPlainString();
    }

    public boolean getVatIncluded() {
        return switch (1.$SwitchMap$alfio$model$AdditionalService$VatType[this.vatType().ordinal()]) {
            case 1 -> this.event.isVatIncluded();
            case 2 -> true;
            default -> false;
        };
    }

    public BigDecimal getVatPercentage() {
        AdditionalService.VatType vatType = this.vatType();
        if (vatType == AdditionalService.VatType.INHERITED) {
            return this.event.getVat();
        }
        return Optional.ofNullable(this.additionalService.vat()).orElse(BigDecimal.ZERO);
    }

    public boolean getVatApplies() {
        return this.vatType() != AdditionalService.VatType.NONE;
    }

    public String getCurrency() {
        return this.event.getCurrency();
    }

    public boolean isSaleable() {
        return !this.isExpired() && this.additionalService.availableItems() > 0;
    }

    @Generated
    public ZonedDateTime getInception(ZoneId zoneId) {
        return this.additionalService.getInception(zoneId);
    }

    @Generated
    public ZonedDateTime getExpiration(ZoneId zoneId) {
        return this.additionalService.getExpiration(zoneId);
    }

    @Generated
    public boolean getSaleable() {
        return this.additionalService.getSaleable();
    }

    @Generated
    public BigDecimal getMinPrice() {
        return this.additionalService.getMinPrice();
    }

    @Generated
    public BigDecimal getMaxPrice() {
        return this.additionalService.getMaxPrice();
    }

    @Generated
    public String getChecksum() {
        return this.additionalService.getChecksum();
    }

    @Generated
    public int id() {
        return this.additionalService.id();
    }

    @Generated
    public int eventId() {
        return this.additionalService.eventId();
    }

    @Generated
    public boolean fixPrice() {
        return this.additionalService.fixPrice();
    }

    @Generated
    public int ordinal() {
        return this.additionalService.ordinal();
    }

    @Generated
    public int availableQuantity() {
        return this.additionalService.availableQuantity();
    }

    @Generated
    public int maxQtyPerOrder() {
        return this.additionalService.maxQtyPerOrder();
    }

    @Generated
    public ZonedDateTime utcInception() {
        return this.additionalService.utcInception();
    }

    @Generated
    public ZonedDateTime utcExpiration() {
        return this.additionalService.utcExpiration();
    }

    @Generated
    public BigDecimal vat() {
        return this.additionalService.vat();
    }

    @Generated
    public AdditionalService.VatType vatType() {
        return this.additionalService.vatType();
    }

    @Generated
    public Integer srcPriceCts() {
        return this.additionalService.srcPriceCts();
    }

    @Generated
    public AdditionalService.AdditionalServiceType type() {
        return this.additionalService.type();
    }

    @Generated
    public AdditionalService.SupplementPolicy supplementPolicy() {
        return this.additionalService.supplementPolicy();
    }

    @Generated
    public String currencyCode() {
        return this.additionalService.currencyCode();
    }

    @Generated
    public Integer availableItems() {
        return this.additionalService.availableItems();
    }

    @Generated
    public Integer minPriceCts() {
        return this.additionalService.minPriceCts();
    }

    @Generated
    public Integer maxPriceCts() {
        return this.additionalService.maxPriceCts();
    }
}

