/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.decorator;

import alfio.model.CategoryAvailability;
import alfio.model.Event;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.TicketCategory;
import alfio.util.MonetaryUtil;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SaleableTicketCategory
implements PriceContainer {
    private final TicketCategory ticketCategory;
    private final ZonedDateTime now;
    private final ZoneId zoneId;
    private final Event event;
    private final boolean soldOut;
    private final boolean inSale;
    private final int availableTickets;
    private final int maxTickets;
    private final boolean hasPendingTickets;
    private final PromoCodeDiscount promoCodeDiscount;

    public SaleableTicketCategory(TicketCategory ticketCategory, ZonedDateTime now, Event event, CategoryAvailability categoryAvailability, int maxTickets, PromoCodeDiscount promoCodeDiscount) {
        this.ticketCategory = ticketCategory;
        this.now = now;
        this.zoneId = event.getZoneId();
        this.event = event;
        this.inSale = SaleableTicketCategory.isCurrentlyInSale((ZonedDateTime)now, (TicketCategory)ticketCategory, (ZoneId)event.getZoneId());
        this.soldOut = this.inSale && categoryAvailability.availableTickets() == 0;
        this.availableTickets = categoryAvailability.availableTickets();
        this.maxTickets = maxTickets;
        this.hasPendingTickets = categoryAvailability.hasPendingTickets();
        this.promoCodeDiscount = promoCodeDiscount;
    }

    private static boolean isCurrentlyInSale(ZonedDateTime now, TicketCategory tc, ZoneId zoneId) {
        return tc.getInception(zoneId).isBefore(now) && tc.getExpiration(zoneId).isAfter(now);
    }

    public boolean getSaleable() {
        return this.inSale && !this.soldOut;
    }

    public boolean getSaleableAndLimitNotReached() {
        return this.getSaleable() && (this.promoCodeDiscount == null || this.maxTickets > 0);
    }

    public boolean getExpired() {
        return this.getExpiration(this.zoneId).isBefore(this.now);
    }

    public boolean getSaleInFuture() {
        return this.getInception(this.zoneId).isAfter(this.now);
    }

    public boolean getAccessRestricted() {
        return this.isAccessRestricted();
    }

    public boolean getSouldOutOrLimitReached() {
        return this.soldOut || this.promoCodeDiscount != null && this.maxTickets == 0;
    }

    public ZonedDateTime getZonedExpiration() {
        return this.getExpiration(this.zoneId);
    }

    public ZonedDateTime getZonedInception() {
        return this.getInception(this.zoneId);
    }

    public Optional<PromoCodeDiscount> getDiscount() {
        return Optional.ofNullable(this.promoCodeDiscount);
    }

    public Optional<BigDecimal> getOptionalVatPercentage() {
        return Optional.ofNullable(this.event.getVat());
    }

    public PriceContainer.VatStatus getVatStatus() {
        return this.event.getVatStatus();
    }

    public String getFormattedFinalPrice() {
        if (StringUtils.isNotEmpty((CharSequence)this.getCurrencyCode())) {
            return MonetaryUtil.formatUnit((BigDecimal)SaleableTicketCategory.getFinalPriceToDisplay((BigDecimal)this.getFinalPrice().add(this.getAppliedDiscount()), (BigDecimal)this.getVAT(), (PriceContainer.VatStatus)this.getVatStatus()), (String)this.getCurrencyCode());
        }
        return "";
    }

    public int getMaxTicketsAfterConfiguration() {
        return this.maxTickets;
    }

    public int getAvailableTickets() {
        return this.availableTickets;
    }

    public boolean hasPendingTickets() {
        return this.hasPendingTickets;
    }

    public String getDiscountedPrice() {
        return MonetaryUtil.formatUnit((BigDecimal)SaleableTicketCategory.getFinalPriceToDisplay((BigDecimal)this.getFinalPrice(), (BigDecimal)this.getVAT(), (PriceContainer.VatStatus)this.getVatStatus()), (String)this.getCurrencyCode());
    }

    public boolean getSupportsDiscount() {
        return this.getPromoCodeDiscount() != null && this.getSaleable();
    }

    public PromoCodeDiscount getPromoCodeDiscount() {
        return this.promoCodeDiscount == null || this.promoCodeDiscount.getCodeType() == PromoCodeDiscount.CodeType.DISCOUNT ? this.promoCodeDiscount : null;
    }

    static BigDecimal getFinalPriceToDisplay(BigDecimal price, BigDecimal vat, PriceContainer.VatStatus vatStatus) {
        if (vatStatus == PriceContainer.VatStatus.NOT_INCLUDED) {
            return price.subtract(vat);
        }
        return price;
    }

    @Generated
    public BigDecimal getPrice() {
        return this.ticketCategory.getPrice();
    }

    @Generated
    public boolean getFree() {
        return this.ticketCategory.getFree();
    }

    @Generated
    public ZonedDateTime getInception(ZoneId zoneId) {
        return this.ticketCategory.getInception(zoneId);
    }

    @Generated
    public ZonedDateTime getExpiration(ZoneId zoneId) {
        return this.ticketCategory.getExpiration(zoneId);
    }

    @Generated
    public ZonedDateTime getValidCheckInFrom(ZoneId zoneId) {
        return this.ticketCategory.getValidCheckInFrom(zoneId);
    }

    @Generated
    public ZonedDateTime getValidCheckInTo(ZoneId zoneId) {
        return this.ticketCategory.getValidCheckInTo(zoneId);
    }

    @Generated
    public ZonedDateTime getTicketValidityStart(ZoneId zoneId) {
        return this.ticketCategory.getTicketValidityStart(zoneId);
    }

    @Generated
    public ZonedDateTime getTicketValidityEnd(ZoneId zoneId) {
        return this.ticketCategory.getTicketValidityEnd(zoneId);
    }

    @Generated
    public boolean hasValidCheckIn(ZonedDateTime now, ZoneId eventZoneId) {
        return this.ticketCategory.hasValidCheckIn(now, eventZoneId);
    }

    @Generated
    public int getId() {
        return this.ticketCategory.getId();
    }

    @Generated
    public ZonedDateTime getUtcInception() {
        return this.ticketCategory.getUtcInception();
    }

    @Generated
    public ZonedDateTime getUtcExpiration() {
        return this.ticketCategory.getUtcExpiration();
    }

    @Generated
    public int getMaxTickets() {
        return this.ticketCategory.getMaxTickets();
    }

    @Generated
    public String getName() {
        return this.ticketCategory.getName();
    }

    @Generated
    public boolean isAccessRestricted() {
        return this.ticketCategory.isAccessRestricted();
    }

    @Generated
    public TicketCategory.Status getStatus() {
        return this.ticketCategory.getStatus();
    }

    @Generated
    public int getEventId() {
        return this.ticketCategory.getEventId();
    }

    @Generated
    public boolean isBounded() {
        return this.ticketCategory.isBounded();
    }

    @Generated
    public int getSrcPriceCts() {
        return this.ticketCategory.getSrcPriceCts();
    }

    @Generated
    public String getCode() {
        return this.ticketCategory.getCode();
    }

    @Generated
    public ZonedDateTime getValidCheckInFrom() {
        return this.ticketCategory.getValidCheckInFrom();
    }

    @Generated
    public ZonedDateTime getValidCheckInTo() {
        return this.ticketCategory.getValidCheckInTo();
    }

    @Generated
    public ZonedDateTime getTicketValidityStart() {
        return this.ticketCategory.getTicketValidityStart();
    }

    @Generated
    public ZonedDateTime getTicketValidityEnd() {
        return this.ticketCategory.getTicketValidityEnd();
    }

    @Generated
    public String getCurrencyCode() {
        return this.ticketCategory.getCurrencyCode();
    }

    @Generated
    public int getOrdinal() {
        return this.ticketCategory.getOrdinal();
    }

    @Generated
    public TicketCategory.TicketCheckInStrategy getTicketCheckInStrategy() {
        return this.ticketCategory.getTicketCheckInStrategy();
    }

    @Generated
    public TicketCategory.TicketAccessType getTicketAccessType() {
        return this.ticketCategory.getTicketAccessType();
    }
}

