/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.form;

import alfio.controller.form.AdditionalFieldsContainer;
import alfio.controller.form.AdditionalServiceLinkForm;
import alfio.controller.form.UpdateSubscriptionOwnerForm;
import alfio.controller.form.UpdateTicketOwnerForm;
import alfio.controller.support.CustomBindingResult;
import alfio.manager.ExtensionManager;
import alfio.manager.SameCountryValidator;
import alfio.model.AdditionalServiceItem;
import alfio.model.Event;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.TicketReservationInvoicingAdditionalInfo;
import alfio.model.result.ValidationResult;
import alfio.model.result.WarningMessage;
import alfio.model.system.ConfigurationKeys;
import alfio.util.ItalianTaxIdValidator;
import alfio.util.Validator;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContactAndTicketsForm
implements Serializable {
    private String email;
    private String fullName;
    private String firstName;
    private String lastName;
    private String billingAddress;
    private String customerReference;
    private Boolean expressCheckoutRequested;
    private boolean postponeAssignment = false;
    private String vatCountryCode;
    private String vatNr;
    private boolean invoiceRequested = false;
    private Map<String, UpdateTicketOwnerForm> tickets = new HashMap();
    private String billingAddressCompany;
    private String billingAddressLine1;
    private String billingAddressLine2;
    private String billingAddressZip;
    private String billingAddressCity;
    private String billingAddressState;
    private Boolean addCompanyBillingDetails;
    private Boolean skipVatNr;
    private String italyEInvoicingFiscalCode;
    private TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing.ReferenceType italyEInvoicingReferenceType;
    private String italyEInvoicingReferenceAddresseeCode;
    private String italyEInvoicingReferencePEC;
    private boolean italyEInvoicingSplitPayment;
    private boolean differentSubscriptionOwner;
    private UpdateSubscriptionOwnerForm subscriptionOwner;
    private Map<String, List<AdditionalServiceLinkForm>> additionalServices = new HashMap();

    private static void rejectIfOverLength(BindingResult bindingResult, String field, String errorCode, String value, int maxLength) {
        if (value != null && value.length() > maxLength) {
            bindingResult.rejectValue(field, errorCode, new Object[]{maxLength}, null);
        }
    }

    public void validate(CustomBindingResult bindingResult, PurchaseContext purchaseContext, SameCountryValidator vatValidator, Map<ConfigurationKeys, Boolean> formValidationParameters, Optional<Validator.AdditionalFieldsFilterer> additionalFieldsFilterer, boolean reservationRequiresPayment, ExtensionManager extensionManager, Supplier<List<AdditionalServiceItem>> additionalServiceItemsSupplier) {
        this.formalValidation(bindingResult, formValidationParameters.getOrDefault(ConfigurationKeys.ENABLE_ITALY_E_INVOICING, false).booleanValue(), reservationRequiresPayment);
        Validator.AdditionalFieldsFilterer fieldsFilterer = additionalFieldsFilterer.orElseThrow();
        purchaseContext.event().ifPresent(event -> {
            Optional<List> validationResults;
            boolean success;
            this.checkAdditionalServiceItemsLink(event, (BindingResult)bindingResult, additionalServiceItemsSupplier, vatValidator, fieldsFilterer);
            if (!this.postponeAssignment && !(success = (validationResults = Optional.ofNullable(this.tickets).filter(m -> !m.isEmpty()).map(m -> m.entrySet().stream().map(e -> {
                List filteredForTicket = fieldsFilterer.getFieldsForTicket(UUID.fromString((String)e.getKey()), EnumSet.of(PurchaseContextFieldConfiguration.Context.ATTENDEE));
                return Validator.validateTicketAssignment((UpdateTicketOwnerForm)((UpdateTicketOwnerForm)e.getValue()), (List)filteredForTicket, Optional.of(bindingResult), (Event)event, (String)("tickets[" + (String)e.getKey() + "]"), (SameCountryValidator)vatValidator, (ExtensionManager)extensionManager);
            })).map(s -> s.collect(Collectors.toList()))).filter(l -> l.stream().allMatch(ValidationResult::isSuccess)).isPresent())) {
                String errorCode = validationResults.filter(arg_0 -> this.containsVatValidationError(arg_0)).isPresent() ? "error.STEP_2_INVALID_VAT" : "error.STEP_2_MISSING_ATTENDEE_DATA";
                bindingResult.reject(errorCode);
            }
        });
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.subscription)) {
            if (this.differentSubscriptionOwner) {
                ValidationUtils.rejectIfEmptyOrWhitespace((Errors)bindingResult, (String)"subscriptionOwner.firstName", (String)"error.STEP_2_EMPTY_FIRSTNAME");
                ValidationUtils.rejectIfEmptyOrWhitespace((Errors)bindingResult, (String)"subscriptionOwner.lastName", (String)"error.STEP_2_EMPTY_LASTNAME");
                ValidationUtils.rejectIfEmptyOrWhitespace((Errors)bindingResult, (String)"subscriptionOwner.email", (String)"error.STEP_2_EMPTY_EMAIL");
            }
            for (PurchaseContextFieldConfiguration fieldConf : fieldsFilterer.getFieldsForSubscription()) {
                Validator.validateFieldConfiguration((AdditionalFieldsContainer)this.subscriptionOwner, (SameCountryValidator)vatValidator, (Errors)bindingResult, (String)"subscriptionOwner.", (PurchaseContextFieldConfiguration)fieldConf);
            }
        }
    }

    private void checkAdditionalServiceItemsLink(Event event, BindingResult bindingResult, Supplier<List<AdditionalServiceItem>> additionalServiceItemsCount, SameCountryValidator vatValidator, Validator.AdditionalFieldsFilterer additionalFieldsFilterer) {
        if (!event.supportsLinkedAdditionalServices()) {
            return;
        }
        Map form = Objects.requireNonNullElseGet(this.additionalServices, Map::of);
        List<AdditionalServiceItem> additionalServiceItems = additionalServiceItemsCount.get();
        if (additionalServiceItems.size() != form.values().stream().mapToInt(List::size).sum() || form.values().stream().anyMatch(v -> v.stream().anyMatch(Predicate.not(AdditionalServiceLinkForm::isValid)))) {
            bindingResult.reject("error.STEP_2_ADDITIONAL_ITEMS_NOT_ASSIGNED");
        }
        ValidationResult result = ValidationResult.success();
        for (Map.Entry ticketAndFields : form.entrySet()) {
            List filteredForTicket = additionalFieldsFilterer.getFieldsForTicket(UUID.fromString((String)ticketAndFields.getKey()), EnumSet.of(PurchaseContextFieldConfiguration.Context.ADDITIONAL_SERVICE));
            List fieldForms = (List)ticketAndFields.getValue();
            for (int i = 0; i < fieldForms.size(); ++i) {
                result = result.or(Validator.validateAdditionalItemFieldsForTicket((AdditionalServiceLinkForm)((AdditionalServiceLinkForm)fieldForms.get(i)), (List)filteredForTicket, (BindingResult)bindingResult, (String)("additionalServices[" + (String)ticketAndFields.getKey() + "][" + i + "]"), (SameCountryValidator)vatValidator, (List)fieldForms, additionalServiceItems));
            }
        }
        boolean success = result.isSuccess();
        if (!success) {
            String errorCode = this.containsVatValidationError(List.of(result)) ? "error.STEP_2_INVALID_VAT" : "error.STEP_2_MISSING_ATTENDEE_DATA";
            bindingResult.reject(errorCode);
        }
    }

    public void formalValidation(CustomBindingResult bindingResult, boolean italianEInvoicingEnabled, boolean reservationRequiresPayment) {
        this.email = StringUtils.trim((String)this.email);
        this.fullName = StringUtils.trim((String)this.fullName);
        this.firstName = StringUtils.trim((String)this.firstName);
        this.lastName = StringUtils.trim((String)this.lastName);
        this.billingAddress = StringUtils.trim((String)this.billingAddress);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)bindingResult, (String)"email", (String)"error.STEP_2_EMPTY_EMAIL");
        ContactAndTicketsForm.rejectIfOverLength((BindingResult)bindingResult, (String)"email", (String)"error.STEP_2_EMAIL_IS_TOO_LONG", (String)this.email, (int)255);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)bindingResult, (String)"firstName", (String)"error.STEP_2_EMPTY_FIRSTNAME");
        ContactAndTicketsForm.rejectIfOverLength((BindingResult)bindingResult, (String)"firstName", (String)"error.STEP_2_MAX_LENGTH_FIRSTNAME", (String)this.fullName, (int)255);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)bindingResult, (String)"lastName", (String)"error.STEP_2_EMPTY_LASTNAME");
        ContactAndTicketsForm.rejectIfOverLength((BindingResult)bindingResult, (String)"lastName", (String)"error.STEP_2_MAX_LENGTH_LASTNAME", (String)this.fullName, (int)255);
        if (this.invoiceRequested) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)bindingResult, (String)"billingAddressLine1", (String)"error.emptyField");
            ContactAndTicketsForm.rejectIfOverLength((BindingResult)bindingResult, (String)"billingAddressLine1", (String)"error.tooLong", (String)this.billingAddressLine1, (int)256);
            ContactAndTicketsForm.rejectIfOverLength((BindingResult)bindingResult, (String)"billingAddressLine2", (String)"error.tooLong", (String)this.billingAddressLine2, (int)256);
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)bindingResult, (String)"billingAddressZip", (String)"error.emptyField");
            ContactAndTicketsForm.rejectIfOverLength((BindingResult)bindingResult, (String)"billingAddressZip", (String)"error.tooLong", (String)this.billingAddressZip, (int)51);
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)bindingResult, (String)"billingAddressCity", (String)"error.emptyField");
            ContactAndTicketsForm.rejectIfOverLength((BindingResult)bindingResult, (String)"billingAddressCity", (String)"error.tooLong", (String)this.billingAddressCity, (int)256);
            ValidationUtils.rejectIfEmpty((Errors)bindingResult, (String)"vatCountryCode", (String)"error.emptyField");
            if (StringUtils.trimToNull((String)this.billingAddressCompany) != null && !this.canSkipVatNrCheck()) {
                ValidationUtils.rejectIfEmptyOrWhitespace((Errors)bindingResult, (String)"vatNr", (String)"error.emptyField");
            }
        }
        if (italianEInvoicingEnabled && StringUtils.isNotEmpty((CharSequence)this.vatCountryCode) && reservationRequiresPayment) {
            ValidationUtils.rejectIfEmpty((Errors)bindingResult, (String)"italyEInvoicingFiscalCode", (String)"error.emptyField");
            ContactAndTicketsForm.rejectIfOverLength((BindingResult)bindingResult, (String)"italyEInvoicingFiscalCode", (String)"error.tooLong", (String)this.italyEInvoicingFiscalCode, (int)28);
        }
        if (italianEInvoicingEnabled && "IT".equals(this.vatCountryCode) && reservationRequiresPayment) {
            boolean fiscalCodeValid;
            ValidationUtils.rejectIfEmpty((Errors)bindingResult, (String)"italyEInvoicingReferenceType", (String)"error.italyEInvoicingReferenceTypeSelectValue");
            if (TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing.ReferenceType.ADDRESSEE_CODE == this.italyEInvoicingReferenceType) {
                ValidationUtils.rejectIfEmpty((Errors)bindingResult, (String)"italyEInvoicingReferenceAddresseeCode", (String)"error.emptyField");
                this.italyEInvoicingReferenceAddresseeCode = StringUtils.trim((String)this.italyEInvoicingReferenceAddresseeCode);
                if (this.italyEInvoicingReferenceAddresseeCode != null) {
                    if (this.italyEInvoicingReferenceAddresseeCode.length() != 7) {
                        bindingResult.rejectValue("italyEInvoicingReferenceAddresseeCode", "error.lengthMustBe7");
                    }
                    if (!StringUtils.isAlphanumeric((CharSequence)this.italyEInvoicingReferenceAddresseeCode)) {
                        bindingResult.rejectValue("italyEInvoicingReferenceAddresseeCode", "error.alphanumeric");
                    }
                }
            }
            if (TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing.ReferenceType.PEC == this.italyEInvoicingReferenceType) {
                ValidationUtils.rejectIfEmpty((Errors)bindingResult, (String)"italyEInvoicingReferencePEC", (String)"error.emptyField");
            }
            if (this.billingAddressState == null || this.billingAddressState.strip().length() != 2) {
                bindingResult.rejectValue("billingAddressState", "error.length", new Object[]{2}, null);
            } else if (!StringUtils.isAlpha((CharSequence)this.billingAddressState)) {
                bindingResult.rejectValue("billingAddressState", "error.restrictedValue");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.vatNr) && !ItalianTaxIdValidator.validateVatId((String)this.vatNr)) {
                bindingResult.rejectValue("vatNr", "error.STEP_2_INVALID_VAT");
            }
            if (!(fiscalCodeValid = ItalianTaxIdValidator.validateFiscalCode((String)this.italyEInvoicingFiscalCode))) {
                bindingResult.rejectValue("italyEInvoicingFiscalCode", "error.restrictedValue");
            } else if (!ItalianTaxIdValidator.fiscalCodeMatchesWithName((String)this.firstName, (String)this.lastName, (String)this.italyEInvoicingFiscalCode)) {
                bindingResult.addWarning("warning.fiscal-code-name-mismatch");
            }
            if (StringUtils.length((CharSequence)StringUtils.trimToNull((String)this.billingAddressZip)) != 5) {
                bindingResult.rejectValue("billingAddressZip", "error.length", new Object[]{5}, null);
            } else if (!StringUtils.isNumeric((CharSequence)this.billingAddressZip)) {
                bindingResult.rejectValue("billingAddressZip", "error.restrictedValue");
            }
        }
        if (this.email != null && !bindingResult.hasFieldErrors("email")) {
            if (!Validator.isEmailValid((String)this.email)) {
                bindingResult.rejectValue("email", "error.STEP_2_INVALID_EMAIL", new Object[0], null);
            } else if (!Validator.isCanonicalMailAddress((String)this.email)) {
                bindingResult.addWarning(new WarningMessage("error.STEP_2_EMAIL_TYPO", List.of(this.email)));
            }
        }
    }

    private boolean containsVatValidationError(List<ValidationResult> l) {
        return l.stream().anyMatch(v -> !v.isSuccess() && v.getErrorDescriptors().stream().anyMatch(ed -> ed.getCode().equals("error.STEP_2_INVALID_VAT")));
    }

    public boolean canSkipVatNrCheck() {
        return Boolean.TRUE.equals(this.skipVatNr);
    }

    public boolean isBusiness() {
        return this.getAddCompanyBillingDetails() && !this.canSkipVatNrCheck() && this.invoiceRequested;
    }

    public boolean getAddCompanyBillingDetails() {
        return Boolean.TRUE.equals(this.addCompanyBillingDetails);
    }

    public boolean hasAdditionalServices() {
        return MapUtils.isNotEmpty((Map)this.additionalServices);
    }

    @Generated
    public ContactAndTicketsForm() {
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getFullName() {
        return this.fullName;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getBillingAddress() {
        return this.billingAddress;
    }

    @Generated
    public String getCustomerReference() {
        return this.customerReference;
    }

    @Generated
    public Boolean getExpressCheckoutRequested() {
        return this.expressCheckoutRequested;
    }

    @Generated
    public boolean isPostponeAssignment() {
        return this.postponeAssignment;
    }

    @Generated
    public String getVatCountryCode() {
        return this.vatCountryCode;
    }

    @Generated
    public String getVatNr() {
        return this.vatNr;
    }

    @Generated
    public boolean isInvoiceRequested() {
        return this.invoiceRequested;
    }

    @Generated
    public Map<String, UpdateTicketOwnerForm> getTickets() {
        return this.tickets;
    }

    @Generated
    public String getBillingAddressCompany() {
        return this.billingAddressCompany;
    }

    @Generated
    public String getBillingAddressLine1() {
        return this.billingAddressLine1;
    }

    @Generated
    public String getBillingAddressLine2() {
        return this.billingAddressLine2;
    }

    @Generated
    public String getBillingAddressZip() {
        return this.billingAddressZip;
    }

    @Generated
    public String getBillingAddressCity() {
        return this.billingAddressCity;
    }

    @Generated
    public String getBillingAddressState() {
        return this.billingAddressState;
    }

    @Generated
    public Boolean getSkipVatNr() {
        return this.skipVatNr;
    }

    @Generated
    public String getItalyEInvoicingFiscalCode() {
        return this.italyEInvoicingFiscalCode;
    }

    @Generated
    public TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing.ReferenceType getItalyEInvoicingReferenceType() {
        return this.italyEInvoicingReferenceType;
    }

    @Generated
    public String getItalyEInvoicingReferenceAddresseeCode() {
        return this.italyEInvoicingReferenceAddresseeCode;
    }

    @Generated
    public String getItalyEInvoicingReferencePEC() {
        return this.italyEInvoicingReferencePEC;
    }

    @Generated
    public boolean isItalyEInvoicingSplitPayment() {
        return this.italyEInvoicingSplitPayment;
    }

    @Generated
    public boolean isDifferentSubscriptionOwner() {
        return this.differentSubscriptionOwner;
    }

    @Generated
    public UpdateSubscriptionOwnerForm getSubscriptionOwner() {
        return this.subscriptionOwner;
    }

    @Generated
    public Map<String, List<AdditionalServiceLinkForm>> getAdditionalServices() {
        return this.additionalServices;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }

    @Generated
    public void setCustomerReference(String customerReference) {
        this.customerReference = customerReference;
    }

    @Generated
    public void setExpressCheckoutRequested(Boolean expressCheckoutRequested) {
        this.expressCheckoutRequested = expressCheckoutRequested;
    }

    @Generated
    public void setPostponeAssignment(boolean postponeAssignment) {
        this.postponeAssignment = postponeAssignment;
    }

    @Generated
    public void setVatCountryCode(String vatCountryCode) {
        this.vatCountryCode = vatCountryCode;
    }

    @Generated
    public void setVatNr(String vatNr) {
        this.vatNr = vatNr;
    }

    @Generated
    public void setInvoiceRequested(boolean invoiceRequested) {
        this.invoiceRequested = invoiceRequested;
    }

    @Generated
    public void setTickets(Map<String, UpdateTicketOwnerForm> tickets) {
        this.tickets = tickets;
    }

    @Generated
    public void setBillingAddressCompany(String billingAddressCompany) {
        this.billingAddressCompany = billingAddressCompany;
    }

    @Generated
    public void setBillingAddressLine1(String billingAddressLine1) {
        this.billingAddressLine1 = billingAddressLine1;
    }

    @Generated
    public void setBillingAddressLine2(String billingAddressLine2) {
        this.billingAddressLine2 = billingAddressLine2;
    }

    @Generated
    public void setBillingAddressZip(String billingAddressZip) {
        this.billingAddressZip = billingAddressZip;
    }

    @Generated
    public void setBillingAddressCity(String billingAddressCity) {
        this.billingAddressCity = billingAddressCity;
    }

    @Generated
    public void setBillingAddressState(String billingAddressState) {
        this.billingAddressState = billingAddressState;
    }

    @Generated
    public void setAddCompanyBillingDetails(Boolean addCompanyBillingDetails) {
        this.addCompanyBillingDetails = addCompanyBillingDetails;
    }

    @Generated
    public void setSkipVatNr(Boolean skipVatNr) {
        this.skipVatNr = skipVatNr;
    }

    @Generated
    public void setItalyEInvoicingFiscalCode(String italyEInvoicingFiscalCode) {
        this.italyEInvoicingFiscalCode = italyEInvoicingFiscalCode;
    }

    @Generated
    public void setItalyEInvoicingReferenceType(TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing.ReferenceType italyEInvoicingReferenceType) {
        this.italyEInvoicingReferenceType = italyEInvoicingReferenceType;
    }

    @Generated
    public void setItalyEInvoicingReferenceAddresseeCode(String italyEInvoicingReferenceAddresseeCode) {
        this.italyEInvoicingReferenceAddresseeCode = italyEInvoicingReferenceAddresseeCode;
    }

    @Generated
    public void setItalyEInvoicingReferencePEC(String italyEInvoicingReferencePEC) {
        this.italyEInvoicingReferencePEC = italyEInvoicingReferencePEC;
    }

    @Generated
    public void setItalyEInvoicingSplitPayment(boolean italyEInvoicingSplitPayment) {
        this.italyEInvoicingSplitPayment = italyEInvoicingSplitPayment;
    }

    @Generated
    public void setDifferentSubscriptionOwner(boolean differentSubscriptionOwner) {
        this.differentSubscriptionOwner = differentSubscriptionOwner;
    }

    @Generated
    public void setSubscriptionOwner(UpdateSubscriptionOwnerForm subscriptionOwner) {
        this.subscriptionOwner = subscriptionOwner;
    }

    @Generated
    public void setAdditionalServices(Map<String, List<AdditionalServiceLinkForm>> additionalServices) {
        this.additionalServices = additionalServices;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContactAndTicketsForm)) {
            return false;
        }
        ContactAndTicketsForm other = (ContactAndTicketsForm)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isPostponeAssignment() != other.isPostponeAssignment()) {
            return false;
        }
        if (this.isInvoiceRequested() != other.isInvoiceRequested()) {
            return false;
        }
        if (this.isItalyEInvoicingSplitPayment() != other.isItalyEInvoicingSplitPayment()) {
            return false;
        }
        if (this.isDifferentSubscriptionOwner() != other.isDifferentSubscriptionOwner()) {
            return false;
        }
        Boolean this$expressCheckoutRequested = this.getExpressCheckoutRequested();
        Boolean other$expressCheckoutRequested = other.getExpressCheckoutRequested();
        if (this$expressCheckoutRequested == null ? other$expressCheckoutRequested != null : !((Object)this$expressCheckoutRequested).equals(other$expressCheckoutRequested)) {
            return false;
        }
        if (this.getAddCompanyBillingDetails() != other.getAddCompanyBillingDetails()) {
            return false;
        }
        Boolean this$skipVatNr = this.getSkipVatNr();
        Boolean other$skipVatNr = other.getSkipVatNr();
        if (this$skipVatNr == null ? other$skipVatNr != null : !((Object)this$skipVatNr).equals(other$skipVatNr)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$billingAddress = this.getBillingAddress();
        String other$billingAddress = other.getBillingAddress();
        if (this$billingAddress == null ? other$billingAddress != null : !this$billingAddress.equals(other$billingAddress)) {
            return false;
        }
        String this$customerReference = this.getCustomerReference();
        String other$customerReference = other.getCustomerReference();
        if (this$customerReference == null ? other$customerReference != null : !this$customerReference.equals(other$customerReference)) {
            return false;
        }
        String this$vatCountryCode = this.getVatCountryCode();
        String other$vatCountryCode = other.getVatCountryCode();
        if (this$vatCountryCode == null ? other$vatCountryCode != null : !this$vatCountryCode.equals(other$vatCountryCode)) {
            return false;
        }
        String this$vatNr = this.getVatNr();
        String other$vatNr = other.getVatNr();
        if (this$vatNr == null ? other$vatNr != null : !this$vatNr.equals(other$vatNr)) {
            return false;
        }
        Map this$tickets = this.getTickets();
        Map other$tickets = other.getTickets();
        if (this$tickets == null ? other$tickets != null : !((Object)this$tickets).equals(other$tickets)) {
            return false;
        }
        String this$billingAddressCompany = this.getBillingAddressCompany();
        String other$billingAddressCompany = other.getBillingAddressCompany();
        if (this$billingAddressCompany == null ? other$billingAddressCompany != null : !this$billingAddressCompany.equals(other$billingAddressCompany)) {
            return false;
        }
        String this$billingAddressLine1 = this.getBillingAddressLine1();
        String other$billingAddressLine1 = other.getBillingAddressLine1();
        if (this$billingAddressLine1 == null ? other$billingAddressLine1 != null : !this$billingAddressLine1.equals(other$billingAddressLine1)) {
            return false;
        }
        String this$billingAddressLine2 = this.getBillingAddressLine2();
        String other$billingAddressLine2 = other.getBillingAddressLine2();
        if (this$billingAddressLine2 == null ? other$billingAddressLine2 != null : !this$billingAddressLine2.equals(other$billingAddressLine2)) {
            return false;
        }
        String this$billingAddressZip = this.getBillingAddressZip();
        String other$billingAddressZip = other.getBillingAddressZip();
        if (this$billingAddressZip == null ? other$billingAddressZip != null : !this$billingAddressZip.equals(other$billingAddressZip)) {
            return false;
        }
        String this$billingAddressCity = this.getBillingAddressCity();
        String other$billingAddressCity = other.getBillingAddressCity();
        if (this$billingAddressCity == null ? other$billingAddressCity != null : !this$billingAddressCity.equals(other$billingAddressCity)) {
            return false;
        }
        String this$billingAddressState = this.getBillingAddressState();
        String other$billingAddressState = other.getBillingAddressState();
        if (this$billingAddressState == null ? other$billingAddressState != null : !this$billingAddressState.equals(other$billingAddressState)) {
            return false;
        }
        String this$italyEInvoicingFiscalCode = this.getItalyEInvoicingFiscalCode();
        String other$italyEInvoicingFiscalCode = other.getItalyEInvoicingFiscalCode();
        if (this$italyEInvoicingFiscalCode == null ? other$italyEInvoicingFiscalCode != null : !this$italyEInvoicingFiscalCode.equals(other$italyEInvoicingFiscalCode)) {
            return false;
        }
        TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing.ReferenceType this$italyEInvoicingReferenceType = this.getItalyEInvoicingReferenceType();
        TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing.ReferenceType other$italyEInvoicingReferenceType = other.getItalyEInvoicingReferenceType();
        if (this$italyEInvoicingReferenceType == null ? other$italyEInvoicingReferenceType != null : !this$italyEInvoicingReferenceType.equals(other$italyEInvoicingReferenceType)) {
            return false;
        }
        String this$italyEInvoicingReferenceAddresseeCode = this.getItalyEInvoicingReferenceAddresseeCode();
        String other$italyEInvoicingReferenceAddresseeCode = other.getItalyEInvoicingReferenceAddresseeCode();
        if (this$italyEInvoicingReferenceAddresseeCode == null ? other$italyEInvoicingReferenceAddresseeCode != null : !this$italyEInvoicingReferenceAddresseeCode.equals(other$italyEInvoicingReferenceAddresseeCode)) {
            return false;
        }
        String this$italyEInvoicingReferencePEC = this.getItalyEInvoicingReferencePEC();
        String other$italyEInvoicingReferencePEC = other.getItalyEInvoicingReferencePEC();
        if (this$italyEInvoicingReferencePEC == null ? other$italyEInvoicingReferencePEC != null : !this$italyEInvoicingReferencePEC.equals(other$italyEInvoicingReferencePEC)) {
            return false;
        }
        UpdateSubscriptionOwnerForm this$subscriptionOwner = this.getSubscriptionOwner();
        UpdateSubscriptionOwnerForm other$subscriptionOwner = other.getSubscriptionOwner();
        if (this$subscriptionOwner == null ? other$subscriptionOwner != null : !this$subscriptionOwner.equals(other$subscriptionOwner)) {
            return false;
        }
        Map this$additionalServices = this.getAdditionalServices();
        Map other$additionalServices = other.getAdditionalServices();
        return !(this$additionalServices == null ? other$additionalServices != null : !((Object)this$additionalServices).equals(other$additionalServices));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContactAndTicketsForm;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPostponeAssignment() ? 79 : 97);
        result = result * 59 + (this.isInvoiceRequested() ? 79 : 97);
        result = result * 59 + (this.isItalyEInvoicingSplitPayment() ? 79 : 97);
        result = result * 59 + (this.isDifferentSubscriptionOwner() ? 79 : 97);
        Boolean $expressCheckoutRequested = this.getExpressCheckoutRequested();
        result = result * 59 + ($expressCheckoutRequested == null ? 43 : ((Object)$expressCheckoutRequested).hashCode());
        result = result * 59 + (this.getAddCompanyBillingDetails() ? 79 : 97);
        Boolean $skipVatNr = this.getSkipVatNr();
        result = result * 59 + ($skipVatNr == null ? 43 : ((Object)$skipVatNr).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $billingAddress = this.getBillingAddress();
        result = result * 59 + ($billingAddress == null ? 43 : $billingAddress.hashCode());
        String $customerReference = this.getCustomerReference();
        result = result * 59 + ($customerReference == null ? 43 : $customerReference.hashCode());
        String $vatCountryCode = this.getVatCountryCode();
        result = result * 59 + ($vatCountryCode == null ? 43 : $vatCountryCode.hashCode());
        String $vatNr = this.getVatNr();
        result = result * 59 + ($vatNr == null ? 43 : $vatNr.hashCode());
        Map $tickets = this.getTickets();
        result = result * 59 + ($tickets == null ? 43 : ((Object)$tickets).hashCode());
        String $billingAddressCompany = this.getBillingAddressCompany();
        result = result * 59 + ($billingAddressCompany == null ? 43 : $billingAddressCompany.hashCode());
        String $billingAddressLine1 = this.getBillingAddressLine1();
        result = result * 59 + ($billingAddressLine1 == null ? 43 : $billingAddressLine1.hashCode());
        String $billingAddressLine2 = this.getBillingAddressLine2();
        result = result * 59 + ($billingAddressLine2 == null ? 43 : $billingAddressLine2.hashCode());
        String $billingAddressZip = this.getBillingAddressZip();
        result = result * 59 + ($billingAddressZip == null ? 43 : $billingAddressZip.hashCode());
        String $billingAddressCity = this.getBillingAddressCity();
        result = result * 59 + ($billingAddressCity == null ? 43 : $billingAddressCity.hashCode());
        String $billingAddressState = this.getBillingAddressState();
        result = result * 59 + ($billingAddressState == null ? 43 : $billingAddressState.hashCode());
        String $italyEInvoicingFiscalCode = this.getItalyEInvoicingFiscalCode();
        result = result * 59 + ($italyEInvoicingFiscalCode == null ? 43 : $italyEInvoicingFiscalCode.hashCode());
        TicketReservationInvoicingAdditionalInfo.ItalianEInvoicing.ReferenceType $italyEInvoicingReferenceType = this.getItalyEInvoicingReferenceType();
        result = result * 59 + ($italyEInvoicingReferenceType == null ? 43 : $italyEInvoicingReferenceType.hashCode());
        String $italyEInvoicingReferenceAddresseeCode = this.getItalyEInvoicingReferenceAddresseeCode();
        result = result * 59 + ($italyEInvoicingReferenceAddresseeCode == null ? 43 : $italyEInvoicingReferenceAddresseeCode.hashCode());
        String $italyEInvoicingReferencePEC = this.getItalyEInvoicingReferencePEC();
        result = result * 59 + ($italyEInvoicingReferencePEC == null ? 43 : $italyEInvoicingReferencePEC.hashCode());
        UpdateSubscriptionOwnerForm $subscriptionOwner = this.getSubscriptionOwner();
        result = result * 59 + ($subscriptionOwner == null ? 43 : $subscriptionOwner.hashCode());
        Map $additionalServices = this.getAdditionalServices();
        result = result * 59 + ($additionalServices == null ? 43 : ((Object)$additionalServices).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContactAndTicketsForm(email=" + this.getEmail() + ", fullName=" + this.getFullName() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", billingAddress=" + this.getBillingAddress() + ", customerReference=" + this.getCustomerReference() + ", expressCheckoutRequested=" + this.getExpressCheckoutRequested() + ", postponeAssignment=" + this.isPostponeAssignment() + ", vatCountryCode=" + this.getVatCountryCode() + ", vatNr=" + this.getVatNr() + ", invoiceRequested=" + this.isInvoiceRequested() + ", tickets=" + this.getTickets() + ", billingAddressCompany=" + this.getBillingAddressCompany() + ", billingAddressLine1=" + this.getBillingAddressLine1() + ", billingAddressLine2=" + this.getBillingAddressLine2() + ", billingAddressZip=" + this.getBillingAddressZip() + ", billingAddressCity=" + this.getBillingAddressCity() + ", billingAddressState=" + this.getBillingAddressState() + ", addCompanyBillingDetails=" + this.getAddCompanyBillingDetails() + ", skipVatNr=" + this.getSkipVatNr() + ", italyEInvoicingFiscalCode=" + this.getItalyEInvoicingFiscalCode() + ", italyEInvoicingReferenceType=" + this.getItalyEInvoicingReferenceType() + ", italyEInvoicingReferenceAddresseeCode=" + this.getItalyEInvoicingReferenceAddresseeCode() + ", italyEInvoicingReferencePEC=" + this.getItalyEInvoicingReferencePEC() + ", italyEInvoicingSplitPayment=" + this.isItalyEInvoicingSplitPayment() + ", differentSubscriptionOwner=" + this.isDifferentSubscriptionOwner() + ", subscriptionOwner=" + this.getSubscriptionOwner() + ", additionalServices=" + this.getAdditionalServices() + ")";
    }
}

