/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.form;

import alfio.model.PurchaseContext;
import alfio.model.TotalPrice;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProxy;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.BindingResult;

public class PaymentForm
implements Serializable {
    private String gatewayToken;
    private PaymentProxy paymentProxy;
    private PaymentMethod selectedPaymentMethod;
    private Boolean termAndConditionsAccepted;
    private Boolean privacyPolicyAccepted;
    private String hmac;
    private String captcha;

    public void validate(BindingResult bindingResult, PurchaseContext purchaseContext, TotalPrice reservationCost) {
        boolean multipleProxies;
        List allowedProxies = purchaseContext.getAllowedPaymentProxies();
        Optional<PaymentProxy> paymentProxyOptional = Optional.ofNullable(this.paymentProxy);
        boolean priceGreaterThanZero = reservationCost.getPriceWithVAT() > 0;
        boolean bl = multipleProxies = allowedProxies.size() > 1;
        if (multipleProxies && priceGreaterThanZero && paymentProxyOptional.isEmpty()) {
            bindingResult.reject("error.STEP_2_MISSING_PAYMENT_METHOD");
        }
        if (Objects.isNull(this.termAndConditionsAccepted) || !this.termAndConditionsAccepted.booleanValue() || StringUtils.isNotEmpty((CharSequence)purchaseContext.getPrivacyPolicyUrl()) && (Objects.isNull(this.privacyPolicyAccepted) || !this.privacyPolicyAccepted.booleanValue())) {
            bindingResult.reject("error.STEP_2_TERMS_CONDITIONS");
        }
    }

    @Generated
    public PaymentForm() {
    }

    @Generated
    public String getGatewayToken() {
        return this.gatewayToken;
    }

    @Generated
    public PaymentProxy getPaymentProxy() {
        return this.paymentProxy;
    }

    @Generated
    public PaymentMethod getSelectedPaymentMethod() {
        return this.selectedPaymentMethod;
    }

    @Generated
    public Boolean getTermAndConditionsAccepted() {
        return this.termAndConditionsAccepted;
    }

    @Generated
    public Boolean getPrivacyPolicyAccepted() {
        return this.privacyPolicyAccepted;
    }

    @Generated
    public String getHmac() {
        return this.hmac;
    }

    @Generated
    public String getCaptcha() {
        return this.captcha;
    }

    @Generated
    public void setGatewayToken(String gatewayToken) {
        this.gatewayToken = gatewayToken;
    }

    @Generated
    public void setPaymentProxy(PaymentProxy paymentProxy) {
        this.paymentProxy = paymentProxy;
    }

    @Generated
    public void setSelectedPaymentMethod(PaymentMethod selectedPaymentMethod) {
        this.selectedPaymentMethod = selectedPaymentMethod;
    }

    @Generated
    public void setTermAndConditionsAccepted(Boolean termAndConditionsAccepted) {
        this.termAndConditionsAccepted = termAndConditionsAccepted;
    }

    @Generated
    public void setPrivacyPolicyAccepted(Boolean privacyPolicyAccepted) {
        this.privacyPolicyAccepted = privacyPolicyAccepted;
    }

    @Generated
    public void setHmac(String hmac) {
        this.hmac = hmac;
    }

    @Generated
    public void setCaptcha(String captcha) {
        this.captcha = captcha;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentForm)) {
            return false;
        }
        PaymentForm other = (PaymentForm)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$termAndConditionsAccepted = this.getTermAndConditionsAccepted();
        Boolean other$termAndConditionsAccepted = other.getTermAndConditionsAccepted();
        if (this$termAndConditionsAccepted == null ? other$termAndConditionsAccepted != null : !((Object)this$termAndConditionsAccepted).equals(other$termAndConditionsAccepted)) {
            return false;
        }
        Boolean this$privacyPolicyAccepted = this.getPrivacyPolicyAccepted();
        Boolean other$privacyPolicyAccepted = other.getPrivacyPolicyAccepted();
        if (this$privacyPolicyAccepted == null ? other$privacyPolicyAccepted != null : !((Object)this$privacyPolicyAccepted).equals(other$privacyPolicyAccepted)) {
            return false;
        }
        String this$gatewayToken = this.getGatewayToken();
        String other$gatewayToken = other.getGatewayToken();
        if (this$gatewayToken == null ? other$gatewayToken != null : !this$gatewayToken.equals(other$gatewayToken)) {
            return false;
        }
        PaymentProxy this$paymentProxy = this.getPaymentProxy();
        PaymentProxy other$paymentProxy = other.getPaymentProxy();
        if (this$paymentProxy == null ? other$paymentProxy != null : !this$paymentProxy.equals(other$paymentProxy)) {
            return false;
        }
        PaymentMethod this$selectedPaymentMethod = this.getSelectedPaymentMethod();
        PaymentMethod other$selectedPaymentMethod = other.getSelectedPaymentMethod();
        if (this$selectedPaymentMethod == null ? other$selectedPaymentMethod != null : !this$selectedPaymentMethod.equals(other$selectedPaymentMethod)) {
            return false;
        }
        String this$hmac = this.getHmac();
        String other$hmac = other.getHmac();
        if (this$hmac == null ? other$hmac != null : !this$hmac.equals(other$hmac)) {
            return false;
        }
        String this$captcha = this.getCaptcha();
        String other$captcha = other.getCaptcha();
        return !(this$captcha == null ? other$captcha != null : !this$captcha.equals(other$captcha));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentForm;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $termAndConditionsAccepted = this.getTermAndConditionsAccepted();
        result = result * 59 + ($termAndConditionsAccepted == null ? 43 : ((Object)$termAndConditionsAccepted).hashCode());
        Boolean $privacyPolicyAccepted = this.getPrivacyPolicyAccepted();
        result = result * 59 + ($privacyPolicyAccepted == null ? 43 : ((Object)$privacyPolicyAccepted).hashCode());
        String $gatewayToken = this.getGatewayToken();
        result = result * 59 + ($gatewayToken == null ? 43 : $gatewayToken.hashCode());
        PaymentProxy $paymentProxy = this.getPaymentProxy();
        result = result * 59 + ($paymentProxy == null ? 43 : $paymentProxy.hashCode());
        PaymentMethod $selectedPaymentMethod = this.getSelectedPaymentMethod();
        result = result * 59 + ($selectedPaymentMethod == null ? 43 : $selectedPaymentMethod.hashCode());
        String $hmac = this.getHmac();
        result = result * 59 + ($hmac == null ? 43 : $hmac.hashCode());
        String $captcha = this.getCaptcha();
        result = result * 59 + ($captcha == null ? 43 : $captcha.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PaymentForm(gatewayToken=" + this.getGatewayToken() + ", paymentProxy=" + this.getPaymentProxy() + ", selectedPaymentMethod=" + this.getSelectedPaymentMethod() + ", termAndConditionsAccepted=" + this.getTermAndConditionsAccepted() + ", privacyPolicyAccepted=" + this.getPrivacyPolicyAccepted() + ", hmac=" + this.getHmac() + ", captcha=" + this.getCaptcha() + ")";
    }
}

