/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.form;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchOptions {
    private static final Logger log = LoggerFactory.getLogger(SearchOptions.class);
    private String subscription;
    private Integer organizer;
    private String organizerSlug;
    private List<String> tags;

    public static SearchOptions empty() {
        return new SearchOptions();
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.subscription) && (this.organizer == null || this.organizer == 0 || StringUtils.isEmpty((CharSequence)this.organizerSlug)) && CollectionUtils.isEmpty((Collection)this.tags);
    }

    public UUID getSubscriptionCodeUUIDOrNull() {
        try {
            if (StringUtils.isEmpty((CharSequence)this.subscription)) {
                return null;
            }
            return UUID.fromString(this.subscription);
        }
        catch (Exception e) {
            log.warn("invalid UUID received: {}", (Object)this.subscription);
            return null;
        }
    }

    @Generated
    public SearchOptions() {
    }

    @Generated
    public String getSubscription() {
        return this.subscription;
    }

    @Generated
    public Integer getOrganizer() {
        return this.organizer;
    }

    @Generated
    public String getOrganizerSlug() {
        return this.organizerSlug;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    @Generated
    public void setOrganizer(Integer organizer) {
        this.organizer = organizer;
    }

    @Generated
    public void setOrganizerSlug(String organizerSlug) {
        this.organizerSlug = organizerSlug;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchOptions)) {
            return false;
        }
        SearchOptions other = (SearchOptions)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$organizer = this.getOrganizer();
        Integer other$organizer = other.getOrganizer();
        if (this$organizer == null ? other$organizer != null : !((Object)this$organizer).equals(other$organizer)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        String this$organizerSlug = this.getOrganizerSlug();
        String other$organizerSlug = other.getOrganizerSlug();
        if (this$organizerSlug == null ? other$organizerSlug != null : !this$organizerSlug.equals(other$organizerSlug)) {
            return false;
        }
        List this$tags = this.getTags();
        List other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SearchOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $organizer = this.getOrganizer();
        result = result * 59 + ($organizer == null ? 43 : ((Object)$organizer).hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        String $organizerSlug = this.getOrganizerSlug();
        result = result * 59 + ($organizerSlug == null ? 43 : $organizerSlug.hashCode());
        List $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SearchOptions(subscription=" + this.getSubscription() + ", organizer=" + this.getOrganizer() + ", organizerSlug=" + this.getOrganizerSlug() + ", tags=" + this.getTags() + ")";
    }
}

