/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.payment;

import alfio.manager.PurchaseContextManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.payment.PayPalManager;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.transaction.token.PayPalToken;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/{purchaseContextType}/{purchaseContextIdentifier}/reservation/{reservationId}/payment/paypal"})
public class PayPalCallbackController {
    private final PurchaseContextManager purchaseContextManager;
    private final TicketReservationManager ticketReservationManager;
    private final PayPalManager payPalManager;

    @GetMapping(value={"/confirm"})
    public String payPalSuccess(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable(value="purchaseContextIdentifier") String purchaseContextId, @PathVariable String reservationId, @RequestParam(value="token", required=false) String payPalPaymentId, @RequestParam(value="PayerID", required=false) String payPalPayerID, @RequestParam(value="hmac") String hmac) {
        Optional<PurchaseContext> optionalPurchaseContext = this.purchaseContextManager.findByReservationId(reservationId).filter(pc -> pc.getType() == purchaseContextType && pc.getPublicIdentifier().equals(purchaseContextId));
        if (optionalPurchaseContext.isEmpty()) {
            return "redirect:/";
        }
        Optional optionalReservation = this.ticketReservationManager.findById(reservationId);
        PurchaseContext purchaseContext = optionalPurchaseContext.get();
        if (optionalReservation.isEmpty()) {
            return "redirect:/" + purchaseContext.getType().getUrlComponent() + "/" + purchaseContext.getPublicIdentifier();
        }
        TicketReservation res = (TicketReservation)optionalReservation.get();
        if (StringUtils.isNotBlank((CharSequence)payPalPayerID) && StringUtils.isNotBlank((CharSequence)payPalPaymentId)) {
            PayPalToken token = new PayPalToken(payPalPayerID, payPalPaymentId, hmac);
            this.payPalManager.saveToken(res.getId(), purchaseContext, token);
            return "redirect:/" + purchaseContext.getType().getUrlComponent() + "/" + purchaseContext.getPublicIdentifier() + "/reservation/" + res.getId() + "/overview";
        }
        return this.payPalCancel(res.getId(), payPalPaymentId, hmac);
    }

    @GetMapping(value={"/cancel"})
    public String payPalCancel(@PathVariable String reservationId, @RequestParam(value="token", required=false) String payPalPaymentId, @RequestParam String hmac) {
        Optional optionalPurchaseContext = this.purchaseContextManager.findByReservationId(reservationId);
        if (optionalPurchaseContext.isEmpty()) {
            return "redirect:/";
        }
        PurchaseContext purchaseContext = (PurchaseContext)optionalPurchaseContext.get();
        Optional optionalReservation = this.ticketReservationManager.findById(reservationId);
        if (optionalReservation.isEmpty()) {
            return "redirect:/" + purchaseContext.getType().getUrlComponent() + "/" + purchaseContext.getPublicIdentifier();
        }
        this.payPalManager.removeToken((TicketReservation)optionalReservation.get(), payPalPaymentId);
        return "redirect:/" + purchaseContext.getType().getUrlComponent() + "/" + purchaseContext.getPublicIdentifier() + "/reservation/" + ((TicketReservation)optionalReservation.get()).getId() + "/overview";
    }

    @ConstructorProperties(value={"purchaseContextManager", "ticketReservationManager", "payPalManager"})
    @Generated
    public PayPalCallbackController(PurchaseContextManager purchaseContextManager, TicketReservationManager ticketReservationManager, PayPalManager payPalManager) {
        this.purchaseContextManager = purchaseContextManager;
        this.ticketReservationManager = ticketReservationManager;
        this.payPalManager = payPalManager;
    }
}

