/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.payment;

import alfio.manager.PurchaseContextManager;
import alfio.manager.TicketReservationManager;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
public class SaferpayCallbackController {
    private final TicketReservationManager ticketReservationManager;
    private final PurchaseContextManager purchaseContextManager;

    @GetMapping(value={"/{purchaseContextType}/{purchaseContextIdentifier}/reservation/{reservationId}/payment/saferpay/cancel"})
    public String saferpayCancel(@PathVariable PurchaseContext.PurchaseContextType purchaseContextType, @PathVariable String purchaseContextIdentifier, @PathVariable String reservationId) {
        Optional maybePurchaseContext = this.purchaseContextManager.findBy(purchaseContextType, purchaseContextIdentifier);
        if (maybePurchaseContext.isEmpty()) {
            return "redirect:/";
        }
        PurchaseContext purchaseContext = (PurchaseContext)maybePurchaseContext.get();
        Optional optionalReservation = this.ticketReservationManager.findById(reservationId);
        if (optionalReservation.isEmpty()) {
            return "redirect:/" + purchaseContext.getType().getUrlComponent() + "/" + purchaseContext.getPublicIdentifier();
        }
        Optional optionalResult = this.ticketReservationManager.forceTransactionCheck(purchaseContext, (TicketReservation)optionalReservation.get());
        if (optionalResult.isEmpty()) {
            return "redirect:/" + purchaseContext.getType().getUrlComponent() + "/" + purchaseContext.getPublicIdentifier();
        }
        return "redirect:" + UriComponentsBuilder.fromPath((String)"/{purchaseContextType}/{purchaseContextIdentifier}/reservation/{reservationId}").buildAndExpand(new Object[]{purchaseContext.getType().getUrlComponent(), purchaseContext.getPublicIdentifier(), reservationId}).toUriString();
    }

    @ConstructorProperties(value={"ticketReservationManager", "purchaseContextManager"})
    @Generated
    public SaferpayCallbackController(TicketReservationManager ticketReservationManager, PurchaseContextManager purchaseContextManager) {
        this.ticketReservationManager = ticketReservationManager;
        this.purchaseContextManager = purchaseContextManager;
    }
}

