/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.payment.api;

import alfio.manager.PaymentManager;
import alfio.manager.PurchaseContextManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.support.PaymentResult;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.TransactionInitializationToken;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PaymentApiController {
    private final PaymentManager paymentManager;
    private final TicketReservationManager ticketReservationManager;
    private final PurchaseContextManager purchaseContextManager;

    @PostMapping(value={"/api/reservation/{reservationId}/payment/{method}/init", "/api/events/{eventName}/reservation/{reservationId}/payment/{method}/init"})
    public ResponseEntity<TransactionInitializationToken> initTransaction(@PathVariable String reservationId, @PathVariable(value="method") String paymentMethodStr, @RequestParam MultiValueMap<String, String> allParams) {
        PaymentMethod paymentMethod = PaymentMethod.safeParse((String)paymentMethodStr);
        if (paymentMethod == null) {
            return ResponseEntity.badRequest().build();
        }
        return this.getEventReservationPair(reservationId).flatMap(pair -> this.ticketReservationManager.initTransaction((PurchaseContext)pair.getLeft(), reservationId, paymentMethod, (Map)allParams)).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    private Optional<Pair<? extends PurchaseContext, TicketReservation>> getEventReservationPair(String reservationId) {
        return this.purchaseContextManager.findByReservationId(reservationId).map(event -> Pair.of((Object)event, (Object)this.ticketReservationManager.findById(reservationId))).filter(pair -> ((Optional)pair.getRight()).isPresent()).map(pair -> Pair.of((Object)((PurchaseContext)pair.getLeft()), (Object)((TicketReservation)((Optional)pair.getRight()).orElseThrow())));
    }

    @GetMapping(value={"/api/reservation/{reservationId}/payment/{method}/status", "/api/events/{eventName}/reservation/{reservationId}/payment/{method}/status"})
    public ResponseEntity<PaymentResult> getTransactionStatus(@PathVariable String reservationId, @PathVariable(value="method") String paymentMethodStr) {
        PaymentMethod paymentMethod = PaymentMethod.safeParse((String)paymentMethodStr);
        if (paymentMethod == null) {
            return ResponseEntity.badRequest().build();
        }
        return this.getEventReservationPair(reservationId).flatMap(pair -> this.paymentManager.getTransactionStatus((TicketReservation)pair.getRight(), paymentMethod)).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/api/v2/public/reservation/{reservationId}/transaction/force-check", "/api/v2/public/event/{eventName}/reservation/{reservationId}/transaction/force-check"})
    public ResponseEntity<PaymentResult> forceCheckStatus(@PathVariable String reservationId) {
        return ResponseEntity.of(this.getEventReservationPair(reservationId).flatMap(pair -> this.ticketReservationManager.forceTransactionCheck((PurchaseContext)pair.getLeft(), (TicketReservation)pair.getRight())));
    }

    @ConstructorProperties(value={"paymentManager", "ticketReservationManager", "purchaseContextManager"})
    @Generated
    public PaymentApiController(PaymentManager paymentManager, TicketReservationManager ticketReservationManager, PurchaseContextManager purchaseContextManager) {
        this.paymentManager = paymentManager;
        this.ticketReservationManager = ticketReservationManager;
        this.purchaseContextManager = purchaseContextManager;
    }
}

