/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.payment.api.mollie;

import alfio.manager.PurchaseContextManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.support.PaymentWebhookResult;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentProxy;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MolliePaymentWebhookController {
    private final TicketReservationManager ticketReservationManager;
    private final PurchaseContextManager purchaseContextManager;

    @PostMapping(value={"/api/payment/webhook/mollie/reservation/{reservationId}"})
    public ResponseEntity<String> receivePaymentConfirmation(HttpServletRequest request, @PathVariable String reservationId) {
        return Optional.ofNullable(StringUtils.trimToNull((String)request.getParameter("id"))).flatMap(id -> this.purchaseContextManager.findByReservationId(reservationId).map(purchaseContext -> {
            String content = "id=" + id;
            PaymentWebhookResult result = this.ticketReservationManager.processTransactionWebhook(content, null, PaymentProxy.MOLLIE, Map.of("purchaseContextType", purchaseContext.getType().getUrlComponent(), "purchaseContextPublicIdentifier", purchaseContext.getPublicIdentifier(), "reservationId", reservationId), new PaymentContext(purchaseContext, reservationId));
            if (result.isSuccessful()) {
                return ResponseEntity.ok((Object)"OK");
            }
            if (result.isError()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)result.getReason());
            }
            return ResponseEntity.ok((Object)result.getReason());
        })).orElseGet(() -> ResponseEntity.badRequest().body((Object)"NOK"));
    }

    @ConstructorProperties(value={"ticketReservationManager", "purchaseContextManager"})
    @Generated
    public MolliePaymentWebhookController(TicketReservationManager ticketReservationManager, PurchaseContextManager purchaseContextManager) {
        this.ticketReservationManager = ticketReservationManager;
        this.purchaseContextManager = purchaseContextManager;
    }
}

