/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.payment.api.saferpay;

import alfio.manager.PurchaseContextManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.support.PaymentWebhookResult;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentProxy;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SaferpayPaymentWebhookController {
    private final TicketReservationManager ticketReservationManager;
    private final PurchaseContextManager purchaseContextManager;

    @GetMapping(value={"/api/payment/webhook/saferpay/reservation/{reservationId}/success"})
    ResponseEntity<String> handleTransactionNotification(@PathVariable String reservationId) {
        return this.purchaseContextManager.findByReservationId(reservationId).map(purchaseContext -> {
            PaymentWebhookResult result = this.ticketReservationManager.processTransactionWebhook("", null, PaymentProxy.SAFERPAY, Map.of("purchaseContextType", purchaseContext.getType().getUrlComponent(), "purchaseContextIdentifier", purchaseContext.getPublicIdentifier(), "reservationId", reservationId), new PaymentContext(purchaseContext, reservationId));
            if (result.isSuccessful()) {
                return ResponseEntity.ok((Object)"OK");
            }
            if (result.isError()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)result.getReason());
            }
            return ResponseEntity.ok((Object)result.getReason());
        }).orElseGet(() -> ResponseEntity.badRequest().body((Object)"NOK"));
    }

    @ConstructorProperties(value={"ticketReservationManager", "purchaseContextManager"})
    @Generated
    public SaferpayPaymentWebhookController(TicketReservationManager ticketReservationManager, PurchaseContextManager purchaseContextManager) {
        this.ticketReservationManager = ticketReservationManager;
        this.purchaseContextManager = purchaseContextManager;
    }
}

