/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.payment.api.stripe;

import alfio.manager.TicketReservationManager;
import alfio.manager.support.PaymentWebhookResult;
import alfio.model.transaction.PaymentProxy;
import alfio.util.RequestUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StripePaymentWebhookController {
    private final TicketReservationManager ticketReservationManager;

    @PostMapping(value={"/api/payment/webhook/stripe/payment"})
    public ResponseEntity<String> receivePaymentConfirmation(@RequestHeader(value="Stripe-Signature") String stripeSignature, HttpServletRequest request) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json;charset=UTF-8");
        return RequestUtils.readRequest((HttpServletRequest)request).map(content -> {
            PaymentWebhookResult result = this.ticketReservationManager.processTransactionWebhook(content, stripeSignature, PaymentProxy.STRIPE, Map.of());
            if (result.isSuccessful()) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.OK).headers(httpHeaders)).body((Object)"OK");
            }
            if (result.isError()) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).headers(httpHeaders)).body((Object)result.getReason());
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.OK).headers(httpHeaders)).body((Object)result.getReason());
        }).orElseGet(() -> ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(httpHeaders)).body((Object)"Malformed request."));
    }

    @ConstructorProperties(value={"ticketReservationManager"})
    @Generated
    public StripePaymentWebhookController(TicketReservationManager ticketReservationManager) {
        this.ticketReservationManager = ticketReservationManager;
    }
}

