/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.support;

import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.system.ConfigurationKeys;
import jakarta.servlet.http.HttpServletResponse;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CSPConfigurer {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final ConfigurationManager configurationManager;

    public CSPConfigurer(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public String addCspHeader(HttpServletResponse response, boolean embeddingSupported) {
        return this.addCspHeader(response, ConfigurationLevel.system(), embeddingSupported);
    }

    public String addCspHeader(HttpServletResponse response, ConfigurationLevel configurationLevel, boolean embeddingSupported) {
        String nonce = CSPConfigurer.getNonce();
        Object reportUri = "";
        Map conf = this.configurationManager.getFor(List.of(ConfigurationKeys.SECURITY_CSP_REPORT_ENABLED, ConfigurationKeys.SECURITY_CSP_REPORT_URI, ConfigurationKeys.EMBED_ALLOWED_ORIGINS), configurationLevel);
        boolean enabledReport = ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.SECURITY_CSP_REPORT_ENABLED)).getValueAsBooleanOrDefault();
        if (enabledReport) {
            reportUri = " report-uri " + ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.SECURITY_CSP_REPORT_URI)).getValueOrDefault("/report-csp-violation");
        }
        String frameAncestors = "'none'";
        String allowedContainer = ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.EMBED_ALLOWED_ORIGINS)).getValueOrNull();
        if (embeddingSupported && StringUtils.isNotBlank((CharSequence)allowedContainer)) {
            CharSequence[] splitHosts = allowedContainer.split("[,\n]");
            frameAncestors = String.join((CharSequence)" ", splitHosts);
            response.addHeader("X-Frame-Options", "ALLOW-FROM " + (String)splitHosts[0]);
        } else {
            response.addHeader("X-Frame-Options", "DENY");
        }
        response.addHeader("Content-Security-Policy", "object-src 'none'; script-src 'strict-dynamic' 'nonce-" + nonce + "' 'unsafe-inline' http: https: 'unsafe-hashes' 'sha256-MhtPZXr7+LpJUY5qtMutB+qWfQtMaPccfe7QXtCcEYc='; base-uri 'self'; frame-ancestors " + frameAncestors + "; " + (String)reportUri);
        return nonce;
    }

    private static String getNonce() {
        byte[] nonce = new byte[16];
        SECURE_RANDOM.nextBytes(nonce);
        return Hex.encodeHexString((byte[])nonce);
    }
}

