/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.support;

import alfio.config.authentication.support.OpenIdPrincipal;
import alfio.controller.api.support.TicketHelper;
import alfio.controller.api.v2.model.EventWithAdditionalInfo;
import alfio.controller.api.v2.model.Language;
import alfio.controller.api.v2.user.support.EventLoader;
import alfio.controller.support.CSPConfigurer;
import alfio.manager.PurchaseContextManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.EventDescription;
import alfio.model.PurchaseContext;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.EventDescriptionRepository;
import alfio.repository.EventRepository;
import alfio.repository.FileUploadRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.util.ClockProvider;
import alfio.util.Json;
import alfio.util.MustacheCustomTag;
import alfio.util.RequestUtils;
import ch.digitalfondue.jfiveparse.Document;
import ch.digitalfondue.jfiveparse.Element;
import ch.digitalfondue.jfiveparse.Node;
import ch.digitalfondue.jfiveparse.Selector;
import ch.digitalfondue.jfiveparse.Text;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.collections4.IterableUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.util.UriUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DataPreloaderManager {
    private final ConfigurationManager configurationManager;
    private final CsrfTokenRepository csrfTokenRepository;
    private final EventLoader eventLoader;
    private final CSPConfigurer cspConfigurer;
    private final PurchaseContextManager purchaseContextManager;
    private final EventRepository eventRepository;
    private final MessageSourceManager messageSourceManager;
    private final OrganizationRepository organizationRepository;
    private final FileUploadRepository fileUploadRepository;
    private final EventDescriptionRepository eventDescriptionRepository;
    private final Json json;

    public DataPreloaderManager(ConfigurationManager configurationManager, CsrfTokenRepository csrfTokenRepository, EventLoader eventLoader, CSPConfigurer cspConfigurer, PurchaseContextManager purchaseContextManager, EventRepository eventRepository, MessageSourceManager messageSourceManager, OrganizationRepository organizationRepository, FileUploadRepository fileUploadRepository, EventDescriptionRepository eventDescriptionRepository, Json json) {
        this.configurationManager = configurationManager;
        this.csrfTokenRepository = csrfTokenRepository;
        this.eventLoader = eventLoader;
        this.cspConfigurer = cspConfigurer;
        this.purchaseContextManager = purchaseContextManager;
        this.eventRepository = eventRepository;
        this.messageSourceManager = messageSourceManager;
        this.organizationRepository = organizationRepository;
        this.fileUploadRepository = fileUploadRepository;
        this.eventDescriptionRepository = eventDescriptionRepository;
        this.json = json;
    }

    @Transactional
    public Document generateIndexDocument(String eventShortName, String subscriptionId, String userAgent, String lang, ServletWebRequest request, HttpServletResponse response, HttpSession session, Authentication authentication, Document openGraphPage, Document indexPage) {
        OpenIdPrincipal principal;
        OAuth2AuthenticationToken oauth;
        OAuth2User oAuth2User;
        String nonce = this.cspConfigurer.addCspHeader(response, this.detectConfigurationLevel(eventShortName, subscriptionId), true);
        if (eventShortName != null && RequestUtils.isSocialMediaShareUA((String)userAgent) && this.eventRepository.existsByShortName(eventShortName)) {
            return this.getOpenGraphPage((Document)openGraphPage.cloneNode(true), eventShortName, request, lang);
        }
        String baseCustomCss = this.configurationManager.getForSystem(ConfigurationKeys.BASE_CUSTOM_CSS).getValueOrNull();
        Document idx = (Document)indexPage.cloneNode(true);
        if (authentication instanceof OAuth2AuthenticationToken && (oAuth2User = (oauth = (OAuth2AuthenticationToken)authentication).getPrincipal()) instanceof OpenIdPrincipal && (principal = (OpenIdPrincipal)oAuth2User).isSignedUp() && session.isNew()) {
            Optional.ofNullable((Element)IterableUtils.get((Iterable)idx.getElementsByTagName("html"), (int)0)).ifPresent(html -> html.setAttribute("data-signed-up", "true"));
        }
        idx.getElementsByTagName("script").forEach(element -> element.setAttribute("nonce", nonce));
        Element head = (Element)idx.getElementsByTagName("head").get(0);
        head.appendChild((Node)DataPreloaderManager.buildScripTag((String)this.json.asJsonString((Object)this.configurationManager.getInfo(session)), (String)"application/json", (String)"preload-info", null));
        HttpServletRequest httpServletRequest = Objects.requireNonNull((HttpServletRequest)request.getNativeRequest(HttpServletRequest.class));
        head.appendChild((Node)DataPreloaderManager.buildMetaTag((String)"GID", (String)request.getSessionId()));
        CsrfToken csrf = this.csrfTokenRepository.loadToken(httpServletRequest);
        if (csrf == null) {
            csrf = this.csrfTokenRepository.generateToken(httpServletRequest);
        }
        head.appendChild((Node)DataPreloaderManager.buildMetaTag((String)"XSRF_TOKEN", (String)csrf.getToken()));
        if (baseCustomCss != null) {
            Element style = new Element("style");
            style.setAttribute("type", "text/css");
            style.appendChild((Node)new Text(baseCustomCss));
            head.appendChild((Node)style);
        }
        head.appendChild((Node)DataPreloaderManager.buildMetaTag((String)"authentication-enabled", (String)Boolean.toString(this.configurationManager.isPublicOpenIdEnabled())));
        DataPreloaderManager.preloadEventData((String)eventShortName, (ServletWebRequest)request, (HttpSession)session, (EventLoader)this.eventLoader, (Element)head, (MessageSourceManager)this.messageSourceManager, (Node)idx, (Json)this.json, (String)lang);
        return idx;
    }

    private ConfigurationLevel detectConfigurationLevel(String eventShortName, String subscriptionId) {
        return this.purchaseContextManager.detectConfigurationLevel(eventShortName, subscriptionId).orElseGet(ConfigurationLevel::system);
    }

    private Document getOpenGraphPage(Document eventOpenGraph, String eventShortName, ServletWebRequest request, String lang) {
        Event event = this.eventRepository.findByShortName(eventShortName);
        Locale locale = DataPreloaderManager.getMatchingLocale((ServletWebRequest)request, event.getContentLanguages().stream().map(ContentLanguage::getLanguage).toList(), (String)lang);
        String baseUrl = this.configurationManager.getForSystem(ConfigurationKeys.BASE_URL).getRequiredValue();
        String title = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event).getMessage("event.get-your-ticket-for", (Object[])new String[]{event.getDisplayName()}, locale);
        Element head = (Element)eventOpenGraph.getElementsByTagName("head").get(0);
        ((Element)eventOpenGraph.getElementsByTagName("html").get(0)).setAttribute("lang", locale.getLanguage());
        DataPreloaderManager.getMetaElement((Document)eventOpenGraph, (String)"name", (String)"twitter:image").setAttribute("content", baseUrl + "/file/" + event.getFileBlobId());
        ((Element)eventOpenGraph.getElementsByTagName("title").get(0)).appendChild((Node)new Text(title));
        DataPreloaderManager.getMetaElement((Document)eventOpenGraph, (String)"property", (String)"og:title").setAttribute("content", title);
        DataPreloaderManager.getMetaElement((Document)eventOpenGraph, (String)"property", (String)"og:image").setAttribute("content", baseUrl + "/file/" + event.getFileBlobId());
        String eventDesc = this.eventDescriptionRepository.findDescriptionByEventIdTypeAndLocale(event.getId(), EventDescription.EventDescriptionType.DESCRIPTION, locale.toLanguageTag()).orElse("").trim();
        String firstLine = Pattern.compile("\n").splitAsStream(MustacheCustomTag.renderToTextCommonmark((String)eventDesc)).findFirst().orElse("");
        DataPreloaderManager.getMetaElement((Document)eventOpenGraph, (String)"property", (String)"og:description").setAttribute("content", firstLine);
        Organization org = this.organizationRepository.getById(event.getOrganizationId());
        String author = String.format("%s <%s>", org.getName(), org.getEmail());
        DataPreloaderManager.getMetaElement((Document)eventOpenGraph, (String)"name", (String)"author").setAttribute("content", author);
        this.fileUploadRepository.findById(event.getFileBlobId()).ifPresent(metadata -> {
            Map attributes = metadata.getAttributes();
            if (attributes.containsKey("height") && attributes.containsKey("width")) {
                head.appendChild((Node)DataPreloaderManager.buildOGMetaTag((String)"og:image:width", (String)((String)attributes.get("width"))));
                head.appendChild((Node)DataPreloaderManager.buildOGMetaTag((String)"og:image:height", (String)((String)attributes.get("height"))));
            }
        });
        return eventOpenGraph;
    }

    private static Element buildOGMetaTag(String propertyValue, String contentValue) {
        return DataPreloaderManager.buildMetaTag((String)"property", (String)propertyValue, (String)contentValue);
    }

    private static Element buildMetaTag(String name, String content) {
        return DataPreloaderManager.buildMetaTag((String)"name", (String)name, (String)content);
    }

    private static Element buildMetaTag(String property, String propertyValue, String content) {
        Element meta = new Element("meta");
        meta.setAttribute(property, propertyValue);
        meta.setAttribute("content", content);
        return meta;
    }

    private static Element getMetaElement(Document document, String attrName, String propertyValue) {
        return (Element)document.getAllNodesMatching(Selector.select().element("meta").attrValEq(attrName, propertyValue).toMatcher(), true).get(0);
    }

    private static Locale getMatchingLocale(ServletWebRequest request, List<String> contextLanguages, String lang) {
        Locale locale = RequestUtils.getMatchingLocale((ServletWebRequest)request, contextLanguages);
        if (lang != null) {
            if (contextLanguages.stream().anyMatch(lang::equalsIgnoreCase)) {
                locale = Locale.forLanguageTag(lang);
            }
        }
        return locale;
    }

    private static Element buildScripTag(String content, String type, String id, String param) {
        String encodedContent = UriUtils.encodeFragment((String)content, (Charset)StandardCharsets.UTF_8);
        Element e = new Element("script");
        e.appendChild((Node)new Text(encodedContent));
        e.setAttribute("type", type);
        e.setAttribute("id", id);
        if (param != null) {
            e.setAttribute("data-param", param);
        }
        return e;
    }

    public static void preloadEventData(String eventShortName, ServletWebRequest request, HttpSession session, EventLoader eventLoader, Element head, MessageSourceManager messageSourceManager, Node idx, Json json, String lang) {
        Optional eventInfoOptional;
        String preloadLang = Objects.requireNonNullElse(lang, "en");
        if (eventShortName != null && (eventInfoOptional = eventLoader.loadEventInfo(eventShortName, session)).isPresent()) {
            EventWithAdditionalInfo ev = (EventWithAdditionalInfo)eventInfoOptional.get();
            head.appendChild((Node)DataPreloaderManager.buildScripTag((String)json.asJsonString((Object)ev), (String)"application/json", (String)"preload-event", (String)eventShortName));
            preloadLang = DataPreloaderManager.getMatchingLocale((ServletWebRequest)request, ev.getContentLanguages().stream().map(Language::getLocale).toList(), (String)lang).getLanguage();
            if (ZonedDateTime.now(ClockProvider.clock()).isAfter(((Event)ev.purchaseContext()).getEnd())) {
                head.appendChild((Node)DataPreloaderManager.buildMetaTag((String)"robots", (String)"noindex"));
            }
        }
        head.appendChild((Node)DataPreloaderManager.buildScripTag((String)json.asJsonString((Object)messageSourceManager.getBundleAsMap("alfio.i18n.public", true, preloadLang, MessageSourceManager.PUBLIC_FRONTEND)), (String)"application/json", (String)"preload-bundle", (String)preloadLang));
        head.appendChild((Node)DataPreloaderManager.buildScripTag((String)DataPreloaderManager.countriesForVatAsJson((Json)json, (String)preloadLang), (String)"application/json", (String)"preload-vat-countries", (String)preloadLang));
        head.appendChild((Node)DataPreloaderManager.buildScripTag((String)DataPreloaderManager.countriesAsJson((Json)json, (String)preloadLang), (String)"application/json", (String)"preload-countries", (String)preloadLang));
        if (!"en".equals(preloadLang)) {
            head.appendChild((Node)DataPreloaderManager.buildScripTag((String)json.asJsonString((Object)messageSourceManager.getBundleAsMap("alfio.i18n.public", true, "en", MessageSourceManager.PUBLIC_FRONTEND)), (String)"application/json", (String)"preload-bundle", (String)"en"));
        }
        Element htmlElement = (Element)IterableUtils.get((Iterable)idx.getElementsByTagName("html"), (int)0);
        htmlElement.setAttribute("lang", preloadLang);
    }

    private static String countriesForVatAsJson(Json json, String preloadLang) {
        return json.asJsonString((Object)TicketHelper.getSortedLocalizedVatCountries((Locale)Locale.forLanguageTag(preloadLang)));
    }

    private static String countriesAsJson(Json json, String preloadLang) {
        return json.asJsonString((Object)TicketHelper.getSortedLocalizedCountries((Locale)Locale.forLanguageTag(preloadLang)));
    }
}

